/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.info;

import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.api.info.IPageIconRenderer;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiInfo;
import com.feed_the_beast.ftbl.lib.info.InfoPage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ITextComponent;

public class ButtonInfoPage
extends Button {
    public final InfoPage page;
    public String hover;
    public IPageIconRenderer iconRenderer;
    private boolean prevMouseOver = false;

    public ButtonInfoPage(GuiInfo g, InfoPage p, @Nullable IPageIconRenderer t) {
        super(0, 0, 0, 0);
        this.setWidth(g.panelWidth - 36);
        this.setHeight(t == null ? 13 : 18);
        this.page = p;
        this.iconRenderer = t;
        this.updateTitle(g);
    }

    @Override
    public void onClicked(GuiBase gui, IMouseButton button) {
        GuiHelper.playClickSound();
        ((GuiInfo)gui).setSelectedPage(this.page);
    }

    public void updateTitle(GuiInfo gui) {
        ITextComponent titleC = this.page.getDisplayName().func_150259_f();
        if (gui.getSelectedPage() == this.page) {
            titleC.func_150256_b().func_150227_a(Boolean.valueOf(true));
        }
        if (gui.isMouseOver(this)) {
            titleC.func_150256_b().func_150228_d(Boolean.valueOf(true));
        }
        this.setTitle(titleC.func_150254_d());
        this.hover = null;
        if (gui.getFont().func_78256_a(this.getTitle(gui)) > this.width) {
            this.hover = this.page.getDisplayName().func_150254_d();
        }
    }

    @Override
    public void addMouseOverText(GuiBase gui, List<String> list) {
        if (this.hover != null) {
            list.add(this.hover);
        }
    }

    @Override
    public void renderWidget(GuiBase gui) {
        boolean mouseOver = gui.isMouseOver(this);
        if (this.prevMouseOver != mouseOver) {
            this.updateTitle((GuiInfo)gui);
            this.prevMouseOver = mouseOver;
        }
        int ay = this.getAY();
        int ax = this.getAX();
        if (this.iconRenderer != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.iconRenderer.renderIcon(gui, this, ax + 1, ay + 1);
            gui.drawString(this.getTitle(gui), ax + 19, ay + 6);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.drawString(this.getTitle(gui), ax + 1, ay + 1);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

