/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.info;

import com.feed_the_beast.ftbl.api.info.IInfoTextLine;
import com.feed_the_beast.ftbl.lib.gui.EnumDirection;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiInfo;
import com.feed_the_beast.ftbl.lib.info.EmptyInfoPageLine;
import com.feed_the_beast.ftbl.lib.info.InfoPage;
import com.feed_the_beast.ftbl.lib.info.InfoPageHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.IStringSerializable;

public class InfoListLine
extends EmptyInfoPageLine {
    private final List<IInfoTextLine> textLines;
    private final Type type;
    private final int spacing;

    public InfoListLine(InfoPage p, JsonElement json) {
        this.textLines = new ArrayList<IInfoTextLine>();
        if (json.isJsonObject()) {
            JsonObject o = json.getAsJsonObject();
            if (o.has("list")) {
                for (JsonElement element : o.get("list").getAsJsonArray()) {
                    IInfoTextLine line = InfoPageHelper.createLine(p, element);
                    if (line == null) continue;
                    this.textLines.add(line);
                }
            }
            this.type = o.has("type") ? Type.get(o.get("type").getAsString()) : Type.UNORDERED;
            this.spacing = o.has("spacing") ? o.get("spacing").getAsInt() : 0;
        } else {
            for (JsonElement element : json.getAsJsonArray()) {
                IInfoTextLine line = InfoPageHelper.createLine(p, element);
                if (line == null) continue;
                this.textLines.add(line);
            }
            this.type = Type.UNORDERED;
            this.spacing = 0;
        }
    }

    public InfoListLine(List<IInfoTextLine> l, Type t, int s) {
        this.textLines = l;
        this.type = t;
        this.spacing = s;
    }

    @Override
    public Widget createWidget(GuiBase gui, Panel parent) {
        return new PanelList((GuiInfo)gui, parent.hasFlag(4));
    }

    @Override
    public IInfoTextLine copy(InfoPage page) {
        InfoListLine line = new InfoListLine(new ArrayList<IInfoTextLine>(this.textLines.size()), this.type, this.spacing);
        for (IInfoTextLine line1 : this.textLines) {
            line.textLines.add(line1.copy(page));
        }
        return line;
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive("list"));
        o.add("type", (JsonElement)new JsonPrimitive(this.type.name));
        JsonArray a = new JsonArray();
        for (IInfoTextLine line : this.textLines) {
            a.add(line.getJson());
        }
        o.add("list", (JsonElement)a);
        return o;
    }

    @Override
    public boolean isEmpty() {
        for (IInfoTextLine line : this.textLines) {
            if (line.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private class PanelList
    extends Panel {
        private final GuiInfo gui;

        private PanelList(GuiInfo g, boolean unicodeFont) {
            super(0, 0, 0, 0);
            this.gui = g;
            if (unicodeFont) {
                this.addFlags(4);
            }
        }

        @Override
        public void addWidgets() {
            this.setWidth(this.gui.panelText.width - (this.getAX() - this.gui.panelText.getAX()) - (((InfoListLine)InfoListLine.this).type.hasBullet ? 8 : 0));
            for (IInfoTextLine line : InfoListLine.this.textLines) {
                Widget widget = line.createWidget(this.gui, this);
                if (((InfoListLine)InfoListLine.this).type.hasBullet) {
                    widget.setX(widget.posX + 8);
                }
                this.add(widget);
            }
            this.updateWidgetPositions();
        }

        @Override
        public void updateWidgetPositions() {
            this.setHeight(this.alignWidgets(((InfoListLine)InfoListLine.this).type.direction, 0, InfoListLine.this.spacing, 0));
            if (((InfoListLine)InfoListLine.this).type.direction.isHorizontal()) {
                int h = 0;
                for (Widget w : this.getWidgets()) {
                    h = Math.max(h, w.height);
                }
                this.setHeight(h);
            }
        }

        @Override
        protected void renderWidget(GuiBase gui, Widget widget, int ax, int ay, int w, int h) {
            widget.renderWidget(gui);
            if (((InfoListLine)InfoListLine.this).type.hasBullet && widget.getClass() != Widget.class && !(widget instanceof PanelList)) {
                GuiInfo.TEX_BULLET.draw(ax + 1, widget.getAY() + 3, 4, 4, gui.getContentColor());
            }
        }
    }

    public static enum Type implements IStringSerializable
    {
        SIMPLE("simple", EnumDirection.VERTICAL, false),
        UNORDERED("unordered", EnumDirection.VERTICAL, true),
        ORDERED("ordered", EnumDirection.VERTICAL, true),
        ORDERED_LETTER("ordered_letter", EnumDirection.VERTICAL, true),
        HORIZONTAL("horizontal", EnumDirection.HORIZONTAL, false);

        private static final Map<String, Type> MAP;
        private final String name;
        public final EnumDirection direction;
        public final boolean hasBullet;

        private Type(String s, EnumDirection d, boolean b) {
            this.name = s;
            this.direction = d;
            this.hasBullet = b;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static Type get(String s) {
            Type t = MAP.get(s);
            return t == null ? UNORDERED : t;
        }

        static {
            MAP = new HashMap<String, Type>();
            for (Type t : Type.values()) {
                MAP.put(t.name, t);
            }
        }
    }
}

