/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.info;

import com.feed_the_beast.ftbl.api.info.IPageIconRenderer;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftbl.lib.util.LMInvUtils;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemPageIconRenderer
implements IPageIconRenderer {
    private List<ItemStack> items;

    public ItemPageIconRenderer(ItemStack is) {
        this.items = Collections.singletonList(is);
    }

    public ItemPageIconRenderer(Item item) {
        this.items = new ArrayList<ItemStack>();
        try {
            item.func_150895_a(item, CreativeTabs.field_78027_g, this.items);
        }
        catch (Exception ex) {
            this.items.clear();
        }
    }

    public ItemPageIconRenderer(JsonElement json) {
        try {
            if (json.isJsonArray()) {
                this.items = new ArrayList<ItemStack>(json.getAsJsonArray().size());
                for (JsonElement e : json.getAsJsonArray()) {
                    this.items.add(ItemStackSerializer.parseItem(e.getAsString()));
                }
            } else {
                this.items = Collections.singletonList(ItemStackSerializer.parseItem(json.getAsString()));
            }
        }
        catch (Exception ex) {
            this.items = Collections.singletonList(LMInvUtils.ERROR_ITEM);
        }
    }

    @Override
    public void renderIcon(GuiBase gui, Widget widget, int x, int y) {
        if (!this.items.isEmpty()) {
            GuiHelper.drawItem(Minecraft.func_71410_x().func_175599_af(), this.items.get((int)(System.currentTimeMillis() / 1000L % (long)this.items.size())), x, y, true);
        }
    }
}

