/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.ThrowableImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ForgeHooks {
    static final List<SeedEntry> seedList = new ArrayList<SeedEntry>();
    private static boolean toolInit = false;
    static final Pattern URL_PATTERN;
    private static ThreadLocal<zs> craftingPlayer;
    private static ThreadLocal<Deque<LootTableContext>> lootContext;

    public static adz getGrassSeed(Random rand, int fortune) {
        SeedEntry entry = (SeedEntry)ox.a((Random)rand, seedList);
        if (entry == null || entry.seed == null) {
            return null;
        }
        return entry.getStack(rand, fortune);
    }

    public static boolean canHarvestBlock(akf block, zs player, aih world, cm pos) {
        ars state = world.o(pos);
        if ((state = state.t().b(state, world, pos)).a().l()) {
            return true;
        }
        adz stack = player.bt.h();
        String tool = block.getHarvestTool(state);
        if (stack == null || tool == null) {
            return player.b(state);
        }
        int toolLevel = stack.b().getHarvestLevel(stack, tool, player, state);
        if (toolLevel < 0) {
            return player.b(state);
        }
        return toolLevel >= block.getHarvestLevel(state);
    }

    public static boolean canToolHarvestBlock(aih world, cm pos, adz stack) {
        ars state = world.o(pos);
        state = state.t().b(state, world, pos);
        String tool = state.t().getHarvestTool(state);
        if (stack == null || tool == null) {
            return false;
        }
        return stack.b().getHarvestLevel(stack, tool, null, null) >= state.t().getHarvestLevel(state);
    }

    public static float blockStrength(ars state, zs player, aid world, cm pos) {
        float hardness = state.b(world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(state.t(), player, (aih)world, pos)) {
            return player.getDigSpeed(state, pos) / hardness / 100.0f;
        }
        return player.getDigSpeed(state, pos) / hardness / 30.0f;
    }

    public static boolean isToolEffective(aih world, cm pos, adz stack) {
        ars state = world.o(pos);
        state = state.t().b(state, world, pos);
        for (String type : stack.b().getToolClasses(stack)) {
            if (!state.t().isToolEffective(type, state)) continue;
            return true;
        }
        return false;
    }

    static void initTools() {
        akf[] oreBlocks;
        if (toolInit) {
            return;
        }
        toolInit = true;
        Set blocks = (Set)ReflectionHelper.getPrivateValue(aek.class, null, 0);
        for (akf block : blocks) {
            block.setHarvestLevel("pickaxe", 0);
        }
        blocks = (Set)ReflectionHelper.getPrivateValue(aew.class, null, 0);
        for (akf block : blocks) {
            block.setHarvestLevel("shovel", 0);
        }
        blocks = (Set)ReflectionHelper.getPrivateValue(aci.class, null, 0);
        for (akf block : blocks) {
            block.setHarvestLevel("axe", 0);
        }
        akg.Z.setHarvestLevel("pickaxe", 3);
        akg.bC.setHarvestLevel("pickaxe", 0);
        for (akf block : oreBlocks = new akf[]{akg.bP, akg.bT, akg.ag, akg.ah, akg.o, akg.R, akg.aC, akg.aD}) {
            block.setHarvestLevel("pickaxe", 2);
        }
        akg.p.setHarvestLevel("pickaxe", 1);
        akg.S.setHarvestLevel("pickaxe", 1);
        akg.x.setHarvestLevel("pickaxe", 1);
        akg.y.setHarvestLevel("pickaxe", 1);
        akg.co.setHarvestLevel("pickaxe", 0);
    }

    public static int getTotalArmorValue(zs player) {
        int ret = 0;
        for (int x = 0; x < player.bt.b.length; ++x) {
            adz stack = player.bt.b[x];
            if (stack != null && stack.b() instanceof ISpecialArmor) {
                ret += ((ISpecialArmor)stack.b()).getArmorDisplay(player, stack, x);
                continue;
            }
            if (stack == null || !(stack.b() instanceof acf)) continue;
            ret += ((acf)stack.b()).d;
        }
        return ret;
    }

    public static boolean onPickBlock(bbz target, zs player, aid world) {
        adz result = null;
        boolean isCreative = player.bL.d;
        aqk te = null;
        if (target.a == bbz.a.b) {
            ars state = world.o(target.a());
            if (state.t().isAir(state, (aih)world, target.a())) {
                return false;
            }
            if (isCreative && bft.q() && state.t().hasTileEntity(state)) {
                te = world.r(target.a());
            }
            result = state.t().getPickBlock(state, target, world, target.a(), player);
        } else {
            if (target.a != bbz.a.c || target.d == null || !isCreative) {
                return false;
            }
            result = target.d.getPickedResult(target);
        }
        if (result == null) {
            return false;
        }
        if (result.b() == null) {
            String s1 = "";
            if (target.a == bbz.a.b) {
                s1 = ((kn)akf.h.b((Object)world.o(target.a()).t())).toString();
            } else if (target.a == bbz.a.c) {
                s1 = ry.b((rw)target.d);
            }
            FMLLog.warning("Picking on: [%s] %s gave null item", target.a, s1);
            return true;
        }
        if (te != null) {
            bcx.z().a(result, te);
        }
        if (isCreative) {
            player.bt.a(result);
            bcx.z().c.a(player.b(qr.a), 36 + player.bt.d);
            return true;
        }
        int slot = player.bt.b(result);
        if (slot != -1) {
            if (zr.e((int)slot)) {
                player.bt.d = slot;
            } else {
                bcx.z().c.a(slot);
            }
            return true;
        }
        return false;
    }

    public static void onLivingSetAttackTarget(sf entity, sf target) {
        MinecraftForge.EVENT_BUS.post(new LivingSetAttackTargetEvent(entity, target));
    }

    public static boolean onLivingUpdate(sf entity) {
        return MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingUpdateEvent(entity));
    }

    public static boolean onLivingAttack(sf entity, rh src, float amount) {
        return !MinecraftForge.EVENT_BUS.post(new LivingAttackEvent(entity, src, amount));
    }

    public static float onLivingHurt(sf entity, rh src, float amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.getAmount();
    }

    public static boolean onLivingDeath(sf entity, rh src) {
        return MinecraftForge.EVENT_BUS.post(new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(sf entity, rh source, ArrayList<yk> drops, int lootingLevel, boolean recentlyHit) {
        return MinecraftForge.EVENT_BUS.post(new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit));
    }

    public static float[] onLivingFall(sf entity, float distance, float damageMultiplier) {
        float[] fArray;
        LivingFallEvent event = new LivingFallEvent(entity, distance, damageMultiplier);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            fArray = null;
        } else {
            float[] fArray2 = new float[2];
            fArray2[0] = event.getDistance();
            fArray = fArray2;
            fArray2[1] = event.getDamageMultiplier();
        }
        return fArray;
    }

    public static int getLootingLevel(rw target, rw killer, rh cause) {
        int looting = 0;
        if (killer instanceof sf) {
            looting = agx.h((sf)((sf)killer));
        }
        if (target instanceof sf) {
            looting = ForgeHooks.getLootingLevel((sf)target, cause, looting);
        }
        return looting;
    }

    public static int getLootingLevel(sf target, rh cause, int level) {
        LootingLevelEvent event = new LootingLevelEvent(target, cause, level);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getLootingLevel();
    }

    public static double getPlayerVisibilityDistance(zs player, double xzDistance, double maxXZDistance) {
        PlayerEvent.Visibility event = new PlayerEvent.Visibility(player);
        MinecraftForge.EVENT_BUS.post(event);
        double value = event.getVisibilityModifier() * xzDistance;
        return value >= maxXZDistance ? maxXZDistance : value;
    }

    public static boolean isLivingOnLadder(ars state, aid world, cm pos, sf entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof zs && ((zs)entity).y();
        if (isSpectator) {
            return false;
        }
        if (!ForgeModContainer.fullBoundingBoxLadders) {
            return state != null && state.t().isLadder(state, (aih)world, pos, entity);
        }
        bby bb = entity.bo();
        int mX = op.c((double)bb.a);
        int mY = op.c((double)bb.b);
        int mZ = op.c((double)bb.c);
        int y2 = mY;
        while ((double)y2 < bb.e) {
            int x2 = mX;
            while ((double)x2 < bb.d) {
                int z2 = mZ;
                while ((double)z2 < bb.f) {
                    cm tmp = new cm(x2, y2, z2);
                    state = world.o(tmp);
                    if (state.t().isLadder(state, (aih)world, tmp, entity)) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    public static void onLivingJump(sf entity) {
        MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingJumpEvent(entity));
    }

    public static yk onPlayerTossEvent(zs player, adz item, boolean includeName) {
        player.captureDrops = true;
        yk ret = player.a(item, false, includeName);
        player.capturedDrops.clear();
        player.captureDrops = false;
        if (ret == null) {
            return null;
        }
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        if (!player.l.E) {
            player.e().a((rw)event.getEntityItem());
        }
        return event.getEntityItem();
    }

    public static float getEnchantPower(aid world, cm pos) {
        return world.o(pos).t().getEnchantPowerBonus(world, pos);
    }

    public static ey onServerChatEvent(me net, String raw, ey comp) {
        ServerChatEvent event = new ServerChatEvent(net.b, raw, comp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.getComponent();
    }

    public static ey newChatWithLinks(String string) {
        return ForgeHooks.newChatWithLinks(string, true);
    }

    public static ey newChatWithLinks(String string, boolean allowMissingHeader) {
        fe ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            fe link;
            String url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = new fe(part);
                    } else {
                        ichat.a(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = new fe(url);
                try {
                    if (new URI(url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = new fe(url);
                            continue;
                        }
                        ichat.a(url);
                        continue;
                    }
                    url = "http://" + url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = new fe(url);
                        continue;
                    }
                    ichat.a(url);
                    continue;
                }
            }
            ex click = new ex(ex.a.a, url);
            link.b().a(click);
            link.b().d(Boolean.valueOf(true));
            link.b().a(a.j);
            if (ichat == null) {
                ichat = link;
                continue;
            }
            ichat.a((ey)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = new fe(end);
        } else if (end.length() > 0) {
            ichat.a(string.substring(lastEnd));
        }
        return ichat;
    }

    public static int onBlockBreakEvent(aid world, aib gameType, lu entityPlayer, cm pos) {
        boolean preCancelEvent = false;
        if (gameType.d() && entityPlayer.cf() != null && entityPlayer.cf().b() instanceof afg) {
            preCancelEvent = true;
        }
        if (gameType.c()) {
            adz itemstack;
            if (gameType == aib.e) {
                preCancelEvent = true;
            }
            if (!(entityPlayer.cZ() || (itemstack = entityPlayer.cf()) != null && itemstack.a(world.o(pos).t()))) {
                preCancelEvent = true;
            }
        }
        if (world.r(pos) == null) {
            fy packet = new fy(world, pos);
            packet.b = akg.a.u();
            entityPlayer.a.a((fj)packet);
        }
        ars state = world.o(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (zs)entityPlayer);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled()) {
            fw pkt;
            entityPlayer.a.a((fj)new fy(world, pos));
            aqk tileentity = world.r(pos);
            if (tileentity != null && (pkt = tileentity.D_()) != null) {
                entityPlayer.a.a((fj)pkt);
            }
        }
        return event.isCanceled() ? -1 : event.getExpToDrop();
    }

    public static qt onPlaceItemIntoWorld(adz itemstack, zs player, aid world, cm pos, ct side, float hitX, float hitY, float hitZ, qr hand) {
        int meta = itemstack.h();
        int size = itemstack.b;
        dr nbt = null;
        if (itemstack.o() != null) {
            nbt = itemstack.o().g();
        }
        if (!(itemstack.b() instanceof acs)) {
            world.captureBlockSnapshots = true;
        }
        qt ret = itemstack.b().a(itemstack, player, world, pos, hand, side, hitX, hitY, hitZ);
        world.captureBlockSnapshots = false;
        if (ret == qt.a) {
            int newMeta = itemstack.h();
            int newSize = itemstack.b;
            dr newNBT = null;
            if (itemstack.o() != null) {
                newNBT = itemstack.o().g();
            }
            BlockEvent.PlaceEvent placeEvent = null;
            List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
            world.capturedBlockSnapshots.clear();
            itemstack.b(meta);
            itemstack.b = size;
            if (nbt != null) {
                itemstack.d(nbt);
            }
            if (blockSnapshots.size() > 1) {
                placeEvent = ForgeEventFactory.onPlayerMultiBlockPlace(player, blockSnapshots, side, hand);
            } else if (blockSnapshots.size() == 1) {
                placeEvent = ForgeEventFactory.onPlayerBlockPlace(player, (BlockSnapshot)blockSnapshots.get(0), side, hand);
            }
            if (placeEvent != null && placeEvent.isCanceled()) {
                ret = qt.c;
                for (BlockSnapshot blocksnapshot : blockSnapshots) {
                    world.restoringBlockSnapshots = true;
                    blocksnapshot.restore(true, false);
                    world.restoringBlockSnapshots = false;
                }
            } else {
                itemstack.b(newMeta);
                itemstack.b = newSize;
                if (nbt != null) {
                    itemstack.d(newNBT);
                }
                for (BlockSnapshot snap : blockSnapshots) {
                    int updateFlag = snap.getFlag();
                    ars oldBlock = snap.getReplacedBlock();
                    ars newBlock = world.o(snap.getPos());
                    if (newBlock != null && !newBlock.t().hasTileEntity(newBlock)) {
                        newBlock.t().c(world, snap.getPos(), newBlock);
                    }
                    world.markAndNotifyBlock(snap.getPos(), null, oldBlock, newBlock, updateFlag);
                }
                player.b(nw.b((adx)itemstack.b()));
            }
        }
        world.capturedBlockSnapshots.clear();
        return ret;
    }

    public static boolean onAnvilChange(abf container, adz left, adz right, ql outputSlot, String name, int baseCost) {
        AnvilUpdateEvent e = new AnvilUpdateEvent(left, right, name, baseCost);
        if (MinecraftForge.EVENT_BUS.post(e)) {
            return false;
        }
        if (e.getOutput() == null) {
            return true;
        }
        outputSlot.a(0, e.getOutput());
        container.a = e.getCost();
        container.k = e.getMaterialCost();
        return false;
    }

    public static float onAnvilRepair(zs player, adz output, adz left, adz right) {
        AnvilRepairEvent e = new AnvilRepairEvent(player, left, right, output);
        MinecraftForge.EVENT_BUS.post(e);
        return e.getBreakChance();
    }

    public static boolean onNoteChange(ara te, byte old) {
        NoteBlockEvent.Change e = new NoteBlockEvent.Change(te.D(), te.v(), te.D().o(te.v()), old, te.a);
        if (MinecraftForge.EVENT_BUS.post(e)) {
            te.a = old;
            return false;
        }
        te.a = (byte)e.getVanillaNoteId();
        return true;
    }

    public static adz[] defaultRecipeGetRemainingItems(abl inv) {
        adz[] ret = new adz[inv.u_()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ForgeHooks.getContainerItem(inv.a(i));
        }
        return ret;
    }

    public static void setCraftingPlayer(zs player) {
        craftingPlayer.set(player);
    }

    public static zs getCraftingPlayer() {
        return craftingPlayer.get();
    }

    public static adz getContainerItem(adz stack) {
        if (stack == null) {
            return null;
        }
        if (stack.b().hasContainerItem(stack)) {
            if ((stack = stack.b().getContainerItem(stack)) != null && stack.e() && stack.i() > stack.j()) {
                ForgeEventFactory.onPlayerDestroyItem(craftingPlayer.get(), stack, null);
                return null;
            }
            return stack;
        }
        return null;
    }

    public static boolean isInsideOfMaterial(axx material, rw entity, cm pos) {
        ars state = entity.l.o(pos);
        akf block = state.t();
        double eyes = entity.q + (double)entity.bq();
        double filled = 1.0;
        if (block instanceof IFluidBlock) {
            filled = ((IFluidBlock)block).getFilledPercentage(entity.l, pos);
        } else if (block instanceof anb) {
            filled = anb.e((int)block.e(state));
        }
        if (filled < 0.0) {
            return eyes > (double)(pos.q() + 1) + (1.0 - (filled *= -1.0));
        }
        return eyes < (double)(pos.q() + 1) + filled;
    }

    public static boolean onPlayerAttackTarget(zs player, rw target) {
        if (MinecraftForge.EVENT_BUS.post(new AttackEntityEvent(player, target))) {
            return false;
        }
        adz stack = player.cf();
        return stack == null || !stack.b().onLeftClickEntity(stack, player, target);
    }

    public static boolean onTravelToDimension(rw entity, int dimension) {
        EntityTravelToDimensionEvent event = new EntityTravelToDimensionEvent(entity, dimension);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled() && entity instanceof aat) {
            ((aat)entity).b = true;
        }
        return !event.isCanceled();
    }

    public static bbz rayTraceEyes(sf entity, double length) {
        bcb startPos = new bcb(entity.p, entity.q + (double)entity.bq(), entity.r);
        bcb endPos = startPos.e(new bcb(entity.aB().b * length, entity.aB().c * length, entity.aB().d * length));
        return entity.l.a(startPos, endPos);
    }

    public static bcb rayTraceEyeHitVec(sf entity, double length) {
        bbz git = ForgeHooks.rayTraceEyes(entity, length);
        return git == null ? null : git.c;
    }

    public static boolean onInteractEntityAt(zs player, rw entity, bbz ray, adz stack, qr hand) {
        bcb vec3d = new bcb(ray.c.b - entity.p, ray.c.c - entity.q, ray.c.d - entity.r);
        return ForgeHooks.onInteractEntityAt(player, entity, vec3d, stack, hand);
    }

    public static boolean onInteractEntityAt(zs player, rw entity, bcb vec3d, adz stack, qr hand) {
        return MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.EntityInteractSpecific(player, hand, stack, entity, vec3d));
    }

    public static boolean onInteractEntity(zs player, rw entity, adz item, qr hand) {
        return MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.EntityInteract(player, hand, item, entity));
    }

    public static boolean onItemRightClick(zs player, qr hand, adz stack) {
        return MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.RightClickItem(player, hand, stack));
    }

    public static PlayerInteractEvent.LeftClickBlock onLeftClickBlock(zs player, cm pos, ct face, bcb hitVec) {
        PlayerInteractEvent.LeftClickBlock evt = new PlayerInteractEvent.LeftClickBlock(player, pos, face, hitVec);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt;
    }

    public static PlayerInteractEvent.RightClickBlock onRightClickBlock(zs player, qr hand, adz stack, cm pos, ct face, bcb hitVec) {
        PlayerInteractEvent.RightClickBlock evt = new PlayerInteractEvent.RightClickBlock(player, hand, stack, pos, face, hitVec);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt;
    }

    public static void onEmptyClick(zs player, qr hand) {
        MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.RightClickEmpty(player, hand));
    }

    public static void onEmptyLeftClick(zs player, adz stack) {
        MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.LeftClickEmpty(player, stack));
    }

    private static LootTableContext getLootTableContext() {
        LootTableContext ctx = lootContext.get().peek();
        if (ctx == null) {
            throw new JsonParseException("Invalid call stack, could to grab json context!");
        }
        return ctx;
    }

    public static bap loadLootTable(Gson gson, kn name, String data, boolean custom) {
        ArrayDeque que = lootContext.get();
        if (que == null) {
            que = Queues.newArrayDeque();
            lootContext.set(que);
        }
        bap ret = null;
        try {
            que.push(new LootTableContext(name, custom));
            ret = (bap)gson.fromJson(data, bap.class);
            que.pop();
        }
        catch (JsonParseException e) {
            que.pop();
            throw e;
        }
        if (!custom) {
            ret = ForgeEventFactory.loadLootTable(name, ret);
        }
        if (ret != null) {
            ret.freeze();
        }
        return ret;
    }

    public static String readPoolName(JsonObject json) {
        LootTableContext ctx = ForgeHooks.getLootTableContext();
        ctx.resetPoolCtx();
        if (json.has("name")) {
            return og.h((JsonObject)json, (String)"name");
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        ++ctx.poolCount;
        if (!ctx.vanilla) {
            throw new JsonParseException("Loot Table \"" + ctx.name.toString() + "\" Missing `name` entry for pool #" + (ctx.poolCount - 1));
        }
        return ctx.poolCount == 1 ? "main" : "pool" + (ctx.poolCount - 1);
    }

    public static String readLootEntryName(JsonObject json, String type) {
        LootTableContext ctx = ForgeHooks.getLootTableContext();
        ++ctx.entryCount;
        if (json.has("entryName")) {
            return ctx.validateEntryName(og.h((JsonObject)json, (String)"entryName"));
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        String name = null;
        if ("item".equals(type)) {
            name = og.h((JsonObject)json, (String)"name");
        } else if ("loot_table".equals(type)) {
            name = og.h((JsonObject)json, (String)"name");
        } else if ("empty".equals(type)) {
            name = "empty";
        }
        return ctx.validateEntryName(name);
    }

    public static bao deserializeJsonLootEntry(String type, JsonObject json, int weight, int quality, bbi[] conditions) {
        return null;
    }

    public static String getLootEntryType(bao entry) {
        return null;
    }

    public static boolean onThrowableImpact(aah throwable, bbz ray) {
        return MinecraftForge.EVENT_BUS.post(new ThrowableImpactEvent(throwable, ray));
    }

    public static boolean onCropsGrowPre(aid worldIn, cm pos, ars state, boolean def) {
        BlockEvent.CropGrowEvent.Pre ev = new BlockEvent.CropGrowEvent.Pre(worldIn, pos, state);
        MinecraftForge.EVENT_BUS.post(ev);
        return ev.getResult() == Event.Result.ALLOW || ev.getResult() == Event.Result.DEFAULT && def;
    }

    public static void onCropsGrowPost(aid worldIn, cm pos, ars state, ars blockState) {
        MinecraftForge.EVENT_BUS.post(new BlockEvent.CropGrowEvent.Post(worldIn, pos, state, worldIn.o(pos)));
    }

    static {
        seedList.add(new SeedEntry(new adz(aeb.P), 10){

            @Override
            public adz getStack(Random rand, int fortune) {
                return new adz(aeb.P, 1 + rand.nextInt(fortune * 2 + 1));
            }
        });
        ForgeHooks.initTools();
        URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
        craftingPlayer = new ThreadLocal();
        lootContext = new ThreadLocal();
    }

    private static class LootTableContext {
        public final kn name;
        private final boolean vanilla;
        public final boolean custom;
        public int poolCount = 0;
        public int entryCount = 0;
        private HashSet<String> entryNames = Sets.newHashSet();

        private LootTableContext(kn name, boolean custom) {
            this.name = name;
            this.custom = custom;
            this.vanilla = "minecraft".equals(this.name.b());
        }

        private void resetPoolCtx() {
            this.entryCount = 0;
            this.entryNames.clear();
        }

        public String validateEntryName(String name) {
            if (!this.entryNames.contains(name)) {
                this.entryNames.add(name);
                return name;
            }
            if (!this.vanilla) {
                throw new JsonParseException("Loot Table \"" + this.name.toString() + "\" Duplicate entry name \"" + name + "\" for pool #" + (this.poolCount - 1) + " entry #" + (this.entryCount - 1));
            }
            int x = 0;
            while (this.entryNames.contains(name + "#" + x)) {
                ++x;
            }
            name = name + "#" + x;
            this.entryNames.add(name);
            return name;
        }
    }

    static class SeedEntry
    extends ox.a {
        public final adz seed;

        public SeedEntry(adz seed, int weight) {
            super(weight);
            this.seed = seed;
        }

        public adz getStack(Random rand, int fortune) {
            return this.seed.k();
        }
    }
}

