/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.init;

import com.oblivioussp.spartanshields.init.ItemRegistrySS;
import com.oblivioussp.spartanshields.item.ItemShieldExtraMaterial;
import com.oblivioussp.spartanshields.util.ConfigHandler;
import com.oblivioussp.spartanshields.util.LogHelper;
import com.oblivioussp.spartanshields.util.ModHelper;
import com.oblivioussp.spartanshields.util.Reference;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipeRegistry {
    public static void addRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ItemRegistrySS.shieldWood, new Object[]{" pp", "psp", "pp ", Character.valueOf('p'), "plankWood", Character.valueOf('s'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ItemRegistrySS.shieldWood, new Object[]{"pp ", "psp", " pp", Character.valueOf('p'), "plankWood", Character.valueOf('s'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ItemRegistrySS.shieldStone, new Object[]{" c ", "csc", " c ", Character.valueOf('c'), "cobblestone", Character.valueOf('s'), ItemRegistrySS.shieldWood}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ItemRegistrySS.shieldIron, new Object[]{" i ", "isi", " i ", Character.valueOf('i'), "ingotIron", Character.valueOf('s'), ItemRegistrySS.shieldWood}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ItemRegistrySS.shieldGold, new Object[]{" g ", "gsg", " g ", Character.valueOf('g'), "ingotGold", Character.valueOf('s'), ItemRegistrySS.shieldWood}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ItemRegistrySS.shieldDiamond, new Object[]{" d ", "dsd", " d ", Character.valueOf('d'), "gemDiamond", Character.valueOf('s'), ItemRegistrySS.shieldWood}));
        if (ConfigHandler.enableObsidianShield) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)ItemRegistrySS.shieldObsidian, new Object[]{" o ", "oso", " o ", Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('s'), ItemRegistrySS.shieldWood}));
        }
        LogHelper.info("Recipes added!");
    }

    public static void addCompatRecipes() {
        if (ConfigHandler.vanillaOnly) {
            return;
        }
        if (!RecipeRegistry.addShieldRecipeIfValid(ItemRegistrySS.shieldBronze, "ingotBronze", ConfigHandler.enableBronzeShield)) {
            LogHelper.info("Can't add recipe for Bronze Plated Shield; No valid Bronze Ingot found...");
        }
        if (!RecipeRegistry.addShieldRecipeIfValid(ItemRegistrySS.shieldSteel, "ingotSteel", ConfigHandler.enableSteelShield)) {
            LogHelper.info("Can't add recipe for Steel Plated Shield; No valid Steel Ingot found...");
        }
        if (!RecipeRegistry.addShieldRecipeIfValid(ItemRegistrySS.shieldCopper, "ingotCopper", ConfigHandler.enableCopperShield)) {
            LogHelper.info("Can't add recipe for Copper Braced Shield; No valid Copper Ingot found...");
        }
        if (!RecipeRegistry.addShieldRecipeIfValid(ItemRegistrySS.shieldTin, "ingotTin", ConfigHandler.enableTinShield)) {
            LogHelper.info("Can't add recipe for Tin Braced Shield; No valid Tin Ingot found...");
        }
        if (!RecipeRegistry.addShieldRecipeIfValid(ItemRegistrySS.shieldSilver, "ingotSilver", ConfigHandler.enableSilverShield)) {
            LogHelper.info("Can't add recipe for Silver Gilded Shield; No valid Silver Ingot found...");
        }
        if (!RecipeRegistry.addShieldRecipeIfValid(ItemRegistrySS.shieldEnderium, "ingotEnderium", ConfigHandler.enableEnderiumShield)) {
            LogHelper.info("Can't add recipe for Enderium Reinforced Shield; No valid Enderium Ingot found...");
        }
        if (!RecipeRegistry.addShieldRecipeIfValid(ItemRegistrySS.shieldInvar, "ingotInvar", ConfigHandler.enableInvarShield)) {
            LogHelper.info("Can't add recipe for Invar Plated Shield; No valid Invar Ingot found...");
        }
        if (!RecipeRegistry.addShieldRecipeIfValid(ItemRegistrySS.shieldPlatinum, "ingotPlatinum", ConfigHandler.enablePlatinumShield)) {
            LogHelper.info("Can't add recipe for Platinum Plated Shield; No valid Platinum Ingot found...");
        }
        if (!RecipeRegistry.addShieldRecipeIfValid(ItemRegistrySS.shieldElectrum, "ingotElectrum", ConfigHandler.enableElectrumShield)) {
            LogHelper.info("Can't add recipe for Electrum Plated Shield; No valid Electrum Ingot found...");
        }
        if (!RecipeRegistry.addShieldRecipeIfValid(ItemRegistrySS.shieldNickel, "ingotNickel", ConfigHandler.enableNickelShield)) {
            LogHelper.info("Can't add recipe for Nickel Braced Shield; No valid Nickel Ingot found...");
        }
        if (!RecipeRegistry.addShieldRecipeIfValid(ItemRegistrySS.shieldLead, "ingotLead", ConfigHandler.enableLeadShield)) {
            LogHelper.info("Can't add recipe for Lead Plated Shield; No valid Lead Ingot found...");
        }
        if (!RecipeRegistry.addShieldRecipeIfValid(ItemRegistrySS.shieldSignalum, "ingotSignalum", ConfigHandler.enableSignalumShield)) {
            LogHelper.info("Can't add recipe for Signalum Strengthened Shield; No valid Signalum Ingot found...");
        }
        if (!RecipeRegistry.addShieldRecipeIfValid(ItemRegistrySS.shieldLumium, "ingotLumium", ConfigHandler.enableLumiumShield)) {
            LogHelper.info("Can't add recipe for Radiant Lumium Shield; No valid Lumium Ingot found...");
        }
        if (Loader.isModLoaded((String)"EnderIO") && ConfigHandler.enableEnderIOShield) {
            ItemStack darkSteel = GameRegistry.makeItemStack((String)"enderio:itemAlloy", (int)6, (int)1, null);
            ItemStack crystalEnder = GameRegistry.makeItemStack((String)"enderio:itemMaterial", (int)8, (int)1, null);
            ItemStack crystalPulsating = GameRegistry.makeItemStack((String)"enderio:itemMaterial", (int)5, (int)1, null);
            ItemStack capacitorOcto = GameRegistry.makeItemStack((String)"enderio:itemBasicCapacitor", (int)2, (int)1, null);
            if (darkSteel != Reference.STACK_NULL && crystalEnder != Reference.STACK_NULL && crystalPulsating != Reference.STACK_NULL && capacitorOcto != Reference.STACK_NULL) {
                LogHelper.info("Ender IO detected! Adding recipe to Fluxed Riot Shield!");
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)ItemRegistrySS.shieldFEEnderIO), (Object[])new Object[]{"dpd", "dod", "ded", Character.valueOf('d'), darkSteel, Character.valueOf('p'), crystalPulsating, Character.valueOf('e'), crystalEnder, Character.valueOf('o'), capacitorOcto});
            } else {
                LogHelper.error("Can't add Fluxed Riot Shield Recipe; An item from Ender IO has either had a name change or the developer didn't get the name right.");
            }
        } else {
            LogHelper.info("Can't add Fluxed Riot Shield Recipe; EnderIO not installed!");
        }
        if (Loader.isModLoaded((String)"rftools") && ConfigHandler.enableRFToolsShield) {
            ItemStack machineFrame = GameRegistry.makeItemStack((String)"rftools:machine_base", (int)0, (int)1, null);
            ItemStack shieldProjector = GameRegistry.makeItemStack((String)"rftools:shield_block1", (int)0, (int)1, null);
            ItemStack powerCell = GameRegistry.makeItemStack((String)"rftools:powercell", (int)0, (int)1, null);
            ItemStack diamondInfused = GameRegistry.makeItemStack((String)"rftools:infused_diamond", (int)0, (int)1, null);
            ItemStack shieldTemplate = GameRegistry.makeItemStack((String)"rftools:shield_template_block", (int)0, (int)1, null);
            if (machineFrame != Reference.STACK_NULL && shieldProjector != Reference.STACK_NULL && powerCell != Reference.STACK_NULL && diamondInfused != Reference.STACK_NULL && shieldTemplate != Reference.STACK_NULL) {
                LogHelper.info("RFTools detected! Adding recipe to Infused Riot Shield!");
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)ItemRegistrySS.shieldFERFTools), (Object[])new Object[]{"sbs", "dpd", "scs", Character.valueOf('s'), shieldTemplate, Character.valueOf('d'), diamondInfused, Character.valueOf('b'), machineFrame, Character.valueOf('p'), shieldProjector, Character.valueOf('c'), powerCell});
            }
        }
        if (Loader.isModLoaded((String)"Botania")) {
            ItemStack manasteel = GameRegistry.makeItemStack((String)"botania:manaResource", (int)0, (int)1, null);
            ItemStack terrasteel = GameRegistry.makeItemStack((String)"botania:manaResource", (int)4, (int)1, null);
            ItemStack elementium = GameRegistry.makeItemStack((String)"botania:manaResource", (int)7, (int)1, null);
            ItemStack livingwoodTwig = GameRegistry.makeItemStack((String)"botania:manaResource", (int)3, (int)1, null);
            ItemStack dreamwoodTwig = GameRegistry.makeItemStack((String)"botania:manaResource", (int)13, (int)1, null);
            ItemStack runeEarth = GameRegistry.makeItemStack((String)"botania:rune", (int)2, (int)1, null);
            ItemStack runeMana = GameRegistry.makeItemStack((String)"botania:rune", (int)8, (int)1, null);
            ItemStack runeSummer = GameRegistry.makeItemStack((String)"botania:rune", (int)5, (int)1, null);
            ItemStack runePride = GameRegistry.makeItemStack((String)"botania:rune", (int)15, (int)1, null);
            if (manasteel != null && terrasteel != null && elementium != null && livingwoodTwig != null && dreamwoodTwig != null && runeEarth != null && runeMana != null && runeSummer != null && runePride != null) {
                LogHelper.info("Botania detected! Adding Botania Shield Recipes!");
                if (ConfigHandler.enableManasteelShield) {
                    GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)ItemRegistrySS.shieldManasteel), (Object[])new Object[]{"iri", "iti", " s ", Character.valueOf('i'), manasteel, Character.valueOf('t'), livingwoodTwig, Character.valueOf('r'), runeEarth, Character.valueOf('s'), runeMana});
                }
                if (ConfigHandler.enableTerrasteelShield) {
                    GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)ItemRegistrySS.shieldTerrasteel), (Object[])new Object[]{"iri", "iti", " s ", Character.valueOf('i'), terrasteel, Character.valueOf('t'), livingwoodTwig, Character.valueOf('r'), runePride, Character.valueOf('s'), runeMana});
                }
                if (ConfigHandler.enableElementiumShield) {
                    GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)ItemRegistrySS.shieldElementium), (Object[])new Object[]{"iri", "iti", " s ", Character.valueOf('i'), elementium, Character.valueOf('t'), dreamwoodTwig, Character.valueOf('r'), runeSummer, Character.valueOf('s'), runeMana});
                }
            }
        }
        if (Loader.isModLoaded((String)"redstonearsenal") && ConfigHandler.enableRAShield) {
            ItemStack obStick = GameRegistry.makeItemStack((String)"redstonearsenal:material", (int)192, (int)1, null);
            ItemStack fluxPlate = GameRegistry.makeItemStack((String)"redstonearsenal:material", (int)160, (int)1, null);
            if (obStick != null && fluxPlate != null) {
                LogHelper.info("Redstone Arsenal detected! Adding Flux-Infused Shield Recipe!");
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)ItemRegistrySS.shieldFERedstoneArsenal), (Object[])new Object[]{" p ", "psp", " p ", Character.valueOf('p'), fluxPlate, Character.valueOf('s'), obStick});
            }
        }
    }

    public static boolean addShieldRecipeIfValid(ItemShieldExtraMaterial shield, String oreDict, boolean enabledFlag) {
        if (ModHelper.isMaterialValid(oreDict)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)shield, new Object[]{" i ", "isi", " i ", Character.valueOf('i'), oreDict, Character.valueOf('s'), ItemRegistrySS.shieldWood}));
            return true;
        }
        return false;
    }
}

