/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.capability;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.PacketSyncTelepadEntries;
import subaraki.telepads.utility.TelepadEntry;

public class TelepadData {
    private EntityPlayer player;
    private List<TelepadEntry> entries;
    private boolean isInTeleportGui;
    private static final int MAX_TIME = 60;
    public int counter = 60;

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(EntityPlayer newPlayer) {
        this.entries = new ArrayList<TelepadEntry>();
        this.player = newPlayer;
    }

    public NBTBase writeData() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList entryList = new NBTTagList();
        for (TelepadEntry entry : this.entries) {
            entryList.func_74742_a((NBTBase)entry.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("entries", (NBTBase)entryList);
        return tag;
    }

    public void readData(NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        ArrayList<TelepadEntry> entryList = new ArrayList<TelepadEntry>();
        NBTTagList entryTagList = tag.func_150295_c("entries", 10);
        for (int tagPos = 0; tagPos < entryTagList.func_74745_c(); ++tagPos) {
            entryList.add(new TelepadEntry(entryTagList.func_150305_b(tagPos)));
        }
        this.entries = entryList;
    }

    public List<TelepadEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<TelepadEntry>();
        }
        return this.entries;
    }

    public void addEntry(TelepadEntry entry) {
        this.getEntries().add(entry);
        this.sync();
    }

    public void removeEntry(TelepadEntry entry) {
        for (TelepadEntry tpe : this.getEntries()) {
            if (!tpe.position.equals((Object)entry.position) || tpe.dimensionID != entry.dimensionID) continue;
            this.getEntries().remove(tpe);
            break;
        }
        this.sync();
    }

    public void removeEventualQueuedForRemovalEntries() {
        for (TelepadEntry tpe : this.getEntries()) {
            if (!tpe.entryName.equals("QUEUEDFORREMOVAL")) continue;
            this.getEntries().remove(tpe);
            break;
        }
        this.sync();
    }

    public void sync() {
        if (this.player instanceof EntityPlayerMP) {
            NetworkHandler.NETWORK.sendTo((IMessage)new PacketSyncTelepadEntries(this.player.func_110124_au(), this.entries), (EntityPlayerMP)this.player);
        }
    }

    public void syncPoweredWithWorldData(WorldDataHandler wdh) {
        for (TelepadEntry entry : wdh.getEntries()) {
            for (TelepadEntry tpe : this.getEntries()) {
                if (!entry.position.equals((Object)tpe.position) || entry.dimensionID != tpe.dimensionID) continue;
                tpe.setPowered(entry.isPowered);
            }
        }
        this.sync();
    }

    public boolean isInTeleportGui() {
        return this.isInTeleportGui;
    }

    public void setInTeleportGui(boolean isInTeleportGui) {
        this.isInTeleportGui = isInTeleportGui;
    }

    public void overrideEntries(List<TelepadEntry> entries) {
        this.entries = entries;
        this.sync();
    }

    public int getCounter() {
        return this.counter;
    }

    public void countDown() {
        --this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public static int getMaxTime() {
        return 60;
    }
}

