/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.gui.client;

import com.mojang.realmsclient.gui.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import subaraki.telepads.capability.TelePadDataCapability;
import subaraki.telepads.capability.TelepadData;
import subaraki.telepads.gui.server.ContainerTelepad;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.PacketRemoveTelepadEntry;
import subaraki.telepads.network.PacketTeleport;
import subaraki.telepads.utility.TelepadEntry;

public class GuiRemoveTelepad
extends GuiContainer {
    private EntityPlayer player;
    private TelepadEntry entryToRemove;
    private float backgroundScroll = 0.0f;
    private float backgroundSideScroll = 0.0f;
    private TextureManager renderEngine;
    private static final ResourceLocation enderPortalEndSkyTextures = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation endPortalTextures = new ResourceLocation("textures/entity/end_portal.png");

    public GuiRemoveTelepad(EntityPlayer player) {
        super((Container)new ContainerTelepad());
        this.renderEngine = Minecraft.func_71410_x().field_71446_o;
        this.player = player;
        this.entryToRemove = null;
        Integer dim = null;
        BlockPos pos = null;
        for (TelepadEntry entry : ((TelepadData)player.getCapability(TelePadDataCapability.CAPABILITY, null)).getEntries()) {
            if (!entry.entryName.equals("QUEUEDFORREMOVAL")) continue;
            dim = entry.dimensionID;
            pos = entry.position;
        }
        if (pos != null && dim != null) {
            for (TelepadEntry entry : ((TelepadData)player.getCapability(TelePadDataCapability.CAPABILITY, null)).getEntries()) {
                if (entry.entryName.equals("QUEUEDFORREMOVAL") || dim != entry.dimensionID || !pos.equals((Object)entry.position)) continue;
                this.entryToRemove = entry;
                break;
            }
        }
    }

    public void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0 && this.entryToRemove != null) {
            NetworkHandler.NETWORK.sendToServer((IMessage)new PacketRemoveTelepadEntry(this.player.getPersistentID(), this.entryToRemove));
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (button.field_146127_k == 1 && this.entryToRemove != null) {
            NetworkHandler.NETWORK.sendToServer((IMessage)new PacketTeleport(this.player.func_180425_c(), this.entryToRemove, true));
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        int posX = this.field_146294_l / 2;
        int posY = this.field_146295_m / 2;
        String s = I18n.func_135052_a((String)"cannot.find.remove", (Object[])new Object[0]);
        int lenght = this.field_146289_q.func_78256_a(s);
        this.field_146289_q.func_175063_a(s, (float)(posX - lenght / 2), (float)(posY - 30), 0xFFFFFF);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int posX = this.field_146294_l / 2;
        int posY = this.field_146295_m / 2;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, posX - 50, posY - 12, 100, 20, ChatFormatting.RED + I18n.func_135052_a((String)"button.forget", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(1, posX - 50, posY + 12, 100, 20, I18n.func_135052_a((String)"button.teleport", (Object[])new Object[0])));
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.backgroundScroll += 1.0f;
        this.backgroundSideScroll += 0.01f;
        float scrollSpeed = this.backgroundScroll + 2.0f;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)0.2f, (float)0.6f, (float)1.0f, (float)0.6f);
        this.renderEngine.func_110577_a(enderPortalEndSkyTextures);
        this.func_73729_b(0, 0, -((int)scrollSpeed) * 2, (int)this.backgroundScroll * 2, this.field_146294_l, this.field_146295_m);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)0.2f, (float)0.6f, (float)1.0f, (float)0.75f);
        this.renderEngine.func_110577_a(endPortalTextures);
        this.func_73729_b(0, 0, (int)scrollSpeed * 2, (int)this.backgroundScroll * 2, this.field_146294_l, this.field_146295_m);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

