/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.gui.client;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import subaraki.telepads.capability.TelePadDataCapability;
import subaraki.telepads.capability.TelepadData;
import subaraki.telepads.gui.server.ContainerTelepad;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.PacketTeleport;
import subaraki.telepads.tileentity.TileEntityTelepad;
import subaraki.telepads.utility.TelepadEntry;

public class GuiTeleport
extends GuiContainer {
    public EntityPlayer player;
    public TileEntityTelepad te;
    public static final int EXIT_BUTTON = 4000;
    public static final int AREA_LEFT = 3999;
    public static final int AREA_RIGHT = 3998;
    public static final int SCROLL = 3997;
    private int tuner_counter;
    private int dimension_ID;
    private int scroll_index = 0;
    private TextureManager renderEngine;
    private static final ResourceLocation enderPortalEndSkyTextures = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation endPortalTextures = new ResourceLocation("textures/entity/end_portal.png");
    private HashMap<TelepadEntry, Integer> pageEntries;
    private List<Integer> dimensionsVisited;
    private int xPosition;
    private int yPosition;
    private float backgroundScroll;
    private float backgroundSideScroll;

    public GuiTeleport(EntityPlayer player, TileEntityTelepad te) {
        super((Container)new ContainerTelepad());
        this.renderEngine = Minecraft.func_71410_x().field_71446_o;
        this.pageEntries = new HashMap();
        this.dimensionsVisited = new ArrayList<Integer>();
        this.xPosition = this.field_146294_l / 2;
        this.yPosition = this.field_146295_m / 2;
        this.backgroundScroll = 0.0f;
        this.backgroundSideScroll = 0.0f;
        this.te = te;
        this.player = player;
        this.dimension_ID = player.field_70170_p.field_73011_w.getDimension();
        TelepadData td = (TelepadData)player.getCapability(TelePadDataCapability.CAPABILITY, null);
        this.dimensionsVisited.add(this.dimension_ID);
        for (TelepadEntry tpe : td.getEntries()) {
            if (this.dimensionsVisited.contains(tpe.dimensionID)) continue;
            this.dimensionsVisited.add(tpe.dimensionID);
        }
    }

    public void func_146284_a(GuiButton button) {
        if (this.player != null) {
            int id = button.field_146127_k;
            if (id == 3997) {
                if (this.pageEntries != null && !this.pageEntries.isEmpty()) {
                    ++this.scroll_index;
                    if (this.scroll_index > this.pageEntries.size() / 15) {
                        this.scroll_index = 0;
                    }
                }
                this.drawButtonsOnScreen(this.scroll_index);
            } else if (id == 4000) {
                this.field_146297_k.field_71439_g.func_71053_j();
            } else if (id == 3999) {
                if (this.dimensionsVisited.size() > 1) {
                    --this.tuner_counter;
                    this.drawButtonsOnScreen(0);
                }
            } else if (id == 3998) {
                if (this.dimensionsVisited.size() > 1) {
                    ++this.tuner_counter;
                    this.drawButtonsOnScreen(0);
                }
            } else {
                this.sendPacket(id);
                this.te.setPlatform(false);
                this.field_146297_k.field_71439_g.func_71053_j();
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146278_c(int par1) {
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int stringX;
        super.func_73863_a(par1, par2, par3);
        int offset = 60;
        int x = this.xPosition - 67;
        int y = this.yPosition - 86;
        if (this.pageEntries != null) {
            String page_indicator = "Page " + (this.scroll_index + 1) + "/" + (this.pageEntries.size() / 15 + 1);
            stringX = this.xPosition - 110;
            this.field_146289_q.func_175063_a(page_indicator, (float)stringX, (float)(y + 2), 0xFFFFFF);
        }
        GuiTeleport.func_73734_a((int)(x - 1 + offset), (int)(y - 1), (int)(x + 135 + offset + 1), (int)(y + 12 + 1), (int)-6250336);
        GuiTeleport.func_73734_a((int)(x + offset), (int)y, (int)(x + 135 + offset), (int)(y + 12), (int)-16777216);
        String dimension_name = DimensionManager.getProviderType((int)this.dimension_ID).func_186065_b();
        stringX = this.xPosition - this.field_146289_q.func_78256_a(dimension_name) / 2;
        if (!this.te.hasDimensionUpgrade()) {
            this.field_146289_q.func_175063_a(dimension_name, (float)(stringX + offset), (float)(y + 2), 0xFFFFFF);
        } else if (dimension_name != null && dimension_name.length() > 0) {
            this.field_146289_q.func_175063_a(dimension_name, (float)(stringX + offset), (float)(y + 2), 0xFFFFFF);
        } else {
            this.field_146289_q.func_175063_a("No%Dim- Error : Hz " + this.dimension_ID, (float)(stringX + offset), (float)(y + 3), 0xFFFFFF);
        }
    }

    public void drawButtonsOnScreen(int scroll_page) {
        this.scroll_index = scroll_page;
        this.field_146292_n.clear();
        this.pageEntries.clear();
        if (this.tuner_counter >= this.dimensionsVisited.size()) {
            this.tuner_counter = 0;
        }
        if (this.tuner_counter < 0) {
            this.tuner_counter = this.dimensionsVisited.size() - 1;
        }
        this.dimension_ID = this.dimensionsVisited.get(this.tuner_counter);
        if (this.te.hasDimensionUpgrade()) {
            this.field_146292_n.add(new GuiButton(3999, this.xPosition - 33, this.yPosition - 90, 20, 20, "<"));
            this.field_146292_n.add(new GuiButton(3998, this.xPosition + 133, this.yPosition - 90, 20, 20, ">"));
        }
        this.field_146292_n.add(new GuiButton(4000, this.xPosition - 157, this.yPosition - 90, 20, 20, "x"));
        this.fillEntries();
        if (this.pageEntries != null && !this.pageEntries.isEmpty() && this.pageEntries.size() > 15) {
            this.field_146292_n.add(new GuiButton(3997, this.xPosition - 135, this.yPosition - 90, 20, 20, "v"));
        }
        this.makePage(scroll_page);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.xPosition != this.field_146294_l / 2) {
            this.xPosition = this.field_146294_l / 2;
        }
        if (this.yPosition != this.field_146295_m / 2) {
            this.yPosition = this.field_146295_m / 2;
        }
        this.drawButtonsOnScreen(0);
    }

    protected void func_73869_a(char c, int i) throws IOException {
        super.func_73869_a(c, i);
        if (i == 1) {
            this.te.setPlatform(false);
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void sendPacket(int id) {
        if (this.player == null) {
            return;
        }
        TelepadData td = (TelepadData)this.player.getCapability(TelePadDataCapability.CAPABILITY, null);
        NetworkHandler.NETWORK.sendToServer((IMessage)new PacketTeleport(this.player.func_180425_c(), td.getEntries().get(id), false));
    }

    private void fillEntries() {
        TelepadData td = (TelepadData)this.player.getCapability(TelePadDataCapability.CAPABILITY, null);
        int classificationID = 0;
        for (TelepadEntry tpe : td.getEntries()) {
            if (tpe.dimensionID == this.dimension_ID) {
                this.pageEntries.put(tpe, classificationID);
            }
            ++classificationID;
        }
    }

    private void makePage(int scroll_page) {
        int entry = 0;
        for (TelepadEntry tpe : this.pageEntries.keySet()) {
            TelepadEntry worldEntry = WorldDataHandler.get(this.te.func_145831_w()).getEntryForLocation(tpe.position, tpe.dimensionID);
            String telepadName = "";
            if (worldEntry != null) {
                boolean isPowered = worldEntry.isPowered;
                boolean isTransmitter = worldEntry.hasTransmitter;
                telepadName = isPowered ? ChatFormatting.DARK_RED + tpe.entryName : (isTransmitter ? ChatFormatting.DARK_GREEN + tpe.entryName : tpe.entryName);
            } else {
                telepadName = ChatFormatting.DARK_GRAY + tpe.entryName;
            }
            if (entry < 15 * (scroll_page + 1) && entry >= 15 * scroll_page) {
                int index = entry - 15 * scroll_page;
                int theX = index / 5 * 105;
                int theY = index % 5 * 25;
                this.field_146292_n.add(new GuiButton(this.pageEntries.get(tpe).intValue(), this.xPosition + theX - 157, this.yPosition + theY - 62, 100, 20, telepadName));
            }
            ++entry;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.backgroundScroll += 1.0f;
        this.backgroundSideScroll += 0.01f;
        float k = this.backgroundScroll + 2.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)0.2f, (float)0.6f, (float)1.0f, (float)(this.backgroundSideScroll < 0.6f ? this.backgroundSideScroll : 0.6f));
        this.renderEngine.func_110577_a(enderPortalEndSkyTextures);
        this.func_73729_b(0, 0, -((int)k) * 2, (int)this.backgroundScroll * 2, this.field_146294_l, this.field_146295_m);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)0.2f, (float)0.6f, (float)1.0f, (float)(this.backgroundSideScroll < 0.75f ? this.backgroundSideScroll : 0.75f));
        this.renderEngine.func_110577_a(endPortalTextures);
        this.func_73729_b(0, 0, (int)k * 2, (int)this.backgroundScroll * 2, this.field_146294_l, this.field_146295_m);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

