/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.handler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.PacketSyncWorldData;
import subaraki.telepads.utility.TelepadEntry;

public class WorldDataHandler
extends WorldSavedData {
    private static final String TELEPADS_WORLD_SAVE_DATA = "telepads_world_save_data";
    private List<TelepadEntry> allTelepads = new ArrayList<TelepadEntry>();

    public WorldDataHandler() {
        super(TELEPADS_WORLD_SAVE_DATA);
    }

    public WorldDataHandler(String s) {
        super(s);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        ArrayList<TelepadEntry> entryList = new ArrayList<TelepadEntry>();
        NBTTagList taglist = nbt.func_150295_c("entries", 10);
        for (int entryTag = 0; entryTag < taglist.func_74745_c(); ++entryTag) {
            entryList.add(new TelepadEntry(taglist.func_150305_b(entryTag)));
        }
        this.allTelepads = entryList;
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList taglist = new NBTTagList();
        if (!this.allTelepads.isEmpty()) {
            for (TelepadEntry entry : this.allTelepads) {
                taglist.func_74742_a((NBTBase)entry.writeToNBT(new NBTTagCompound()));
            }
        }
        nbt.func_74782_a("entries", (NBTBase)taglist);
        return nbt;
    }

    public static WorldDataHandler get(World world) {
        MapStorage storage = world.func_175693_T();
        WorldSavedData instance = storage.func_75742_a(WorldDataHandler.class, TELEPADS_WORLD_SAVE_DATA);
        if (instance == null) {
            instance = new WorldDataHandler();
            storage.func_75745_a(TELEPADS_WORLD_SAVE_DATA, instance);
        }
        return (WorldDataHandler)instance;
    }

    public void addEntry(TelepadEntry entry) {
        if (!this.contains(entry)) {
            this.allTelepads.add(entry);
        }
        this.syncClient();
    }

    public boolean contains(TelepadEntry entry) {
        if (this.allTelepads.isEmpty()) {
            return false;
        }
        for (TelepadEntry pad : this.allTelepads) {
            if (!entry.position.equals((Object)pad.position) || entry.dimensionID != pad.dimensionID) continue;
            return true;
        }
        return false;
    }

    public void removeEntry(TelepadEntry entry) {
        if (this.contains(entry)) {
            this.allTelepads.remove(this.getEntryForLocation(entry.position, entry.dimensionID));
        }
        this.syncClient();
    }

    public TelepadEntry getEntryForLocation(BlockPos pos, int dimensionId) {
        if (this.allTelepads.isEmpty()) {
            return null;
        }
        for (TelepadEntry entry : this.allTelepads) {
            if (!entry.position.equals((Object)pos) || entry.dimensionID != dimensionId) continue;
            return entry;
        }
        return null;
    }

    public void syncClient() {
        NetworkHandler.NETWORK.sendToAll((IMessage)new PacketSyncWorldData(this.allTelepads));
    }

    public void updateEntry(TelepadEntry entry) {
        if (this.contains(entry) && this.getEntryForLocation(entry.position, entry.dimensionID) != null) {
            this.allTelepads.remove(this.getEntryForLocation(entry.position, entry.dimensionID));
            this.allTelepads.add(entry);
        }
        this.syncClient();
    }

    public boolean isEntryPowered(TelepadEntry entry) {
        return this.contains(entry) && this.getEntryForLocation((BlockPos)entry.position, (int)entry.dimensionID).isPowered;
    }

    public List<TelepadEntry> getEntries() {
        return this.allTelepads;
    }

    public void copyOverEntries(List<TelepadEntry> allTelepads) {
        this.allTelepads = allTelepads;
    }

    public static class WorldDataHandlerSaveEvent {
        public WorldDataHandlerSaveEvent() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save event) {
            WorldDataHandler.get(event.getWorld()).func_76185_a();
        }

        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            WorldDataHandler.get(event.getWorld());
        }
    }
}

