/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import subaraki.telepads.capability.TelePadDataCapability;
import subaraki.telepads.capability.TelepadData;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.utility.TelepadEntry;

public class PacketAddTelepadEntry
implements IMessage {
    private UUID playerUUID;
    private TelepadEntry entry;

    public PacketAddTelepadEntry(UUID playerUUID, TelepadEntry entry) {
        this.playerUUID = playerUUID;
        this.entry = entry;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.entry = new TelepadEntry(buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID.toString());
        this.entry.writeToByteBuf(buf);
    }

    public PacketAddTelepadEntry() {
    }

    public static class PacketAddTelepadEntryHandler
    implements IMessageHandler<PacketAddTelepadEntry, IMessage> {
        public IMessage onMessage(PacketAddTelepadEntry packet, MessageContext ctx) {
            ((WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p).func_152344_a(() -> {
                EntityPlayer player = ctx.getServerHandler().field_147369_b.field_70170_p.func_152378_a(packet.playerUUID);
                TelepadData td = (TelepadData)player.getCapability(TelePadDataCapability.CAPABILITY, null);
                WorldDataHandler wdh = WorldDataHandler.get(player.field_70170_p);
                if (td.getEntries().isEmpty()) {
                    td.addEntry(packet.entry);
                    wdh.addEntry(packet.entry);
                    wdh.func_76185_a();
                } else {
                    TelepadEntry hasEntry = null;
                    for (TelepadEntry tpe : td.getEntries()) {
                        if (!tpe.position.equals((Object)((PacketAddTelepadEntry)packet).entry.position) || tpe.dimensionID != ((PacketAddTelepadEntry)packet).entry.dimensionID) continue;
                        hasEntry = tpe;
                        break;
                    }
                    if (hasEntry == null) {
                        td.addEntry(packet.entry);
                        wdh.addEntry(packet.entry);
                        wdh.func_76185_a();
                    } else {
                        td.removeEntry(hasEntry);
                        wdh.removeEntry(hasEntry);
                        td.addEntry(packet.entry);
                        wdh.addEntry(packet.entry);
                        wdh.func_76185_a();
                    }
                }
            });
            return null;
        }
    }
}

