/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import subaraki.telepads.capability.TelePadDataCapability;
import subaraki.telepads.capability.TelepadData;
import subaraki.telepads.mod.Telepads;
import subaraki.telepads.utility.TelepadEntry;

public class PacketSyncTelepadEntries
implements IMessage {
    private UUID playerUUID;
    private List<TelepadEntry> entries;

    public PacketSyncTelepadEntries(UUID playerUUID, List<TelepadEntry> entries) {
        this.playerUUID = playerUUID;
        this.entries = entries;
    }

    public void fromBytes(ByteBuf buf) {
        ArrayList<TelepadEntry> entryList = new ArrayList<TelepadEntry>();
        this.playerUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        int size = buf.readInt();
        if (size <= 0) {
            return;
        }
        for (int index = 0; index < size; ++index) {
            entryList.add(new TelepadEntry(buf));
        }
        this.entries = entryList;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID.toString());
        buf.writeInt(this.entries.size());
        for (TelepadEntry entry : this.entries) {
            entry.writeToByteBuf(buf);
        }
    }

    public PacketSyncTelepadEntries() {
    }

    public static class PacketSyncTelepadEntriesHandler
    implements IMessageHandler<PacketSyncTelepadEntries, IMessage> {
        public IMessage onMessage(PacketSyncTelepadEntries packet, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                EntityPlayer player = Telepads.proxy.getClientPlayer();
                TelepadData td = (TelepadData)player.getCapability(TelePadDataCapability.CAPABILITY, null);
                td.overrideEntries(packet.entries);
                td.setCounter(td.getMaxTime());
                td.setInTeleportGui(false);
            });
            return null;
        }
    }
}

