/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import subaraki.telepads.capability.TelePadDataCapability;
import subaraki.telepads.capability.TelepadData;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.mod.Telepads;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.PacketSyncPlayerAfterTeleport;
import subaraki.telepads.utility.TelepadEntry;
import subaraki.telepads.utility.TeleportUtility;

public class PacketTeleport
implements IMessage {
    public TelepadEntry goTo;
    public BlockPos oldPos;
    public boolean force;

    public PacketTeleport(BlockPos playerFrom, TelepadEntry goTo, boolean forceTeleport) {
        this.oldPos = playerFrom;
        this.goTo = goTo;
        this.force = forceTeleport;
    }

    public void fromBytes(ByteBuf buf) {
        this.oldPos = BlockPos.func_177969_a((long)buf.readLong());
        this.goTo = new TelepadEntry(buf);
        this.force = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.oldPos.func_177986_g());
        this.goTo.writeToByteBuf(buf);
        buf.writeBoolean(this.force);
    }

    public PacketTeleport() {
    }

    public static class PacketTeleportHandler
    implements IMessageHandler<PacketTeleport, IMessage> {
        public IMessage onMessage(PacketTeleport packet, MessageContext ctx) {
            ((WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p).func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                WorldDataHandler wdh = WorldDataHandler.get(player.field_70170_p);
                TelepadData td = (TelepadData)player.getCapability(TelePadDataCapability.CAPABILITY, null);
                td.setInTeleportGui(false);
                BlockPos goTo = packet.goTo.position.func_177984_a();
                int goToDimensionid = packet.goTo.dimensionID;
                if (packet.goTo.dimensionID == player.field_71093_bK) {
                    if (packet.force) {
                        TeleportUtility.teleportEntityTo((Entity)player, goTo, player.field_70177_z, player.field_70125_A);
                        return;
                    }
                    if (wdh.contains(packet.goTo)) {
                        if (!packet.goTo.isPowered) {
                            if (goToDimensionid == player.field_71093_bK) {
                                TeleportUtility.teleportEntityTo((Entity)player, goTo, player.field_70177_z, player.field_70125_A);
                            }
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + "" + TextFormatting.DARK_RED + "This pad was powered off"));
                        }
                    } else {
                        td.setInTeleportGui(true);
                        PacketTeleportHandler.removePad((EntityPlayer)player, packet.goTo);
                    }
                } else {
                    if (packet.force) {
                        TeleportUtility.changeToDimension((Entity)player, goTo, goToDimensionid, FMLCommonHandler.instance().getMinecraftServerInstance());
                        return;
                    }
                    if (wdh.contains(packet.goTo)) {
                        if (!packet.goTo.isPowered) {
                            TeleportUtility.changeToDimension((Entity)player, goTo, goToDimensionid, FMLCommonHandler.instance().getMinecraftServerInstance());
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + "" + TextFormatting.DARK_RED + "This pad was powered off"));
                        }
                    } else {
                        PacketTeleportHandler.removePad((EntityPlayer)player, packet.goTo);
                    }
                }
                this.syncUpClientWithServerHotFix(player);
            });
            return null;
        }

        private void syncUpClientWithServerHotFix(EntityPlayerMP player) {
            NBTTagCompound tag_basic = new NBTTagCompound();
            player.func_189511_e(tag_basic);
            NBTTagCompound tag_entity = new NBTTagCompound();
            player.func_189511_e(tag_entity);
            NetworkHandler.NETWORK.sendTo((IMessage)new PacketSyncPlayerAfterTeleport(tag_basic, tag_entity), player);
        }

        private static void removePad(EntityPlayer player, TelepadEntry entry) {
            TelepadData td = (TelepadData)player.getCapability(TelePadDataCapability.CAPABILITY, null);
            td.addEntry(new TelepadEntry("QUEUEDFORREMOVAL", entry.dimensionID, entry.position, false, false));
            td.sync();
            td.setInTeleportGui(true);
            player.openGui((Object)Telepads.instance, 2, player.field_70170_p, 0, 0, 0);
        }
    }
}

