/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.tileentity;

import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import subaraki.telepads.capability.TelePadDataCapability;
import subaraki.telepads.capability.TelepadData;
import subaraki.telepads.gui.server.ContainerTelepad;
import subaraki.telepads.handler.ConfigurationHandler;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.mod.Telepads;

public class TileEntityTelepad
extends TileEntity
implements ITickable {
    private int dimension;
    public static final int COLOR_FEET_BASE = new Color(26, 246, 172).getRGB();
    public static final int COLOR_ARROW_BASE = new Color(243, 89, 233).getRGB();
    private int colorFrame = COLOR_FEET_BASE;
    private int colorBase = COLOR_ARROW_BASE;
    private int upgradeRotation = 0;
    private boolean hasDimensionUpgrade = false;
    private boolean hasRedstoneUpgrade = false;
    private boolean isPowered = false;
    private boolean isStandingOnPlatform;
    private AxisAlignedBB aabb = new AxisAlignedBB(this.func_174877_v()).func_72314_b(1.0, 1.0, 1.0);

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.dimension = compound.func_74762_e("dimension");
        this.hasDimensionUpgrade = compound.func_74767_n("upgrade_dimension");
        this.hasRedstoneUpgrade = compound.func_74767_n("upgrade_redstone");
        this.isPowered = compound.func_74767_n("is_powered");
        this.colorBase = compound.func_74762_e("colorBase");
        this.colorFrame = compound.func_74762_e("colorFrame");
        this.upgradeRotation = compound.func_74762_e("upgradeRotation");
        this.isStandingOnPlatform = compound.func_74767_n("standingon");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("dimension", this.dimension);
        compound.func_74757_a("upgrade_dimension", this.hasDimensionUpgrade);
        compound.func_74757_a("upgrade_redstone", this.hasRedstoneUpgrade);
        compound.func_74757_a("is_powered", this.isPowered);
        compound.func_74768_a("colorBase", this.colorBase);
        compound.func_74768_a("colorFrame", this.colorFrame);
        compound.func_74768_a("upgradeRotation", this.upgradeRotation);
        compound.func_74757_a("standingon", this.isStandingOnPlatform);
        return compound;
    }

    public void func_73660_a() {
        if (this.isPowered) {
            return;
        }
        this.aabb = new AxisAlignedBB(this.func_174877_v()).func_72314_b(0.0, -0.5, 0.0);
        List playersInRange = this.field_145850_b.func_72872_a(EntityPlayer.class, this.aabb);
        if (playersInRange.isEmpty() && this.isStandingOnPlatform) {
            this.setPlatform(false);
            return;
        }
        for (EntityPlayer playerInAabb : playersInRange) {
            this.isStandingOnPlatform = true;
            TelepadData td = (TelepadData)playerInAabb.getCapability(TelePadDataCapability.CAPABILITY, null);
            if (td.getCounter() > 0 && !td.isInTeleportGui()) {
                --td.counter;
                continue;
            }
            if (this.field_145850_b.field_73011_w.getDimension() == 1 && ConfigurationHandler.instance.allowDragonBlocking) {
                for (Object o : this.field_145850_b.field_72996_f) {
                    if (!(o instanceof EntityDragon)) continue;
                    td.setCounter(td.getMaxTime());
                    if (this.field_145850_b.field_72995_K) break;
                    playerInAabb.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"dragon.obstructs", (Object[])new Object[0])));
                    break;
                }
                if (td.getCounter() > 0) continue;
                td.setCounter(td.getMaxTime());
                this.activateTelepadGui(td);
                td.setInTeleportGui(true);
                continue;
            }
            td.setCounter(td.getMaxTime());
            this.activateTelepadGui(td);
            td.setInTeleportGui(true);
        }
    }

    public void setPlatform(boolean onPlatform) {
        this.isStandingOnPlatform = onPlatform;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 3);
    }

    private void activateTelepadGui(TelepadData td) {
        if (!td.isInTeleportGui() && !(td.getPlayer().field_71070_bA instanceof ContainerTelepad)) {
            if (!this.field_145850_b.field_72995_K) {
                WorldDataHandler.get(this.field_145850_b).syncClient();
                td.removeEventualQueuedForRemovalEntries();
                td.syncPoweredWithWorldData(WorldDataHandler.get(this.field_145850_b));
                td.sync();
                FMLNetworkHandler.openGui((EntityPlayer)td.getPlayer(), (Object)Telepads.instance, (int)0, (World)this.field_145850_b, (int)this.func_174877_v().func_177958_n(), (int)this.func_174877_v().func_177956_o(), (int)this.func_174877_v().func_177952_p());
            }
            this.func_70296_d();
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimensionID) {
        this.dimension = dimensionID;
    }

    public void setFeetColor(int rgb) {
        this.colorFrame = rgb;
    }

    public void setArrowColor(int rgb) {
        this.colorBase = rgb;
    }

    public int getColorFeet() {
        return this.colorFrame;
    }

    public int getColorArrow() {
        return this.colorBase;
    }

    public boolean hasDimensionUpgrade() {
        return this.hasDimensionUpgrade;
    }

    public void addDimensionUpgrade(boolean allowed) {
        this.upgradeRotation = allowed ? new Random().nextInt(4) : 0;
        this.hasDimensionUpgrade = true;
    }

    public int getUpgradeRotation() {
        return this.upgradeRotation;
    }

    public boolean hasRedstoneUpgrade() {
        return this.hasRedstoneUpgrade;
    }

    public void addRedstoneUpgrade() {
        this.hasRedstoneUpgrade = true;
    }

    public void setPowered(boolean flag) {
        this.isPowered = flag;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public boolean isStandingOnPlatform() {
        return this.isStandingOnPlatform;
    }
}

