/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.environmentalcreepers.event;

import fi.dy.masa.environmentalcreepers.EnvironmentalCreepers;
import fi.dy.masa.environmentalcreepers.config.Configs;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ExplosionEventHandler {
    private final Field fieldExplosionSize = ReflectionHelper.findField(Explosion.class, (String[])new String[]{"field_77280_f", "explosionSize"});
    private final Field fieldIsFlaming;
    private final Field fieldIsSmoking = ReflectionHelper.findField(Explosion.class, (String[])new String[]{"field_82755_b", "isSmoking"});

    public ExplosionEventHandler() {
        this.fieldIsFlaming = ReflectionHelper.findField(Explosion.class, (String[])new String[]{"field_77286_a", "isFlaming"});
    }

    @SubscribeEvent
    public void onExplosionStart(ExplosionEvent.Start event) {
        Explosion explosion = event.getExplosion();
        if (explosion.func_94613_c() instanceof EntityCreeper) {
            if (Configs.modifyCreeperExplosionDropChance && !Configs.disableCreeperExplosionBlockDamage) {
                this.replaceExplosion(event, true);
            }
        } else if (Configs.modifyOtherExplosionDropChance && !Configs.disableOtherExplosionBlockDamage) {
            this.replaceExplosion(event, false);
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        if (event.getExplosion().func_94613_c() instanceof EntityCreeper) {
            if (Configs.disableCreeperExplosionItemDamage) {
                this.removeItemEntities(event.getAffectedEntities(), true);
            }
            if (Configs.disableCreeperExplosionBlockDamage) {
                EnvironmentalCreepers.logInfo("ExplosionEventHandler - clearAffectedBlockPositions() - Type: 'Creeper'", new Object[0]);
                event.getExplosion().func_180342_d();
            }
        } else {
            if (Configs.disableOtherExplosionItemDamage) {
                this.removeItemEntities(event.getAffectedEntities(), false);
            }
            if (Configs.disableOtherExplosionBlockDamage) {
                EnvironmentalCreepers.logInfo("ExplosionEventHandler - clearAffectedBlockPositions() - Type: 'Other'", new Object[0]);
                event.getExplosion().func_180342_d();
            }
        }
    }

    private void removeItemEntities(List<Entity> list, boolean isCreeper) {
        EnvironmentalCreepers.logInfo("ExplosionEventHandler.removeItemEntities() - Type: '{}'", isCreeper ? "Creeper" : "Other");
        Iterator<Entity> iter = list.iterator();
        while (iter.hasNext()) {
            Entity entity = iter.next();
            if (!(entity instanceof EntityItem)) continue;
            iter.remove();
        }
    }

    private void replaceExplosion(ExplosionEvent.Start event, boolean isCreeper) {
        World world = event.getWorld();
        Explosion explosion = event.getExplosion();
        EnvironmentalCreepers.logInfo("Replacing the explosion for type '{}'", isCreeper ? "Creeper" : "Other");
        try {
            float explosionSize;
            boolean isSmoking = this.fieldIsSmoking.getBoolean(explosion);
            boolean isFlaming = this.fieldIsFlaming.getBoolean(explosion);
            if (isCreeper && Configs.modifyCreeperExplosionStrength) {
                explosionSize = ((EntityCreeper)explosion.func_94613_c()).func_70830_n() ? (float)Configs.creeperExplosionStrengthCharged : (float)Configs.creeperExplosionStrengthNormal;
                this.fieldExplosionSize.setFloat(explosion, explosionSize);
            } else {
                explosionSize = this.fieldExplosionSize.getFloat(explosion);
            }
            explosion.func_77278_a();
            if (world instanceof WorldServer) {
                this.doExplosionB(world, explosion, false, isCreeper, isSmoking, isFlaming, explosionSize);
                if (!isSmoking) {
                    explosion.func_180342_d();
                }
                Vec3d pos = explosion.getPosition();
                for (EntityPlayer player : world.field_73010_i) {
                    if (!(player.func_70092_e(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c) < 4096.0)) continue;
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketExplosion(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, explosionSize, explosion.func_180343_e(), (Vec3d)explosion.func_77277_b().get(player)));
                }
            } else {
                this.doExplosionB(world, explosion, true, isCreeper, isSmoking, isFlaming, explosionSize);
            }
        }
        catch (IllegalAccessException e) {
            EnvironmentalCreepers.logger.error("IllegalAccessException while reflecting explosion fields", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            EnvironmentalCreepers.logger.error("IllegalArgumentException while reflecting explosion fields", (Throwable)e);
        }
        event.setCanceled(true);
    }

    private void doExplosionB(World world, Explosion explosion, boolean spawnParticles, boolean isCreeper, boolean isSmoking, boolean isFlaming, float explosionSize) {
        Vec3d pos = explosion.getPosition();
        Random rand = world.field_73012_v;
        world.func_184148_a((EntityPlayer)null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.2f) * 0.7f);
        if (explosionSize >= 2.0f && isSmoking) {
            world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 1.0, 0.0, 0.0, new int[0]);
        } else {
            world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 1.0, 0.0, 0.0, new int[0]);
        }
        float dropChance = (float)(isCreeper ? Configs.creeperExplosionBlockDropChance : Configs.otherExplosionBlockDropChance);
        EnvironmentalCreepers.logInfo("ExplosionEventHandler.doExplosionB() - Type: '{}', drop chance: {}", isCreeper ? "Creeper" : "Other", Float.valueOf(dropChance));
        if (isSmoking) {
            for (BlockPos blockpos : explosion.func_180343_e()) {
                IBlockState iblockstate = world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (spawnParticles) {
                    double d0 = (float)blockpos.func_177958_n() + rand.nextFloat();
                    double d1 = (float)blockpos.func_177956_o() + rand.nextFloat();
                    double d2 = (float)blockpos.func_177952_p() + rand.nextFloat();
                    double d3 = d0 - pos.field_72450_a;
                    double d4 = d1 - pos.field_72448_b;
                    double d5 = d2 - pos.field_72449_c;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)explosionSize + 0.1);
                    world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + pos.field_72450_a) / 2.0, (d1 + pos.field_72448_b) / 2.0, (d2 + pos.field_72449_c) / 2.0, d3 *= (d7 *= (double)(rand.nextFloat() * rand.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
                }
                if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                if (block.func_149659_a(explosion)) {
                    block.func_180653_a(world, blockpos, iblockstate, dropChance, 0);
                }
                block.onBlockExploded(world, blockpos, explosion);
            }
        }
        if (isFlaming) {
            for (BlockPos blockpos : explosion.func_180343_e()) {
                if (rand.nextInt(3) != 0 || world.func_180495_p(blockpos).func_185904_a() != Material.field_151579_a || !world.func_180495_p(blockpos.func_177977_b()).func_185913_b()) continue;
                world.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }
}

