/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client;

import com.google.common.base.Throwables;
import com.google.common.collect.ForwardingSet;
import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.client.ClientEventHandler;
import com.pau101.fairylights.client.midi.CommandJingler;
import com.pau101.fairylights.client.renderer.FenceFastenerRendererDispatcher;
import com.pau101.fairylights.client.renderer.FenceFastenerRepresentative;
import com.pau101.fairylights.client.renderer.block.FastenerStateMapper;
import com.pau101.fairylights.client.renderer.block.entity.BlockEntityFastenerRenderer;
import com.pau101.fairylights.client.renderer.entity.RenderFenceFastener;
import com.pau101.fairylights.client.renderer.entity.RenderLadder;
import com.pau101.fairylights.server.ServerProxy;
import com.pau101.fairylights.server.block.entity.BlockEntityFastener;
import com.pau101.fairylights.server.entity.EntityFenceFastener;
import com.pau101.fairylights.server.entity.EntityLadder;
import com.pau101.fairylights.server.item.ItemLight;
import com.pau101.fairylights.server.item.LightVariant;
import com.pau101.fairylights.server.jingle.JingleLibrary;
import com.pau101.fairylights.util.styledstring.StyledString;
import java.lang.reflect.Field;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public final class ClientProxy
extends ServerProxy {
    public static FontRenderer recoloredFont;

    @Override
    public void initHandlers() {
        super.initHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    @Override
    public void initRenders() {
        ClientRegistry.bindTileEntitySpecialRenderer(BlockEntityFastener.class, (TileEntitySpecialRenderer)new BlockEntityFastenerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(FenceFastenerRepresentative.class, (TileEntitySpecialRenderer)FenceFastenerRendererDispatcher.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntityFenceFastener.class, RenderFenceFastener::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityLadder.class, RenderLadder::new);
        LightVariant[] lightVariants = LightVariant.values();
        for (int var = 0; var < lightVariants.length; ++var) {
            LightVariant variant = lightVariants[var];
            ModelResourceLocation model = new ModelResourceLocation("fairylights:light_" + variant.getName(), "inventory");
            int meta = var * 16;
            for (int color = 0; color < 16; ++color) {
                ModelLoader.setCustomModelResourceLocation((Item)FairyLights.light, (int)meta, (ModelResourceLocation)model);
                ++meta;
            }
        }
        this.setModel(FairyLights.hangingLights, "hanging_lights");
        this.setModel(FairyLights.garland, "garland");
        this.setModel(FairyLights.tinsel, "tinsel");
        this.setModel(FairyLights.pennantBunting, "pennant_bunting");
        this.setModel(FairyLights.letterBunting, "letter_bunting");
        for (int meta = 0; meta < 16; ++meta) {
            this.setModel(FairyLights.pennant, meta, "pennant");
        }
        this.setModel(FairyLights.ladder, "ladder");
        ModelLoader.setCustomStateMapper((Block)FairyLights.fastener, (IStateMapper)new FastenerStateMapper());
    }

    private void setModel(Item item, String id) {
        this.setModel(item, 0, id);
    }

    private void setModel(Item item, int meta, String id) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("fairylights:" + id, "inventory"));
    }

    @Override
    public void initRendersLate() {
        ItemColors colors = Minecraft.func_71410_x().getItemColors();
        colors.func_186730_a((stack, index) -> {
            if (index == 0 || ItemLight.getLightVariant(stack.func_77960_j()) == LightVariant.LUXO_BALL) {
                return -1;
            }
            return ItemLight.getColorValue(ItemLight.getLightColor(stack.func_77960_j()));
        }, new Item[]{FairyLights.light});
        colors.func_186730_a((stack, index) -> {
            NBTTagList tagList;
            if (index == 0) {
                return -1;
            }
            if (stack.func_77942_o() && (tagList = stack.func_77978_p().func_150295_c("pattern", 10)).func_74745_c() > 0) {
                return ItemLight.getColorValue(EnumDyeColor.func_176766_a((int)tagList.func_150305_b((index - 1) % tagList.func_74745_c()).func_74771_c("color")));
            }
            if (FairyLights.christmas.isOcurringNow()) {
                return ((long)index + System.currentTimeMillis() / 2000L) % 2L == 0L ? 0x993333 : 8375321;
            }
            return 16766340;
        }, new Item[]{FairyLights.hangingLights});
        colors.func_186730_a((stack, index) -> {
            EnumDyeColor color = stack.func_77942_o() ? EnumDyeColor.func_176766_a((int)stack.func_77978_p().func_74771_c("color")) : EnumDyeColor.BLACK;
            return ItemLight.getColorValue(color);
        }, new Item[]{FairyLights.tinsel});
        colors.func_186730_a((stack, index) -> {
            NBTTagList tagList;
            if (index == 0) {
                return -1;
            }
            if (stack.func_77942_o() && (tagList = stack.func_77978_p().func_150295_c("pattern", 10)).func_74745_c() > 0) {
                return ItemLight.getColorValue(EnumDyeColor.func_176766_a((int)tagList.func_150305_b((index - 1) % tagList.func_74745_c()).func_74771_c("color")));
            }
            return -1;
        }, new Item[]{FairyLights.pennantBunting});
        colors.func_186730_a((stack, index) -> {
            if (index == 0) {
                return -1;
            }
            return ItemLight.getColorValue(EnumDyeColor.func_176766_a((int)stack.func_77960_j()));
        }, new Item[]{FairyLights.pennant});
        colors.func_186730_a((stack, index) -> {
            StyledString str;
            if (index > 0 && stack.func_77942_o() && (str = StyledString.deserialize(stack.func_77978_p().func_74775_l("text"))).length() > 0) {
                TextFormatting lastColor = null;
                TextFormatting color = null;
                int n = (index - 1) % str.length();
                for (int i = 0; i < str.length() && (lastColor == (color = str.colorAt(i)) || n-- != 0); ++i) {
                    lastColor = color;
                }
                return StyledString.getColor(recoloredFont, color) | 0xFF000000;
            }
            return -1;
        }, new Item[]{FairyLights.letterBunting});
        this.initRecoloredFont();
        try {
            this.setupRenderGlobal();
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        Minecraft.func_71410_x().func_110434_K().func_110580_a(new ResourceLocation("fairylights", "hacky_hook"), new ITickableTextureObject(){

            public void func_110550_d() {
                ClientEventHandler.updateHitConnection();
            }

            public void func_174936_b(boolean blur, boolean mipmap) {
            }

            public void func_174935_a() {
            }

            public void func_110551_a(IResourceManager mgr) {
            }

            public int func_110552_b() {
                return 0;
            }
        });
    }

    private void initRecoloredFont() {
        recoloredFont = new FontRenderer(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o, false);
        int[] colorCode = (int[])ReflectionHelper.getPrivateValue(FontRenderer.class, (Object)recoloredFont, (String[])new String[]{"field_78285_g", "colorCode"});
        colorCode[0] = 0x191919;
        colorCode[16] = 263172;
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)recoloredFont);
    }

    @Override
    public void initEggs() {
        super.initEggs();
        CommandJingler cmd = new CommandJingler();
        ClientCommandHandler.instance.func_71560_a((ICommand)cmd);
        MinecraftForge.EVENT_BUS.register((Object)cmd);
    }

    @Override
    protected void loadJingleLibraries() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(m -> JingleLibrary.loadAll());
    }

    private void setupRenderGlobal() throws Exception {
        RenderGlobal render = Minecraft.func_71410_x().field_71438_f;
        Field setTileEntities = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{"field_181024_n", "setTileEntities"});
        Field modifiers = Field.class.getDeclaredField("modifiers");
        modifiers.setAccessible(true);
        modifiers.set(setTileEntities, setTileEntities.getModifiers() & 0xFFFFFFEF);
        final Set value = (Set)setTileEntities.get(render);
        setTileEntities.set(render, new ForwardingSet<TileEntity>(){

            protected Set<TileEntity> delegate() {
                return value;
            }

            public void clear() {
                super.clear();
                this.add((Object)FenceFastenerRepresentative.INSTANCE);
            }
        });
    }
}

