/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server;

import com.google.common.base.CaseFormat;
import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.server.ServerEventHandler;
import com.pau101.fairylights.server.block.BlockFastener;
import com.pau101.fairylights.server.block.entity.BlockEntityFastener;
import com.pau101.fairylights.server.capability.CapabilityHandler;
import com.pau101.fairylights.server.config.Configurator;
import com.pau101.fairylights.server.creativetabs.CreativeTabsFairyLights;
import com.pau101.fairylights.server.entity.EntityFenceFastener;
import com.pau101.fairylights.server.entity.EntityLadder;
import com.pau101.fairylights.server.item.ItemConnectionGarland;
import com.pau101.fairylights.server.item.ItemConnectionHangingLights;
import com.pau101.fairylights.server.item.ItemConnectionLetterBunting;
import com.pau101.fairylights.server.item.ItemConnectionPennantBunting;
import com.pau101.fairylights.server.item.ItemConnectionTinsel;
import com.pau101.fairylights.server.item.ItemLadder;
import com.pau101.fairylights.server.item.ItemLight;
import com.pau101.fairylights.server.item.ItemPennant;
import com.pau101.fairylights.server.item.LightVariant;
import com.pau101.fairylights.server.item.crafting.Recipes;
import com.pau101.fairylights.server.jingle.JingleLibrary;
import com.pau101.fairylights.server.net.FLMessage;
import com.pau101.fairylights.server.net.clientbound.MessageJingle;
import com.pau101.fairylights.server.net.clientbound.MessageOpenEditLetteredConnectionGUI;
import com.pau101.fairylights.server.net.clientbound.MessageUpdateFastenerEntity;
import com.pau101.fairylights.server.net.serverbound.MessageConnectionInteraction;
import com.pau101.fairylights.server.net.serverbound.MessageEditLetteredConnection;
import com.pau101.fairylights.server.sound.FLSounds;
import com.pau101.fairylights.util.CalendarEvent;
import com.pau101.fairylights.util.crafting.GenericRecipe;
import java.time.Month;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ServerProxy
implements IMessageHandler<FLMessage, IMessage> {
    private int nextMessageId;
    private int nextEntityId;

    public void initConfig(FMLPreInitializationEvent event) {
        Configurator.initConfig(event);
    }

    public void initSounds() {
        FLSounds.init();
    }

    public void initGUI() {
        FairyLights.fairyLightsTab = new CreativeTabsFairyLights();
    }

    public void initBlocks() {
        FairyLights.fastener = (BlockFastener)((Object)this.register((Block)new BlockFastener(), "fastener", false));
    }

    public void initItems() {
        FairyLights.light = this.register(new ItemLight(), "light");
        FairyLights.hangingLights = this.register(new ItemConnectionHangingLights(), "hanging_lights");
        FairyLights.garland = this.register(new ItemConnectionGarland(), "garland");
        FairyLights.tinsel = this.register(new ItemConnectionTinsel(), "tinsel");
        FairyLights.pennantBunting = this.register(new ItemConnectionPennantBunting(), "pennant_bunting");
        FairyLights.letterBunting = this.register(new ItemConnectionLetterBunting(), "letter_bunting");
        FairyLights.pennant = this.register(new ItemPennant(), "pennant");
        FairyLights.ladder = this.register(new ItemLadder(), "ladder");
    }

    public void initCrafting() {
        GameRegistry.addRecipe((IRecipe)Recipes.FAIRY_LIGHTS);
        GameRegistry.addRecipe((IRecipe)Recipes.FAIRY_LIGHTS_AUGMENTATION);
        for (LightVariant variant : LightVariant.values()) {
            GameRegistry.addRecipe((IRecipe)variant.getRecipe());
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)FairyLights.garland, 2), new Object[]{"I-I", Character.valueOf('I'), "ingotIron", Character.valueOf('-'), Blocks.field_150395_bd}));
        GameRegistry.addRecipe((IRecipe)Recipes.TINSEL_GARLAND);
        GameRegistry.addRecipe((IRecipe)Recipes.PENNANT_BUNTING);
        GameRegistry.addRecipe((IRecipe)Recipes.PENNANT_BUNTING_AUGMENTATION);
        GameRegistry.addRecipe((IRecipe)Recipes.PENNANT);
        GameRegistry.addRecipe((IRecipe)Recipes.LETTER_BUNTING);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FairyLights.ladder), new Object[]{"#/", "#/", "#/", Character.valueOf('#'), Blocks.field_150468_ap, Character.valueOf('/'), "stickWood"}));
        RecipeSorter.register((String)"fairylights:generic", GenericRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
    }

    public void initEggs() {
        FairyLights.christmas = new CalendarEvent(Month.DECEMBER, 24, 26);
        FairyLights.christmasJingles = JingleLibrary.create("christmas");
        FairyLights.randomJingles = JingleLibrary.create("random");
        this.loadJingleLibraries();
    }

    protected void loadJingleLibraries() {
        JingleLibrary.loadAll();
    }

    public void initEntities() {
        GameRegistry.registerTileEntity(BlockEntityFastener.class, (String)"Fastener");
        this.registerEntity(EntityFenceFastener.class, "Fastener", 160, Integer.MAX_VALUE, false);
        this.registerEntity(EntityLadder.class, "Ladder", 160, 3, true);
    }

    public void initHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventHandler());
        CapabilityHandler.register();
    }

    public void initNetwork() {
        FairyLights.network = NetworkRegistry.INSTANCE.newSimpleChannel("fairylights");
        this.registerMessage(MessageJingle.class, Side.CLIENT);
        this.registerMessage(MessageUpdateFastenerEntity.class, Side.CLIENT);
        this.registerMessage(MessageOpenEditLetteredConnectionGUI.class, Side.CLIENT);
        this.registerMessage(MessageConnectionInteraction.class, Side.SERVER);
        this.registerMessage(MessageEditLetteredConnection.class, Side.SERVER);
    }

    public void initRenders() {
    }

    public void initRendersLate() {
    }

    @Nullable
    public IMessage onMessage(FLMessage message, MessageContext ctx) {
        IThreadListener thread = FMLCommonHandler.instance().getWorldThread(ctx.netHandler);
        thread.func_152344_a(() -> message.process(ctx));
        return null;
    }

    public static void sendToPlayersWatchingChunk(FLMessage message, World world, BlockPos pos) {
        PlayerChunkMap map = ((WorldServer)world).func_184164_w();
        PlayerChunkMapEntry e = map.func_187301_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (e != null) {
            e.func_187267_a(FairyLights.network.getPacketFrom((IMessage)message));
        }
    }

    public static void sendToPlayersWatchingEntity(FLMessage message, World world, Entity entity) {
        for (EntityPlayer player : ((WorldServer)world).func_73039_n().getTrackingPlayers(entity)) {
            FairyLights.network.sendTo((IMessage)message, (EntityPlayerMP)player);
        }
        if (entity instanceof EntityPlayerMP) {
            FairyLights.network.sendTo((IMessage)message, (EntityPlayerMP)entity);
        }
    }

    private void registerMessage(Class<? extends FLMessage> clazz, Side toSide) {
        FairyLights.network.registerMessage((IMessageHandler)this, clazz, this.nextMessageId++, toSide);
    }

    private <B extends Block> B register(B block, String name) {
        return this.register(block, name, true);
    }

    private <B extends Block> B register(Block block, String name, boolean hasItem) {
        GameRegistry.register((IForgeRegistryEntry)block.setRegistryName(name));
        if (hasItem) {
            GameRegistry.register((IForgeRegistryEntry)new ItemBlock(block).setRegistryName(name));
        }
        return (B)block.func_149663_c(this.toUnlocalizedName(name));
    }

    private <T extends Item> T register(T item, String name) {
        item.setRegistryName(name);
        GameRegistry.register(item);
        return (T)item.func_77655_b(this.toUnlocalizedName(name));
    }

    private void registerEntity(Class<? extends Entity> clazz, String id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity(clazz, (String)id, (int)this.nextEntityId++, (Object)FairyLights.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    private String toUnlocalizedName(String name) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
    }
}

