/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.fastener.accessor;

import com.pau101.fairylights.server.capability.CapabilityHandler;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.FastenerEntity;
import com.pau101.fairylights.server.fastener.accessor.FastenerAccessor;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class FastenerAccessorEntity<E extends Entity>
implements FastenerAccessor {
    private Class<? extends E> entityClass;
    private UUID uuid;
    @Nullable
    private E entity;

    public FastenerAccessorEntity(Class<? extends E> entityClass) {
        this(entityClass, (UUID)null);
    }

    public FastenerAccessorEntity(Class<? extends E> entityClass, FastenerEntity<E> fastener) {
        this(entityClass, fastener.getEntity().func_110124_au());
        this.entity = fastener.getEntity();
    }

    public FastenerAccessorEntity(Class<? extends E> entityClass, UUID uuid) {
        this.entityClass = entityClass;
        this.uuid = uuid;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public E getEntity() {
        return this.entity;
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    protected boolean equalsUUID(Entity entity) {
        return this.uuid.equals(entity.func_110124_au());
    }

    @Override
    public Fastener<?> get(World world) {
        return (Fastener)this.entity.getCapability(CapabilityHandler.FASTENER_CAP, null);
    }

    @Override
    public boolean isLoaded(World world) {
        return this.entity != null;
    }

    @Override
    public boolean exists(World world) {
        return this.entity == null || !((Entity)this.entity).field_70128_L;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FastenerAccessorEntity) {
            return this.uuid.equals(((FastenerAccessorEntity)obj).uuid);
        }
        return false;
    }

    @Override
    public void update(World world, BlockPos pos) {
        if (this.entity == null) {
            AxisAlignedBB aabb = new AxisAlignedBB(pos).func_186662_g(32.0);
            List nearEntities = world.func_72872_a(this.entityClass, aabb);
            for (Entity entity : nearEntities) {
                if (!this.equalsUUID(entity)) continue;
                this.entity = entity;
                break;
            }
        }
    }

    @Override
    public NBTTagCompound serialize() {
        return NBTUtil.func_186862_a((UUID)this.uuid);
    }

    @Override
    public void deserialize(NBTTagCompound nbt) {
        this.uuid = NBTUtil.func_186860_b((NBTTagCompound)nbt);
        this.entity = null;
    }
}

