/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.item.crafting;

import com.google.common.collect.ImmutableList;
import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.server.item.ItemLight;
import com.pau101.fairylights.server.item.LightVariant;
import com.pau101.fairylights.util.Mth;
import com.pau101.fairylights.util.OreDictUtils;
import com.pau101.fairylights.util.Utils;
import com.pau101.fairylights.util.crafting.GenericRecipeBuilder;
import com.pau101.fairylights.util.crafting.ingredient.Ingredient;
import com.pau101.fairylights.util.crafting.ingredient.IngredientAuxiliaryBasic;
import com.pau101.fairylights.util.crafting.ingredient.IngredientAuxiliaryBasicInert;
import com.pau101.fairylights.util.crafting.ingredient.IngredientAuxiliaryListInert;
import com.pau101.fairylights.util.crafting.ingredient.IngredientRegular;
import com.pau101.fairylights.util.crafting.ingredient.IngredientRegularBasic;
import com.pau101.fairylights.util.crafting.ingredient.IngredientRegularDye;
import com.pau101.fairylights.util.crafting.ingredient.IngredientRegularOre;
import com.pau101.fairylights.util.styledstring.StyledString;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.commons.lang3.mutable.MutableInt;

public final class Recipes {
    public static final IngredientRegular LIGHT_DYE = new IngredientRegularDye(){

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            return ImmutableList.of(OreDictUtils.getDyes(ItemLight.getLightColor(output.func_77952_i())));
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public void matched(ItemStack ingredient, ItemStack output) {
            output.func_77964_b(Mth.floorInterval(output.func_77960_j(), 16) + OreDictUtils.getDyeMetadata(ingredient));
        }
    };
    public static final IRecipe FAIRY_LIGHTS = new GenericRecipeBuilder(FairyLights.hangingLights).withShape("I-I").withIngredient('I', "ingotIron").withAnyIngredient('-', new IngredientRegularBasic(Items.field_151007_F){

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            return Recipes.useInputsForTagBool(this, output, "tight", false) ? super.getInput(output) : ImmutableList.of();
        }
    }, new IngredientRegularOre("stickWood"){

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            return Recipes.useInputsForTagBool(this, output, "tight", true) ? super.getInput(output) : ImmutableList.of();
        }

        @Override
        public void present(ItemStack output) {
            output.func_77978_p().func_74757_a("tight", true);
        }

        @Override
        public void absent(ItemStack output) {
            output.func_77978_p().func_74757_a("tight", false);
        }
    }).withAuxiliaryIngredient(new LightIngredient(true)).withAuxiliaryIngredient(new IngredientAuxiliaryBasicInert(Items.field_151114_aO, false, 1){

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            return Recipes.useInputsForTagBool(this, output, "twinkle", true) ? super.getInput(output) : ImmutableList.of();
        }

        @Override
        public void present(ItemStack output) {
            output.func_77978_p().func_74757_a("twinkle", true);
        }

        @Override
        public void absent(ItemStack output) {
            output.func_77978_p().func_74757_a("twinkle", false);
        }

        @Override
        public void addTooltip(List<String> tooltip) {
            super.addTooltip(tooltip);
            tooltip.add(Utils.formatRecipeTooltip("recipe.hangingLights.glowstone"));
        }
    }).build();
    public static final IRecipe FAIRY_LIGHTS_AUGMENTATION = new GenericRecipeBuilder(FairyLights.hangingLights).withShape("F").withIngredient('F', new IngredientRegularBasic(FairyLights.hangingLights){

        @Override
        public ImmutableList<ItemStack> getInputs() {
            ItemStack stack = this.ingredient.func_77946_l();
            stack.func_77982_d(new NBTTagCompound());
            return Recipes.makeHangingLightsExamples(stack);
        }

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            ItemStack stack = output.func_77946_l();
            NBTTagCompound compound = stack.func_77978_p();
            if (compound == null) {
                return ImmutableList.of();
            }
            stack.field_77994_a = 1;
            compound.func_74757_a("twinkle", false);
            return ImmutableList.of((Object)ImmutableList.of((Object)stack));
        }

        @Override
        public void matched(ItemStack ingredient, ItemStack output) {
            NBTTagCompound compound = ingredient.func_77978_p();
            if (compound != null) {
                output.func_77982_d(compound.func_74737_b());
            }
        }
    }).withAuxiliaryIngredient(new IngredientAuxiliaryListInert(true, new LightIngredient(false){

        @Override
        public ImmutableList<ItemStack> getInputs() {
            return ImmutableList.of();
        }

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            return ImmutableList.of();
        }
    }, new IngredientAuxiliaryBasic<MutableInt>(Items.field_151114_aO, false, 1){

        @Override
        public MutableInt accumulator() {
            return new MutableInt();
        }

        @Override
        public void consume(MutableInt count, ItemStack ingredient) {
            count.increment();
        }

        @Override
        public boolean finish(MutableInt count, ItemStack output) {
            if (count.intValue() > 0) {
                if (output.func_77978_p().func_74767_n("twinkle")) {
                    return true;
                }
                output.func_77978_p().func_74757_a("twinkle", true);
            }
            return false;
        }
    })).build();
    public static final IRecipe TINSEL_GARLAND = new GenericRecipeBuilder(FairyLights.tinsel).withShape(" P ", "I-I", " D ").withIngredient('P', Items.field_151121_aF).withIngredient('I', "ingotIron").withIngredient('-', Items.field_151007_F).withIngredient('D', new IngredientRegularDye(){

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            NBTTagCompound compound = output.func_77978_p();
            if (compound == null) {
                return ImmutableList.of();
            }
            return ImmutableList.of(OreDictUtils.getDyes(EnumDyeColor.func_176766_a((int)compound.func_74771_c("color"))));
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public void matched(ItemStack ingredient, ItemStack output) {
            output.func_77978_p().func_74774_a("color", (byte)OreDictUtils.getDyeMetadata(ingredient));
        }
    }).build();
    public static final IRecipe PENNANT_BUNTING = new GenericRecipeBuilder(FairyLights.pennantBunting).withShape("I-I").withIngredient('I', "ingotIron").withIngredient('-', Items.field_151007_F).withAuxiliaryIngredient(new PennantIngredient()).build();
    public static final IRecipe PENNANT_BUNTING_AUGMENTATION = new GenericRecipeBuilder(FairyLights.pennantBunting).withShape("B").withIngredient('B', new IngredientRegularBasic(FairyLights.pennantBunting){

        @Override
        public ImmutableList<ItemStack> getInputs() {
            ItemStack stack = this.ingredient.func_77946_l();
            stack.func_77982_d(new NBTTagCompound());
            return Recipes.makePennantExamples(stack);
        }

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            NBTTagCompound compound = output.func_77978_p();
            if (compound == null) {
                return ImmutableList.of();
            }
            return ImmutableList.of((Object)Recipes.makePennantExamples(output));
        }

        @Override
        public void matched(ItemStack ingredient, ItemStack output) {
            NBTTagCompound compound = ingredient.func_77978_p();
            if (compound != null) {
                output.func_77982_d(compound.func_74737_b());
            }
        }
    }).withAuxiliaryIngredient(new PennantIngredient()).build();
    public static final IRecipe PENNANT = new GenericRecipeBuilder(FairyLights.pennant).withShape("- -", "PDP", " P ").withIngredient('P', Items.field_151121_aF).withIngredient('-', Items.field_151007_F).withIngredient('D', new IngredientRegularDye(){

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            return ImmutableList.of(OreDictUtils.getDyes(EnumDyeColor.func_176766_a((int)output.func_77952_i())));
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public void matched(ItemStack ingredient, ItemStack output) {
            output.func_77964_b(OreDictUtils.getDyeMetadata(ingredient));
        }
    }).build();
    public static final IRecipe LETTER_BUNTING = new GenericRecipeBuilder(FairyLights.letterBunting).withShape("I-I", "PBF").withIngredient('I', "ingotIron").withIngredient('-', Items.field_151007_F).withIngredient('P', Items.field_151121_aF).withIngredient('B', "dyeBlack").withIngredient('F', new IngredientRegularBasic(Items.field_151008_G){

        @Override
        public void present(ItemStack output) {
            output.func_77983_a("text", (NBTBase)StyledString.serialize(new StyledString()));
        }
    }).build();

    private Recipes() {
    }

    private static boolean useInputsForTagBool(Ingredient ingredient, ItemStack output, String key, boolean value) {
        NBTTagCompound compound = output.func_77978_p();
        return compound != null && compound.func_74767_n(key) == value;
    }

    private static ImmutableList<ItemStack> makeHangingLightsExamples(ItemStack stack) {
        return ImmutableList.of((Object)Recipes.makeHangingLights(stack, EnumDyeColor.CYAN, EnumDyeColor.MAGENTA, EnumDyeColor.CYAN, EnumDyeColor.WHITE));
    }

    public static ItemStack makeHangingLights(ItemStack base, EnumDyeColor ... colors) {
        ItemStack stack = base.func_77946_l();
        NBTTagCompound compound = stack.func_77978_p();
        NBTTagList lights = new NBTTagList();
        for (EnumDyeColor color : colors) {
            NBTTagCompound pennant = new NBTTagCompound();
            pennant.func_74774_a("color", (byte)color.func_176767_b());
            pennant.func_74768_a("light", LightVariant.FAIRY.ordinal());
            lights.func_74742_a((NBTBase)pennant);
        }
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        compound.func_74782_a("pattern", (NBTBase)lights);
        compound.func_74757_a("twinkle", false);
        compound.func_74757_a("tight", false);
        return stack;
    }

    private static ImmutableList<ItemStack> makePennantExamples(ItemStack stack) {
        return ImmutableList.of((Object)Recipes.makePennant(stack, EnumDyeColor.BLUE, EnumDyeColor.YELLOW, EnumDyeColor.RED), (Object)Recipes.makePennant(stack, EnumDyeColor.PINK, EnumDyeColor.LIGHT_BLUE), (Object)Recipes.makePennant(stack, EnumDyeColor.ORANGE, EnumDyeColor.WHITE), (Object)Recipes.makePennant(stack, EnumDyeColor.LIME, EnumDyeColor.YELLOW));
    }

    private static ItemStack makePennant(ItemStack base, EnumDyeColor ... colors) {
        ItemStack stack = base.func_77946_l();
        NBTTagCompound compound = stack.func_77978_p();
        NBTTagList pennants = new NBTTagList();
        for (EnumDyeColor color : colors) {
            NBTTagCompound pennant = new NBTTagCompound();
            pennant.func_74774_a("color", (byte)color.func_176767_b());
            pennants.func_74742_a((NBTBase)pennant);
        }
        compound.func_74782_a("pattern", (NBTBase)pennants);
        return stack;
    }

    private static class PennantIngredient
    extends IngredientAuxiliaryBasic<NBTTagList> {
        public PennantIngredient() {
            super(new ItemStack(FairyLights.pennant, 1, Short.MAX_VALUE), true, 8);
        }

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            NBTTagCompound compound = output.func_77978_p();
            if (compound == null) {
                return ImmutableList.of();
            }
            NBTTagList pattern = compound.func_150295_c("pattern", 10);
            if (pattern.func_82582_d()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder pennants = ImmutableList.builder();
            for (int i = 0; i < pattern.func_74745_c(); ++i) {
                NBTTagCompound pennant = pattern.func_150305_b(i);
                pennants.add((Object)ImmutableList.of((Object)new ItemStack(FairyLights.pennant, 1, (int)pennant.func_74771_c("color"))));
            }
            return pennants.build();
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public NBTTagList accumulator() {
            return new NBTTagList();
        }

        @Override
        public void consume(NBTTagList patternList, ItemStack ingredient) {
            NBTTagCompound pennant = new NBTTagCompound();
            pennant.func_74774_a("color", (byte)ingredient.func_77960_j());
            patternList.func_74742_a((NBTBase)pennant);
        }

        @Override
        public boolean finish(NBTTagList pattern, ItemStack output) {
            if (pattern.func_74745_c() > 0) {
                output.func_77983_a("pattern", (NBTBase)pattern);
                output.func_77983_a("text", (NBTBase)StyledString.serialize(new StyledString()));
            }
            return false;
        }

        @Override
        public void addTooltip(List<String> tooltip) {
            tooltip.add(Utils.formatRecipeTooltip("recipe.pennantBunting.pennant"));
        }
    }

    private static class LightIngredient
    extends IngredientAuxiliaryBasic<NBTTagList> {
        public LightIngredient(boolean isRequired) {
            super(FairyLights.light, Short.MAX_VALUE, isRequired, 8);
        }

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            NBTTagCompound compound = output.func_77978_p();
            if (compound == null) {
                return ImmutableList.of();
            }
            NBTTagList pattern = compound.func_150295_c("pattern", 10);
            if (pattern.func_82582_d()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder lights = ImmutableList.builder();
            for (int i = 0; i < pattern.func_74745_c(); ++i) {
                NBTTagCompound light = pattern.func_150305_b(i);
                int meta = light.func_74762_e("light") * 16 + light.func_74771_c("color");
                lights.add((Object)ImmutableList.of((Object)new ItemStack((Item)FairyLights.light, 1, meta)));
            }
            return lights.build();
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public NBTTagList accumulator() {
            return new NBTTagList();
        }

        @Override
        public void consume(NBTTagList patternList, ItemStack ingredient) {
            int variant = ingredient.func_77960_j();
            NBTTagCompound light = new NBTTagCompound();
            light.func_74768_a("light", ItemLight.getLightVariantOrdinal(variant));
            light.func_74774_a("color", ItemLight.getLightColorOrdinal(variant));
            patternList.func_74742_a((NBTBase)light);
        }

        @Override
        public boolean finish(NBTTagList pattern, ItemStack output) {
            if (pattern.func_74745_c() > 0) {
                output.func_77983_a("pattern", (NBTBase)pattern);
            }
            return false;
        }

        @Override
        public void addTooltip(List<String> tooltip) {
            tooltip.add(Utils.formatRecipeTooltip("recipe.hangingLights.light"));
        }
    }
}

