/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util;

import net.minecraft.util.math.MathHelper;

public final class CatenaryUtils {
    public static final int SEG_LENGTH = 3;
    private static final int MAX_ITER = 100;
    private static final float MIN_GRAD = 1.0E-10f;
    private static final float MIN_VAL = 1.0E-8f;
    private static final float STEP_DEC = 0.5f;
    private static final float MIN_STEP = 1.0E-9f;
    private static final float MIN_HORIZ = 0.001f;

    private CatenaryUtils() {
    }

    public static float[][] catenary(float x1, float y1, float x2, float y2, float length, int pointCount) {
        return CatenaryUtils.catenary(x1, y1, x2, y2, length, pointCount, 1.0f);
    }

    private static float[][] catenary(float x1, float y1, float x2, float y2, float length, int pointCount, float sag) {
        if (x1 > x2) {
            float temp = x1;
            x2 = x1 = x2;
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        float d = x2 - x1;
        float h = y2 - y1;
        if (MathHelper.func_76135_e((float)d) < 0.001f) {
            float[] y;
            float[] x = new float[pointCount];
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                x[i] = (x1 + x2) / 2.0f;
            }
            if (length < MathHelper.func_76135_e((float)h)) {
                y = CatenaryUtils.linspace(y1, y2, pointCount);
            } else {
                sag = (length - MathHelper.func_76135_e((float)h)) / 2.0f;
                int nSag = MathHelper.func_76123_f((float)((float)pointCount * sag / length));
                float yMax = Math.max(y1, y2);
                float yMin = Math.min(y1, y2);
                y = CatenaryUtils.concat(CatenaryUtils.linspace(yMax, yMin - sag, pointCount - nSag), CatenaryUtils.linspace(yMin - sag, yMin, nSag));
            }
            return new float[][]{x, y};
        }
        float[] x = CatenaryUtils.linspace(x1, x2, pointCount);
        if (length <= MathHelper.func_76129_c((float)(d * d + h * h))) {
            float[] y = CatenaryUtils.linspace(y1, y2, pointCount);
            return new float[][]{x, y};
        }
        for (int iter = 0; iter < 100; ++iter) {
            float val = CatenaryUtils.g(sag, d, length, h);
            float grad = CatenaryUtils.dg(sag, d);
            if (MathHelper.func_76135_e((float)val) < 1.0E-8f || MathHelper.func_76135_e((float)grad) < 1.0E-10f) break;
            float search = -CatenaryUtils.g(sag, d, length, h) / CatenaryUtils.dg(sag, d);
            float alpha = 1.0f;
            float sagNew = sag + alpha * search;
            float valAbs = MathHelper.func_76135_e((float)val);
            while ((sagNew < 0.0f || MathHelper.func_76135_e((float)CatenaryUtils.g(sagNew, d, length, h)) > valAbs) && !((alpha = 0.5f * alpha) < 1.0E-9f)) {
                sagNew = sag + alpha * search;
            }
            sag = sagNew;
        }
        float xLeft = 0.5f * ((float)Math.log((length + h) / (length - h)) / sag - d);
        float xMin = x1 - xLeft;
        float bias = y1 - (float)Math.cosh(xLeft * sag) / sag;
        float[] y = new float[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = (float)Math.cosh((x[i] - xMin) * sag) / sag + bias;
        }
        return new float[][]{x, y};
    }

    private static float[] concat(float[] a, float[] b) {
        int aLength = a.length;
        int bLength = b.length;
        float[] concat = new float[aLength + bLength];
        System.arraycopy(a, 0, concat, 0, aLength);
        System.arraycopy(b, 0, concat, aLength, bLength);
        return concat;
    }

    private static float dg(float s, float d) {
        return 2.0f * (float)Math.cosh(s * d / 2.0f) * d / (2.0f * s) - 2.0f * (float)Math.sinh(s * d / 2.0f) / (s * s);
    }

    private static float g(float s, float d, float length, float h) {
        return 2.0f * (float)Math.sinh(s * d / 2.0f) / s - MathHelper.func_76129_c((float)(length * length - h * h));
    }

    private static float[] linspace(float base, float limit, int n) {
        float[] elements = new float[n];
        float scalar = n > 1 ? (limit - base) / (float)(n - 1) : 0.0f;
        for (int i = 0; i < n; ++i) {
            elements[i] = base + scalar * (float)i;
        }
        return elements;
    }
}

