/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.common.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mods.octarinecore.client.gui.NonVerboseArrayEntry;
import mods.octarinecore.client.resource.Utils;
import mods.octarinecore.common.config.ConfigPropertyBase;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J(\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0016J\u0017\u0010'\u001a\u0004\u0018\u00018\u00002\u0006\u0010(\u001a\u00020\u0004H&\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020!H\u0016J.\u0010+\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040-\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040-0,2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\nR\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\nR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000e\"\u0004\b\u001f\u0010\u0010\u00a8\u0006."}, d2={"Lmods/octarinecore/common/config/BlackWhiteListConfigOption;", "VALUE", "Lmods/octarinecore/common/config/ConfigPropertyBase;", "domain", "", "path", "(Ljava/lang/String;Ljava/lang/String;)V", "blackList", "", "getBlackList", "()Ljava/util/List;", "blacklistProperty", "Lnet/minecraftforge/common/config/Property;", "getBlacklistProperty", "()Lnet/minecraftforge/common/config/Property;", "setBlacklistProperty", "(Lnet/minecraftforge/common/config/Property;)V", "getDomain", "()Ljava/lang/String;", "guiProperties", "", "getGuiProperties", "hasChanged", "", "getHasChanged", "()Z", "getPath", "whiteList", "getWhiteList", "whitelistProperty", "getWhitelistProperty", "setWhitelistProperty", "attach", "", "target", "Lnet/minecraftforge/common/config/Configuration;", "langPrefix", "categoryName", "propertyName", "convertValue", "line", "(Ljava/lang/String;)Ljava/lang/Object;", "read", "readDefaults", "Lkotlin/Pair;", "", "BetterFoliage_main"})
public abstract class BlackWhiteListConfigOption<VALUE>
extends ConfigPropertyBase {
    @NotNull
    private final List<VALUE> blackList;
    @NotNull
    private final List<VALUE> whiteList;
    @Nullable
    private Property blacklistProperty;
    @Nullable
    private Property whitelistProperty;
    @NotNull
    private final String domain;
    @NotNull
    private final String path;

    @NotNull
    public final List<VALUE> getBlackList() {
        return this.blackList;
    }

    @NotNull
    public final List<VALUE> getWhiteList() {
        return this.whiteList;
    }

    @Nullable
    public final Property getBlacklistProperty() {
        return this.blacklistProperty;
    }

    public final void setBlacklistProperty(@Nullable Property property) {
        this.blacklistProperty = property;
    }

    @Nullable
    public final Property getWhitelistProperty() {
        return this.whitelistProperty;
    }

    public final void setWhitelistProperty(@Nullable Property property) {
        this.whitelistProperty = property;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getHasChanged() {
        Property property = this.blacklistProperty;
        if (property != null ? property.hasChanged() : false) return true;
        Property property2 = this.whitelistProperty;
        if (property2 == null) return false;
        boolean bl = property2.hasChanged();
        if (!bl) return false;
        return true;
    }

    @Override
    @NotNull
    public List<Property> getGuiProperties() {
        Property[] propertyArray = new Property[2];
        Property property = this.whitelistProperty;
        if (property == null) {
            Intrinsics.throwNpe();
        }
        propertyArray[0] = property;
        Property property2 = this.blacklistProperty;
        if (property2 == null) {
            Intrinsics.throwNpe();
        }
        propertyArray[1] = property2;
        return CollectionsKt.listOf(propertyArray);
    }

    @Override
    public void attach(@NotNull Configuration target, @NotNull String langPrefix, @NotNull String categoryName, @NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(target, "target");
        Intrinsics.checkParameterIsNotNull(langPrefix, "langPrefix");
        Intrinsics.checkParameterIsNotNull(categoryName, "categoryName");
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        this.setLang(null);
        Pair<String[], String[]> defaults = this.readDefaults(this.domain, this.path);
        this.blacklistProperty = target.get(categoryName, propertyName + "Blacklist", defaults.getFirst());
        this.whitelistProperty = target.get(categoryName, propertyName + "Whitelist", defaults.getSecond());
        Property[] propertyArray = new Property[2];
        Property property = this.blacklistProperty;
        if (property == null) {
            Intrinsics.throwNpe();
        }
        propertyArray[0] = property;
        Property property2 = this.whitelistProperty;
        if (property2 == null) {
            Intrinsics.throwNpe();
        }
        propertyArray[1] = property2;
        Iterable $receiver$iv = CollectionsKt.listOf(propertyArray);
        for (Object element$iv : $receiver$iv) {
            Property it = (Property)element$iv;
            it.setConfigEntryClass(NonVerboseArrayEntry.class);
            it.setLanguageKey(langPrefix + "." + categoryName + "." + it.getName());
        }
        this.read();
    }

    @Nullable
    public abstract VALUE convertValue(@NotNull String var1);

    @Override
    public void read() {
        Pair[] pairArray = new Pair[2];
        Property property = this.blacklistProperty;
        if (property == null) {
            Intrinsics.throwNpe();
        }
        pairArray[0] = new Pair<List<VALUE>, Property>(this.blackList, property);
        Property property2 = this.whitelistProperty;
        if (property2 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[1] = new Pair<List<VALUE>, Property>(this.whiteList, property2);
        Iterable $receiver$iv = CollectionsKt.listOf(pairArray);
        for (Object element$iv : $receiver$iv) {
            Pair it = (Pair)element$iv;
            ((List)it.getFirst()).clear();
            Object[] $receiver$iv2 = ((Property)it.getSecond()).getStringList();
            for (int i = 0; i < $receiver$iv2.length; ++i) {
                String line;
                Object element$iv2 = $receiver$iv2[i];
                String string = line = (String)element$iv2;
                Intrinsics.checkExpressionValueIsNotNull(string, "line");
                VALUE value = this.convertValue(string);
                if (value == null) continue;
                ((List)it.getFirst()).add(value);
            }
        }
    }

    @NotNull
    public final Pair<String[], String[]> readDefaults(@NotNull String domain, @NotNull String path) {
        Object object;
        Object object2;
        Iterable $receiver$iv;
        List<String> defaults;
        Intrinsics.checkParameterIsNotNull(domain, "domain");
        Intrinsics.checkParameterIsNotNull(path, "path");
        ArrayList blackList = new ArrayList();
        ArrayList<String> whiteList = new ArrayList<String>();
        IResource iResource = Utils.get((IResourceManager)Utils.getResourceManager(), domain, path);
        List<String> list = defaults = iResource != null ? Utils.getLines(iResource) : null;
        if (list != null) {
            Object object3;
            String it;
            Iterable $receiver$iv$iv;
            Iterable iterable = $receiver$iv = (Iterable)list;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                String string = (String)item$iv$iv;
                object2 = destination$iv$iv;
                object3 = it;
                void v2 = object3;
                if (v2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                object = ((Object)StringsKt.trim((CharSequence)v2)).toString();
                object2.add(object);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                it = (String)element$iv$iv;
                if (!(!StringsKt.startsWith$default(it, "//", false, 2, null) && (object3 = (CharSequence)it).length() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                String it2 = (String)element$iv;
                if (StringsKt.startsWith$default(it2, "-", false, 2, null)) {
                    String string;
                    String string2 = it2;
                    int n = 1;
                    object3 = blackList;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull(string3.substring(n), "(this as java.lang.String).substring(startIndex)");
                    ((ArrayList)object3).add(string);
                    continue;
                }
                whiteList.add(it2);
            }
        }
        $receiver$iv = blackList;
        Collection thisCollection$iv = (Collection)$receiver$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        $receiver$iv = whiteList;
        object2 = stringArray;
        thisCollection$iv = (Collection)$receiver$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        object = stringArray2;
        return TuplesKt.to(object2, object);
    }

    @NotNull
    public final String getDomain() {
        return this.domain;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public BlackWhiteListConfigOption(@NotNull String domain, @NotNull String path) {
        List list;
        Intrinsics.checkParameterIsNotNull(domain, "domain");
        Intrinsics.checkParameterIsNotNull(path, "path");
        this.domain = domain;
        this.path = path;
        BlackWhiteListConfigOption blackWhiteListConfigOption = this;
        blackWhiteListConfigOption.blackList = list = (List)new ArrayList();
        blackWhiteListConfigOption = this;
        blackWhiteListConfigOption.whiteList = list = (List)new ArrayList();
    }
}

