/*
 * Decompiled with CFR 0.152.
 */
package panda.maille;

import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="maille", name="Maille", version="1.0", acceptedMinecraftVersions="[1.10.2]")
public class Maille {
    public static final String MODID = "maille";
    public static final String NAME = "Maille";
    public static final String VERSION = "1.0";
    public static Logger log;
    @Mod.Instance(value="maille")
    public static Maille instance;
    public static Item IronNugget;
    public static Item ChainMesh;
    public static Item ChainLinks;
    public static int numChains;
    public static int numMesh;
    public static boolean useIngots;
    public static boolean use3x3ForMesh;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Maille.registerItem(IronNugget, "ironnugget");
        Maille.registerItem(ChainMesh, "chainmesh");
        Maille.registerItem(ChainLinks, "chainlinks");
        OreDictionary.registerOre((String)"nuggetIron", (Item)IronNugget);
        log = LogManager.getLogger((String)NAME);
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        numChains = config.getInt("CHAINS_FROM_NUGGETS", "general", 3, 1, 6, "");
        numMesh = config.getInt("MESH_FROM_CHAINS", "general", 1, 1, 6, "");
        useIngots = config.getBoolean("USE_INGOTS_IN BOOTS", "general", true, "");
        use3x3ForMesh = config.getBoolean("USE_3x3_RECIPE_FOR_MESH", "general", false, "");
        config.save();
        if (event.getSide() == Side.CLIENT) {
            ModelLoader.setCustomModelResourceLocation((Item)IronNugget, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(MODID, "ironnugget"), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)ChainMesh, (int)0, (ModelResourceLocation)new ModelResourceLocation(ChainMesh.getRegistryName(), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)ChainLinks, (int)0, (ModelResourceLocation)new ModelResourceLocation(ChainLinks.getRegistryName(), "inventory"));
        }
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(IronNugget, 9), (Object[])new Object[]{new ItemStack(Items.field_151042_j)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.field_151042_j), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(IronNugget)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ChainLinks, numChains), (Object[])new Object[]{" # ", "# #", " # ", Character.valueOf('#'), new ItemStack(IronNugget)});
        for (ItemStack nugget : OreDictionary.getOres((String)"nuggetIron")) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(ChainLinks, numChains), (Object[])new Object[]{" # ", "# #", " # ", Character.valueOf('#'), nugget});
        }
        if (use3x3ForMesh) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(ChainMesh, numMesh), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ChainLinks)});
        } else {
            GameRegistry.addRecipe((ItemStack)new ItemStack(ChainMesh, numMesh), (Object[])new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(ChainLinks)});
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151020_U), (Object[])new Object[]{"###", "# #", Character.valueOf('#'), new ItemStack(ChainMesh)});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151023_V), (Object[])new Object[]{"# #", "###", "###", Character.valueOf('#'), new ItemStack(ChainMesh)});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151022_W), (Object[])new Object[]{"###", "# #", "# #", Character.valueOf('#'), new ItemStack(ChainMesh)});
        if (useIngots) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151029_X), (Object[])new Object[]{"# #", "I I", Character.valueOf('#'), new ItemStack(ChainMesh), Character.valueOf('I'), new ItemStack(Items.field_151042_j)});
            for (ItemStack ingot : OreDictionary.getOres((String)"ingotIron")) {
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151029_X), (Object[])new Object[]{"# #", "I I", Character.valueOf('#'), new ItemStack(ChainMesh), Character.valueOf('I'), ingot});
            }
        } else {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151029_X), (Object[])new Object[]{"# #", "# #", Character.valueOf('#'), new ItemStack(ChainMesh)});
            for (ItemStack ingot : OreDictionary.getOres((String)"ingotIron")) {
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151029_X), (Object[])new Object[]{"# #", "# #", Character.valueOf('#'), new ItemStack(ChainMesh)});
            }
        }
    }

    private static Item registerItem(Item item, String name) {
        item.setRegistryName(name);
        item.func_77655_b(item.getRegistryName().func_110624_b() + "." + name);
        GameRegistry.register((IForgeRegistryEntry)item);
        item.func_77637_a(CreativeTabs.field_78035_l);
        return item;
    }

    @Mod.EventHandler
    public void PostInitialize(FMLPostInitializationEvent event) {
    }

    static {
        IronNugget = new Item();
        ChainMesh = new Item();
        ChainLinks = new Item();
    }
}

