/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LinkedBlock {
    public String blockName;
    public BlockPos blockPos = null;

    public LinkedBlock(String name, BlockPos pos) {
        this.blockName = name;
        this.blockPos = pos;
    }

    public LinkedBlock(String name, int x, int y, int z) {
        this.blockName = name;
        this.blockPos = BlockUtils.toPos(x, y, z);
    }

    public LinkedBlock(CustomizableSCTE tileEntity) {
        this.blockName = BlockUtils.getBlock(tileEntity.func_145831_w(), tileEntity.func_174877_v()).func_149739_a();
        this.blockPos = tileEntity.func_174877_v();
    }

    public boolean validate(World world) {
        return world != null && !world.func_175623_d(this.blockPos) && BlockUtils.getBlock(world, this.blockPos).func_149739_a().matches(this.blockName);
    }

    public CustomizableSCTE asTileEntity(World world) {
        if (!this.validate(world)) {
            return null;
        }
        return (CustomizableSCTE)world.func_175625_s(this.blockPos);
    }

    public String getBlockName() {
        return this.blockName;
    }

    public void setName(String blockName) {
        this.blockName = blockName;
    }

    public void setPos(BlockPos pos) {
        this.blockPos = pos;
    }

    public BlockPos getPos() {
        return this.blockPos;
    }

    public int getX() {
        return this.blockPos.func_177958_n();
    }

    public int getY() {
        return this.blockPos.func_177956_o();
    }

    public int getZ() {
        return this.blockPos.func_177952_p();
    }

    public boolean equals(Object o) {
        if (o instanceof LinkedBlock) {
            LinkedBlock block = (LinkedBlock)o;
            return block.getPos().func_177958_n() == this.blockPos.func_177958_n() && block.getPos().func_177956_o() == this.blockPos.func_177956_o() && block.getPos().func_177952_p() == this.blockPos.func_177952_p();
        }
        return false;
    }

    public int hashCode() {
        return this.blockPos.func_177958_n() + this.blockPos.func_177956_o() + this.blockPos.func_177952_p();
    }

    public String toString() {
        return this.blockName + " | " + this.blockPos.func_177958_n() + " " + this.blockPos.func_177956_o() + " " + this.blockPos.func_177952_p();
    }
}

