/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntityAlarm;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAlarm
extends BlockOwnable {
    public final boolean isLit;
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockAlarm(Material par1Material, boolean isLit) {
        super(par1Material);
        this.isLit = isLit;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        if (isLit) {
            this.func_149715_a(1.0f);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP && worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP) ? true : worldIn.isSideSolid(pos.func_177972_a(side.func_176734_d()), side);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!this.func_176196_c(worldIn, pos) && !this.func_176198_a(worldIn, pos, ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d())) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.isSideSolid(pos.func_177976_e(), EnumFacing.EAST) || worldIn.isSideSolid(pos.func_177974_f(), EnumFacing.WEST) || worldIn.isSideSolid(pos.func_177978_c(), EnumFacing.SOUTH) || worldIn.isSideSolid(pos.func_177968_d(), EnumFacing.NORTH) || worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP) || worldIn.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return worldIn.isSideSolid(pos.func_177972_a(facing.func_176734_d()), facing, true) ? this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing) : this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN);
    }

    public void func_176213_c(World par1World, BlockPos pos, IBlockState state) {
        if (par1World.field_72995_K) {
            return;
        }
        par1World.func_175684_a(pos, state.func_177230_c(), 1);
    }

    public void func_180650_b(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
        if (!par1World.field_72995_K) {
            this.playSoundAndUpdate(par1World, pos);
            par1World.func_175684_a(pos, state.func_177230_c(), 5);
        }
    }

    public void onNeighborChange(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        World world = (World)w;
        if (world.field_72995_K) {
            return;
        }
        this.playSoundAndUpdate(world, pos);
        EnumFacing enumfacing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        if (!world.isSideSolid(pos.func_177972_a(enumfacing.func_176734_d()), enumfacing, true)) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float f = 0.1875f;
        float ySideMin = 0.5f - f;
        float ySideMax = 0.5f + f;
        float hSideMin = 0.5f - f;
        float hSideMax = 0.5f + f;
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (SwitchEnumFacing.FACING_LOOKUP[enumfacing.ordinal()]) {
            case 1: {
                return new AxisAlignedBB(0.0, (double)ySideMin, (double)hSideMin, 0.5, (double)ySideMax, (double)hSideMax);
            }
            case 2: {
                return new AxisAlignedBB(0.5, (double)ySideMin, (double)hSideMin, 1.0, (double)ySideMax, (double)hSideMax);
            }
            case 3: {
                return new AxisAlignedBB((double)hSideMin, (double)ySideMin, 0.0, (double)hSideMax, (double)ySideMax, 0.5);
            }
            case 4: {
                return new AxisAlignedBB((double)hSideMin, (double)ySideMin, 0.5, (double)hSideMax, (double)ySideMax, 1.0);
            }
            case 5: {
                return new AxisAlignedBB((double)(0.5f - f), 0.0, (double)(0.5f - f), (double)(0.5f + f), 0.5, (double)(0.5f + f));
            }
            case 6: {
                return new AxisAlignedBB((double)(0.5f - f), 0.5, (double)(0.5f - f), (double)(0.5f + f), 1.0, (double)(0.5f + f));
            }
        }
        return state.func_185900_c(source, pos);
    }

    private void playSoundAndUpdate(World par1World, BlockPos pos) {
        if (!(par1World.func_175625_s(pos) instanceof TileEntityAlarm)) {
            return;
        }
        if (par1World.func_175687_A(pos) > 0) {
            boolean isPowered = ((TileEntityAlarm)par1World.func_175625_s(pos)).isPowered();
            if (!isPowered) {
                Owner owner = ((TileEntityAlarm)par1World.func_175625_s(pos)).getOwner();
                EnumFacing dir = BlockUtils.getBlockPropertyAsEnum(par1World, pos, FACING);
                BlockUtils.setBlock(par1World, pos, SCContent.alarmLit);
                BlockUtils.setBlockProperty(par1World, pos, (PropertyEnum)FACING, dir);
                ((TileEntityAlarm)par1World.func_175625_s(pos)).getOwner().set(owner);
                ((TileEntityAlarm)par1World.func_175625_s(pos)).setPowered(true);
            }
        } else {
            boolean isPowered = ((TileEntityAlarm)par1World.func_175625_s(pos)).isPowered();
            if (isPowered) {
                Owner owner = ((TileEntityAlarm)par1World.func_175625_s(pos)).getOwner();
                EnumFacing dir = BlockUtils.getBlockPropertyAsEnum(par1World, pos, FACING);
                BlockUtils.setBlock(par1World, pos, SCContent.alarm);
                BlockUtils.setBlockProperty(par1World, pos, (PropertyEnum)FACING, dir);
                ((TileEntityAlarm)par1World.func_175625_s(pos)).getOwner().set(owner);
                ((TileEntityAlarm)par1World.func_175625_s(pos)).setPowered(false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)SCContent.alarm));
    }

    public Item func_180660_a(IBlockState state, Random p_149650_2_, int p_149650_3_) {
        return Item.func_150898_a((Block)SCContent.alarm);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing;
        switch (meta & 7) {
            case 0: {
                enumfacing = EnumFacing.DOWN;
                break;
            }
            case 1: {
                enumfacing = EnumFacing.EAST;
                break;
            }
            case 2: {
                enumfacing = EnumFacing.WEST;
                break;
            }
            case 3: {
                enumfacing = EnumFacing.SOUTH;
                break;
            }
            case 4: {
                enumfacing = EnumFacing.NORTH;
                break;
            }
            default: {
                enumfacing = EnumFacing.UP;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        int i;
        switch (SwitchEnumFacing.FACING_LOOKUP[((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal()]) {
            case 1: {
                i = 1;
                break;
            }
            case 2: {
                i = 2;
                break;
            }
            case 3: {
                i = 3;
                break;
            }
            case 4: {
                i = 4;
                break;
            }
            default: {
                i = 5;
                break;
            }
            case 6: {
                i = 0;
            }
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityAlarm();
    }

    static final class SwitchEnumFacing {
        static final int[] FACING_LOOKUP = new int[EnumFacing.values().length];

        SwitchEnumFacing() {
        }

        static {
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.EAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.SOUTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.NORTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

