/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.TileEntitySCTE;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFakeLava
extends BlockDynamicLiquid
implements IIntersectable {
    int field_149815_a;

    public BlockFakeLava(Material par1Material) {
        super(par1Material);
    }

    private void placeStaticBlock(World par1World, BlockPos pos, IBlockState state) {
        par1World.func_180501_a(pos, BlockFakeLava.getStaticBlock(this.field_149764_J).func_176223_P().func_177226_a((IProperty)field_176367_b, state.func_177229_b((IProperty)field_176367_b)), 2);
    }

    public static BlockStaticLiquid getStaticBlock(Material materialIn) {
        if (materialIn == Material.field_151586_h) {
            return SCContent.bogusWater;
        }
        if (materialIn == Material.field_151587_i) {
            return SCContent.bogusLava;
        }
        throw new IllegalArgumentException("Invalid material");
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i1;
        int i = (Integer)state.func_177229_b((IProperty)field_176367_b);
        int b0 = 1;
        if (this.field_149764_J == Material.field_151587_i && !worldIn.field_73011_w.func_177500_n()) {
            b0 = 2;
        }
        int j = this.func_149738_a(worldIn);
        if (i > 0) {
            int k = -100;
            this.field_149815_a = 0;
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                k = this.func_176371_a(worldIn, pos.func_177972_a(enumfacing), k);
            }
            int l = k + b0;
            if (l >= 8 || k < 0) {
                l = -1;
            }
            if (this.func_189542_i(worldIn.func_180495_p(pos.func_177984_a())) >= 0) {
                i1 = this.func_189542_i(worldIn.func_180495_p(pos.func_177984_a()));
                l = i1 >= 8 ? i1 : i1 + 8;
            }
            if (this.field_149815_a >= 2 && this.field_149764_J == Material.field_151586_h) {
                IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177977_b());
                if (iblockstate2.func_185904_a().func_76220_a()) {
                    l = 0;
                } else if (iblockstate2.func_185904_a() == this.field_149764_J && (Integer)iblockstate2.func_177229_b((IProperty)field_176367_b) == 0) {
                    l = 0;
                }
            }
            if (this.field_149764_J == Material.field_151587_i && i < 8 && l < 8 && l > i && rand.nextInt(4) != 0) {
                j *= 4;
            }
            if (l == i) {
                this.placeStaticBlock(worldIn, pos, state);
            } else {
                i = l;
                if (l < 0) {
                    worldIn.func_175698_g(pos);
                } else {
                    state = state.func_177226_a((IProperty)field_176367_b, (Comparable)Integer.valueOf(l));
                    worldIn.func_180501_a(pos, state, 2);
                    worldIn.func_175684_a(pos, (Block)this, j);
                    worldIn.func_175685_c(pos, (Block)this);
                }
            }
        } else {
            this.placeStaticBlock(worldIn, pos, state);
        }
        IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177977_b());
        if (this.canFlowInto(worldIn, pos.func_177977_b(), iblockstate1)) {
            if (this.field_149764_J == Material.field_151587_i && worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h) {
                worldIn.func_175656_a(pos.func_177977_b(), Blocks.field_150348_b.func_176223_P());
                this.func_180688_d(worldIn, pos.func_177977_b());
                return;
            }
            if (i >= 8) {
                this.tryFlowInto(worldIn, pos.func_177977_b(), iblockstate1, i);
            } else {
                this.tryFlowInto(worldIn, pos.func_177977_b(), iblockstate1, i + 8);
            }
        } else if (i >= 0 && (i == 0 || this.isBlocked(worldIn, pos.func_177977_b(), iblockstate1))) {
            Set<?> set = this.getPossibleFlowDirections(worldIn, pos);
            i1 = i + b0;
            if (i >= 8) {
                i1 = 1;
            }
            if (i1 >= 8) {
                return;
            }
            for (EnumFacing enumfacing1 : set) {
                this.tryFlowInto(worldIn, pos.func_177972_a(enumfacing1), worldIn.func_180495_p(pos.func_177972_a(enumfacing1)), i1);
            }
        }
    }

    private void tryFlowInto(World worldIn, BlockPos pos, IBlockState state, int level) {
        if (this.canFlowInto(worldIn, pos, state)) {
            if (state.func_177230_c() != Blocks.field_150350_a) {
                if (this.field_149764_J == Material.field_151587_i) {
                    this.func_180688_d(worldIn, pos);
                } else {
                    state.func_177230_c().func_176226_b(worldIn, pos, state, 0);
                }
            }
            worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)field_176367_b, (Comparable)Integer.valueOf(level)), 3);
        }
    }

    private int func_176374_a(World worldIn, BlockPos pos, int distance, EnumFacing calculateFlowCost) {
        int j = 1000;
        for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
            int k;
            IBlockState iblockstate;
            BlockPos blockpos1;
            if (enumfacing1 == calculateFlowCost || this.isBlocked(worldIn, blockpos1 = pos.func_177972_a(enumfacing1), iblockstate = worldIn.func_180495_p(blockpos1)) || iblockstate.func_185904_a() == this.field_149764_J && (Integer)iblockstate.func_177229_b((IProperty)field_176367_b) <= 0) continue;
            if (!this.isBlocked(worldIn, blockpos1.func_177977_b(), iblockstate)) {
                return distance;
            }
            if (distance >= 4 || (k = this.func_176374_a(worldIn, blockpos1, distance + 1, enumfacing1.func_176734_d())) >= j) continue;
            j = k;
        }
        return j;
    }

    private Set<?> getPossibleFlowDirections(World worldIn, BlockPos pos) {
        int i = 1000;
        EnumSet<EnumFacing> enumset = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate;
            BlockPos blockpos1 = pos.func_177972_a(enumfacing);
            if (this.isBlocked(worldIn, blockpos1, iblockstate = worldIn.func_180495_p(blockpos1)) || iblockstate.func_185904_a() == this.field_149764_J && (Integer)iblockstate.func_177229_b((IProperty)field_176367_b) <= 0) continue;
            int j = this.isBlocked(worldIn, blockpos1.func_177977_b(), worldIn.func_180495_p(blockpos1.func_177977_b())) ? this.func_176374_a(worldIn, blockpos1, 1, enumfacing.func_176734_d()) : 0;
            if (j < i) {
                enumset.clear();
            }
            if (j > i) continue;
            enumset.add(enumfacing);
            i = j;
        }
        return enumset;
    }

    private boolean isBlocked(World worldIn, BlockPos pos, IBlockState state) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return !(block instanceof BlockDoor) && block != Blocks.field_150472_an && block != Blocks.field_150468_ap && block != Blocks.field_150436_aH ? (worldIn.func_180495_p(pos).func_185904_a() == Material.field_151567_E ? true : worldIn.func_180495_p(pos).func_185904_a().func_76230_c()) : true;
    }

    protected int func_176371_a(World worldIn, BlockPos pos, int currentMinLevel) {
        int j = this.func_189542_i(worldIn.func_180495_p(pos));
        if (j < 0) {
            return currentMinLevel;
        }
        if (j == 0) {
            ++this.field_149815_a;
        }
        if (j >= 8) {
            j = 0;
        }
        return currentMinLevel >= 0 && j >= currentMinLevel ? currentMinLevel : j;
    }

    private boolean canFlowInto(World worldIn, BlockPos pos, IBlockState state) {
        Material material = state.func_185904_a();
        return material != this.field_149764_J && material != Material.field_151587_i && !this.isBlocked(worldIn, pos, state);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_176365_e(worldIn, pos, state)) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_70691_i(4.0f);
            ((EntityPlayer)entity).func_70066_B();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World p_149694_1_, BlockPos pos, IBlockState state) {
        return null;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySCTE().intersectsEntities();
    }
}

