/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class BlockInventoryScanner
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockInventoryScanner(Material par1Material) {
        super(par1Material);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_176213_c(World par1World, BlockPos pos, IBlockState state) {
        super.func_176213_c(par1World, pos, state);
        this.setDefaultFacing(par1World, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState block = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState block1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState block2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState block3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && block.func_185913_b() && !block1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_185913_b() && !block.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_185913_b() && !block3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_185913_b() && !block2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (this.isFacingAnotherScanner(worldIn, pos)) {
            playerIn.openGui((Object)SecurityCraft.instance, 6, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else {
            PlayerUtils.sendMessageToPlayer(playerIn, ClientUtils.localize("tile.inventoryScanner.name", new Object[0]), ClientUtils.localize("messages.invScan.notConnected", new Object[0]), TextFormatting.RED);
        }
        return true;
    }

    public void func_180633_a(World par1World, BlockPos pos, IBlockState state, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        if (par1World.field_72995_K) {
            return;
        }
        IBlockState block = par1World.func_180495_p(pos.func_177978_c());
        IBlockState block1 = par1World.func_180495_p(pos.func_177968_d());
        IBlockState block2 = par1World.func_180495_p(pos.func_177976_e());
        IBlockState block3 = par1World.func_180495_p(pos.func_177974_f());
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (enumfacing == EnumFacing.NORTH && block.func_185913_b() && !block1.func_185913_b()) {
            enumfacing = EnumFacing.SOUTH;
        } else if (enumfacing == EnumFacing.SOUTH && block1.func_185913_b() && !block.func_185913_b()) {
            enumfacing = EnumFacing.NORTH;
        } else if (enumfacing == EnumFacing.WEST && block2.func_185913_b() && !block3.func_185913_b()) {
            enumfacing = EnumFacing.EAST;
        } else if (enumfacing == EnumFacing.EAST && block3.func_185913_b() && !block2.func_185913_b()) {
            enumfacing = EnumFacing.WEST;
        }
        par1World.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        this.checkAndPlaceAppropriately(par1World, pos);
    }

    private void checkAndPlaceAppropriately(World par1World, BlockPos pos) {
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(par1World, pos);
        if (connectedScanner == null) {
            return;
        }
        if (par1World.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            for (int i = 1; i < Math.abs(pos.func_177958_n() - connectedScanner.func_174877_v().func_177958_n()); ++i) {
                par1World.func_175656_a(pos.func_177985_f(i), SCContent.inventoryScannerField.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST));
            }
        } else if (par1World.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
            for (int i = 1; i < Math.abs(pos.func_177958_n() - connectedScanner.func_174877_v().func_177958_n()); ++i) {
                par1World.func_175656_a(pos.func_177965_g(i), SCContent.inventoryScannerField.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST));
            }
        } else if (par1World.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
            for (int i = 1; i < Math.abs(pos.func_177952_p() - connectedScanner.func_174877_v().func_177952_p()); ++i) {
                par1World.func_175656_a(pos.func_177964_d(i), SCContent.inventoryScannerField.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
            }
        } else if (par1World.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            for (int i = 1; i < Math.abs(pos.func_177952_p() - connectedScanner.func_174877_v().func_177952_p()); ++i) {
                par1World.func_175656_a(pos.func_177970_e(i), SCContent.inventoryScannerField.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH));
            }
        }
        CustomizableSCTE.link((CustomizableSCTE)par1World.func_175625_s(pos), connectedScanner);
    }

    public void func_180663_b(World par1World, BlockPos pos, IBlockState state) {
        int j;
        int i;
        if (par1World.field_72995_K) {
            return;
        }
        TileEntityInventoryScanner connectedScanner = null;
        for (i = 1; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
            if (BlockUtils.getBlock(par1World, pos.func_177985_f(i)) != SCContent.inventoryScanner) continue;
            for (j = 1; j < i; ++j) {
                if (BlockUtils.getBlock(par1World, pos.func_177985_f(j)) != SCContent.inventoryScannerField) continue;
                par1World.func_175655_b(pos.func_177985_f(j), false);
            }
            connectedScanner = (TileEntityInventoryScanner)par1World.func_175625_s(pos.func_177985_f(i));
            break;
        }
        for (i = 1; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
            if (BlockUtils.getBlock(par1World, pos.func_177965_g(i)) != SCContent.inventoryScanner) continue;
            for (j = 1; j < i; ++j) {
                if (BlockUtils.getBlock(par1World, pos.func_177965_g(j)) != SCContent.inventoryScannerField) continue;
                par1World.func_175655_b(pos.func_177965_g(j), false);
            }
            connectedScanner = (TileEntityInventoryScanner)par1World.func_175625_s(pos.func_177965_g(i));
            break;
        }
        for (i = 1; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
            if (BlockUtils.getBlock(par1World, pos.func_177964_d(i)) != SCContent.inventoryScanner) continue;
            for (j = 1; j < i; ++j) {
                if (BlockUtils.getBlock(par1World, pos.func_177964_d(j)) != SCContent.inventoryScannerField) continue;
                par1World.func_175655_b(pos.func_177964_d(j), false);
            }
            connectedScanner = (TileEntityInventoryScanner)par1World.func_175625_s(pos.func_177964_d(i));
            break;
        }
        for (i = 1; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
            if (BlockUtils.getBlock(par1World, pos.func_177970_e(i)) != SCContent.inventoryScanner) continue;
            for (j = 1; j < i; ++j) {
                if (BlockUtils.getBlock(par1World, pos.func_177970_e(j)) != SCContent.inventoryScannerField) continue;
                par1World.func_175655_b(pos.func_177970_e(j), false);
            }
            connectedScanner = (TileEntityInventoryScanner)par1World.func_175625_s(pos.func_177970_e(i));
            break;
        }
        for (i = 0; i < ((TileEntityInventoryScanner)par1World.func_175625_s(pos)).getContents().length; ++i) {
            if (((TileEntityInventoryScanner)par1World.func_175625_s(pos)).getContents()[i] == null) continue;
            par1World.func_72838_d((Entity)new EntityItem(par1World, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ((TileEntityInventoryScanner)par1World.func_175625_s(pos)).getContents()[i]));
        }
        if (connectedScanner != null) {
            for (i = 0; i < connectedScanner.getContents().length; ++i) {
                connectedScanner.getContents()[i] = null;
            }
        }
        super.func_180663_b(par1World, pos, state);
    }

    private boolean isFacingAnotherScanner(World world, BlockPos pos) {
        return BlockInventoryScanner.getConnectedInventoryScanner(world, pos) != null;
    }

    public static TileEntityInventoryScanner getConnectedInventoryScanner(World world, BlockPos pos) {
        switch ((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING)) {
            case WEST: {
                for (int i = 0; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
                    Block b = BlockUtils.getBlock(world, pos.func_177985_f(i));
                    if (b != Blocks.field_150350_a && b != SCContent.inventoryScannerField && b != SCContent.inventoryScanner) {
                        return null;
                    }
                    if (b != SCContent.inventoryScanner || world.func_180495_p(pos.func_177985_f(i)).func_177229_b((IProperty)FACING) != EnumFacing.EAST) continue;
                    return (TileEntityInventoryScanner)world.func_175625_s(pos.func_177985_f(i));
                }
                return null;
            }
            case EAST: {
                for (int i = 0; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
                    Block b = BlockUtils.getBlock(world, pos.func_177965_g(i));
                    if (b != Blocks.field_150350_a && b != SCContent.inventoryScannerField && b != SCContent.inventoryScanner) {
                        return null;
                    }
                    if (b != SCContent.inventoryScanner || world.func_180495_p(pos.func_177965_g(i)).func_177229_b((IProperty)FACING) != EnumFacing.WEST) continue;
                    return (TileEntityInventoryScanner)world.func_175625_s(pos.func_177965_g(i));
                }
                return null;
            }
            case NORTH: {
                for (int i = 0; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
                    Block b = BlockUtils.getBlock(world, pos.func_177964_d(i));
                    if (b != Blocks.field_150350_a && b != SCContent.inventoryScannerField && b != SCContent.inventoryScanner) {
                        return null;
                    }
                    if (b != SCContent.inventoryScanner || world.func_180495_p(pos.func_177964_d(i)).func_177229_b((IProperty)FACING) != EnumFacing.SOUTH) continue;
                    return (TileEntityInventoryScanner)world.func_175625_s(pos.func_177964_d(i));
                }
                return null;
            }
            case SOUTH: {
                for (int i = 0; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
                    Block b = BlockUtils.getBlock(world, pos.func_177970_e(i));
                    if (b != Blocks.field_150350_a && b != SCContent.inventoryScannerField && b != SCContent.inventoryScanner) {
                        return null;
                    }
                    if (b != SCContent.inventoryScanner || world.func_180495_p(pos.func_177970_e(i)).func_177229_b((IProperty)FACING) != EnumFacing.NORTH) continue;
                    return (TileEntityInventoryScanner)world.func_175625_s(pos.func_177970_e(i));
                }
                return null;
            }
        }
        return null;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!(blockAccess.func_175625_s(pos) instanceof TileEntityInventoryScanner) || ((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).getType() == null) {
            SecurityCraft.log("type is null on the " + FMLCommonHandler.instance().getEffectiveSide() + " side");
            return 0;
        }
        return ((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).getType().matches("redstone") && ((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).shouldProvidePower() ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).getType() == null) {
            return 0;
        }
        return ((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).getType().matches("redstone") && ((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).shouldProvidePower() ? 15 : 0;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(EnumFacing.values()[meta].func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityInventoryScanner();
    }
}

