/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.TileEntitySCTE;
import net.geforcemods.securitycraft.blocks.BlockInventoryScanner;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInventoryScannerField
extends BlockContainer
implements IIntersectable {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockInventoryScannerField(Material par2Material) {
        super(par2Material);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        block5: {
            TileEntityInventoryScanner connectedScanner;
            block4: {
                connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(world, pos);
                if (!(entity instanceof EntityPlayer)) break block4;
                if (ModuleUtils.checkForModule(world, connectedScanner.func_174877_v(), (EntityPlayer)entity, EnumCustomModules.WHITELIST)) {
                    return;
                }
                for (int i = 0; i < 10; ++i) {
                    for (int j = 0; j < ((EntityPlayer)entity).field_71071_by.field_70462_a.length; ++j) {
                        if (connectedScanner.getStackInSlotCopy(i) == null || ((EntityPlayer)entity).field_71071_by.field_70462_a[j] == null) continue;
                        BlockInventoryScannerField.checkInventory((EntityPlayer)entity, connectedScanner, connectedScanner.getStackInSlotCopy(i));
                    }
                }
                break block5;
            }
            if (!(entity instanceof EntityItem)) break block5;
            for (int i = 0; i < 10; ++i) {
                if (connectedScanner.getStackInSlotCopy(i) == null || ((EntityItem)entity).func_92059_d() == null) continue;
                BlockInventoryScannerField.checkEntity((EntityItem)entity, connectedScanner.getStackInSlotCopy(i));
            }
        }
    }

    public static void checkInventory(EntityPlayer par1EntityPlayer, TileEntityInventoryScanner par2TileEntity, ItemStack par3) {
        block5: {
            block4: {
                if (!par2TileEntity.getType().matches("redstone")) break block4;
                for (int i = 1; i <= par1EntityPlayer.field_71071_by.field_70462_a.length; ++i) {
                    if (par1EntityPlayer.field_71071_by.field_70462_a[i - 1] == null || par1EntityPlayer.field_71071_by.field_70462_a[i - 1].func_77973_b() != par3.func_77973_b()) continue;
                    if (!par2TileEntity.shouldProvidePower()) {
                        par2TileEntity.setShouldProvidePower(true);
                    }
                    SecurityCraft.log("Running te update");
                    par2TileEntity.setCooldown(60);
                    BlockInventoryScannerField.checkAndUpdateTEAppropriately(par2TileEntity);
                    BlockUtils.updateAndNotify(par2TileEntity.func_145831_w(), par2TileEntity.func_174877_v(), par2TileEntity.func_145831_w().func_180495_p(par2TileEntity.func_174877_v()).func_177230_c(), 1, true);
                    SecurityCraft.log("Emitting redstone on the " + FMLCommonHandler.instance().getEffectiveSide() + " side. (te coords: " + Utils.getFormattedCoordinates(par2TileEntity.func_174877_v()));
                }
                break block5;
            }
            if (!par2TileEntity.getType().matches("check")) break block5;
            for (int i = 1; i <= par1EntityPlayer.field_71071_by.field_70462_a.length; ++i) {
                if (par1EntityPlayer.field_71071_by.field_70462_a[i - 1] == null) continue;
                if (par2TileEntity.hasModule(EnumCustomModules.SMART) && ItemStack.func_77989_b((ItemStack)par1EntityPlayer.field_71071_by.field_70462_a[i - 1], (ItemStack)par3) && ItemStack.func_77970_a((ItemStack)par1EntityPlayer.field_71071_by.field_70462_a[i - 1], (ItemStack)par3)) {
                    par1EntityPlayer.field_71071_by.field_70462_a[i - 1] = null;
                    continue;
                }
                if (par2TileEntity.hasModule(EnumCustomModules.SMART) || par1EntityPlayer.field_71071_by.field_70462_a[i - 1].func_77973_b() != par3.func_77973_b()) continue;
                par1EntityPlayer.field_71071_by.field_70462_a[i - 1] = null;
            }
        }
    }

    public static void checkEntity(EntityItem par1EntityItem, ItemStack par2) {
        if (par1EntityItem.func_92059_d().func_77973_b() == par2.func_77973_b()) {
            par1EntityItem.func_70106_y();
        }
    }

    private static void checkAndUpdateTEAppropriately(TileEntityInventoryScanner te) {
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(te.func_145831_w(), te.func_174877_v());
        te.setShouldProvidePower(true);
        te.setCooldown(60);
        BlockUtils.updateAndNotify(te.func_145831_w(), te.func_174877_v(), te.func_145838_q(), 1, true);
        connectedScanner.setShouldProvidePower(true);
        connectedScanner.setCooldown(60);
        BlockUtils.updateAndNotify(connectedScanner.func_145831_w(), connectedScanner.func_174877_v(), connectedScanner.func_145838_q(), 1, true);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            int j;
            int i;
            for (i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                if (BlockUtils.getBlock(worldIn, pos.func_177985_f(i)) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    worldIn.func_175655_b(pos.func_177985_f(j), false);
                }
                break;
            }
            for (i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                if (BlockUtils.getBlock(worldIn, pos.func_177965_g(i)) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    worldIn.func_175655_b(pos.func_177965_g(j), false);
                }
                break;
            }
            for (i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                if (BlockUtils.getBlock(worldIn, pos.func_177964_d(i)) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    worldIn.func_175655_b(pos.func_177964_d(j), false);
                }
                break;
            }
            for (i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                if (BlockUtils.getBlock(worldIn, pos.func_177970_e(i)) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    worldIn.func_175655_b(pos.func_177970_e(j), false);
                }
                break;
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (source.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.EAST || source.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            return new AxisAlignedBB(0.0, 0.0, (double)0.4f, 1.0, 1.0, (double)0.6f);
        }
        if (source.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.NORTH || source.func_180495_p(pos).func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            return new AxisAlignedBB((double)0.4f, 0.0, 0.0, (double)0.6f, 1.0, 1.0);
        }
        return state.func_185900_c(source, pos);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySCTE().intersectsEntities();
    }
}

