/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.items.ItemKeycardBase;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.ItemUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockKeycardReader
extends BlockOwnable {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockKeycardReader(Material par2Material) {
        super(par2Material);
        this.func_149672_a(SoundType.field_185852_e);
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180633_a(World par1World, BlockPos pos, IBlockState state, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        super.func_180633_a(par1World, pos, state, par5EntityLivingBase, par6ItemStack);
        IBlockState block = par1World.func_180495_p(pos.func_177978_c());
        IBlockState block1 = par1World.func_180495_p(pos.func_177968_d());
        IBlockState block2 = par1World.func_180495_p(pos.func_177976_e());
        IBlockState block3 = par1World.func_180495_p(pos.func_177974_f());
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (enumfacing == EnumFacing.NORTH && block.func_185913_b() && !block1.func_185913_b()) {
            enumfacing = EnumFacing.SOUTH;
        } else if (enumfacing == EnumFacing.SOUTH && block1.func_185913_b() && !block.func_185913_b()) {
            enumfacing = EnumFacing.NORTH;
        } else if (enumfacing == EnumFacing.WEST && block2.func_185913_b() && !block3.func_185913_b()) {
            enumfacing = EnumFacing.EAST;
        } else if (enumfacing == EnumFacing.EAST && block3.func_185913_b() && !block2.func_185913_b()) {
            enumfacing = EnumFacing.WEST;
        }
        par1World.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
    }

    public void insertCard(World par1World, BlockPos pos, ItemStack par5ItemStack, EntityPlayer par6EntityPlayer) {
        if (ModuleUtils.checkForModule(par1World, pos, par6EntityPlayer, EnumCustomModules.WHITELIST) || ModuleUtils.checkForModule(par1World, pos, par6EntityPlayer, EnumCustomModules.BLACKLIST)) {
            return;
        }
        int securityLevel = 0;
        if (((TileEntityKeycardReader)par1World.func_175625_s(pos)).getPassword() != null) {
            securityLevel = Integer.parseInt(((TileEntityKeycardReader)par1World.func_175625_s(pos)).getPassword());
        }
        if (!((TileEntityKeycardReader)par1World.func_175625_s(pos)).doesRequireExactKeycard() && securityLevel <= ((ItemKeycardBase)par5ItemStack.func_77973_b()).getKeycardLV(par5ItemStack) || ((TileEntityKeycardReader)par1World.func_175625_s(pos)).doesRequireExactKeycard() && securityLevel == ((ItemKeycardBase)par5ItemStack.func_77973_b()).getKeycardLV(par5ItemStack)) {
            if (((ItemKeycardBase)par5ItemStack.func_77973_b()).getKeycardLV(par5ItemStack) == 6 && par5ItemStack.func_77978_p() != null && !par6EntityPlayer.field_71075_bZ.field_75098_d) {
                par5ItemStack.func_77978_p().func_74768_a("Uses", par5ItemStack.func_77978_p().func_74762_e("Uses") - 1);
                if (par5ItemStack.func_77978_p().func_74762_e("Uses") <= 0) {
                    --par5ItemStack.field_77994_a;
                }
            }
            BlockKeycardReader.activate(par1World, pos);
        } else if (Integer.parseInt(((TileEntityKeycardReader)par1World.func_175625_s(pos)).getPassword()) != 0) {
            PlayerUtils.sendMessageToPlayer(par6EntityPlayer, ClientUtils.localize("tile.keycardReader.name", new Object[0]), ClientUtils.localize("messages.keycardReader.required", new Object[0]).replace("#r", ((IPasswordProtected)par1World.func_175625_s(pos)).getPassword()).replace("#c", "" + ((ItemKeycardBase)par5ItemStack.func_77973_b()).getKeycardLV(par5ItemStack)), TextFormatting.RED);
        } else {
            PlayerUtils.sendMessageToPlayer(par6EntityPlayer, ClientUtils.localize("tile.keycardReader.name", new Object[0]), ClientUtils.localize("messages.keycardReader.notSet", new Object[0]), TextFormatting.RED);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (playerIn.field_71071_by.func_70448_g() == null || !(playerIn.field_71071_by.func_70448_g().func_77973_b() instanceof ItemKeycardBase) && playerIn.field_71071_by.func_70448_g().func_77973_b() != SCContent.adminTool) {
            ((TileEntityKeycardReader)worldIn.func_175625_s(pos)).openPasswordGUI(playerIn);
        } else if (playerIn.field_71071_by.func_70448_g().func_77973_b() == SCContent.adminTool) {
            ((BlockKeycardReader)BlockUtils.getBlock(worldIn, pos)).insertCard(worldIn, pos, ItemUtils.toItemStack(SCContent.limitedUseKeycard), playerIn);
        } else {
            ((BlockKeycardReader)BlockUtils.getBlock(worldIn, pos)).insertCard(worldIn, pos, playerIn.field_71071_by.func_70448_g(), playerIn);
        }
        return false;
    }

    public static void activate(World par1World, BlockPos pos) {
        BlockUtils.setBlockProperty(par1World, pos, POWERED, true);
        par1World.func_175685_c(pos, SCContent.keycardReader);
        par1World.func_175684_a(pos, SCContent.keycardReader, 60);
    }

    public void func_180650_b(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
        if (!par1World.field_72995_K) {
            BlockUtils.setBlockProperty(par1World, pos, POWERED, false);
            par1World.func_175685_c(pos, SCContent.keycardReader);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)POWERED)).booleanValue()) {
            double d0 = (double)((float)pos.func_177958_n() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)pos.func_177956_o() + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)pos.func_177952_p() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double d3 = 0.22f;
            double d4 = 0.27f;
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0 - d4, d1 + d3, d2, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0 + d4, d1 + d3, d2, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0, d1 + d3, d2 - d4, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0, d1 + d3, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        if (meta <= 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(EnumFacing.values()[meta].func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.values()[meta])).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta - 6]).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true));
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + 6;
        }
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    @Override
    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityKeycardReader();
    }
}

