/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.blocks.IPasswordConvertible;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadFurnace;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockKeypadFurnace
extends BlockOwnable
implements IPasswordConvertible {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");

    public BlockKeypadFurnace(Material materialIn) {
        super(materialIn);
        this.func_149672_a(SoundType.field_185852_e);
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && !PlayerUtils.isHoldingItem(playerIn, SCContent.codebreaker)) {
            ((TileEntityKeypadFurnace)worldIn.func_175625_s(pos)).openPasswordGUI(playerIn);
        }
        return true;
    }

    public static void activate(World par1World, BlockPos pos, EntityPlayer player) {
        if (!BlockUtils.getBlockPropertyAsBoolean(par1World, pos, OPEN)) {
            BlockUtils.setBlockProperty(par1World, pos, OPEN, true, false);
        }
        par1World.func_180498_a((EntityPlayer)null, 1006, pos, 0);
        player.openGui((Object)SecurityCraft.instance, 8, par1World, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        if (meta <= 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(EnumFacing.values()[meta].func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.values()[meta])).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta - 6]).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true));
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + 6;
        }
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, OPEN});
    }

    @Override
    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityKeypadFurnace();
    }

    @Override
    public Block getOriginalBlock() {
        return Blocks.field_150460_al;
    }

    @Override
    public boolean convert(EntityPlayer player, World world, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        TileEntityFurnace furnace = (TileEntityFurnace)world.func_175625_s(pos);
        NBTTagCompound tag = furnace.func_189515_b(new NBTTagCompound());
        furnace.func_174888_l();
        world.func_175656_a(pos, SCContent.keypadFurnace.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)));
        ((IOwnable)world.func_175625_s(pos)).getOwner().set(player.func_70005_c_(), player.func_110124_au().toString());
        ((TileEntityKeypadFurnace)world.func_175625_s(pos)).func_145839_a(tag);
        return true;
    }
}

