/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import java.util.Iterator;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.entity.EntitySecurityCamera;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSecurityCamera
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockSecurityCamera(Material par2Material) {
        super(par2Material);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175685_c(pos.func_177978_c(), world.func_180495_p(pos).func_177230_c());
        world.func_175685_c(pos.func_177968_d(), world.func_180495_p(pos).func_177230_c());
        world.func_175685_c(pos.func_177974_f(), world.func_180495_p(pos).func_177230_c());
        world.func_175685_c(pos.func_177976_e(), world.func_180495_p(pos).func_177230_c());
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing dir = BlockUtils.getBlockPropertyAsEnum(source, pos, FACING);
        if (dir == EnumFacing.SOUTH) {
            return new AxisAlignedBB((double)0.275f, 0.25, 0.0, (double)0.7f, (double)0.8f, (double)0.85f);
        }
        if (dir == EnumFacing.NORTH) {
            return new AxisAlignedBB((double)0.275f, 0.25, (double)0.15f, (double)0.7f, (double)0.8f, 1.0);
        }
        if (dir == EnumFacing.WEST) {
            return new AxisAlignedBB(0.125, 0.25, (double)0.275f, 1.0, (double)0.8f, (double)0.725f);
        }
        return new AxisAlignedBB(0.0, 0.25, (double)0.275f, (double)0.85f, (double)0.8f, (double)0.725f);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing1;
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        if (worldIn.isSideSolid(pos.func_177972_a(facing.func_176734_d()), facing)) {
            return iblockstate.func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        }
        Iterator iterator = EnumFacing.Plane.HORIZONTAL.iterator();
        do {
            if (iterator.hasNext()) continue;
            return iblockstate;
        } while (!worldIn.isSideSolid(pos.func_177972_a((enumfacing1 = (EnumFacing)iterator.next()).func_176734_d()), enumfacing1));
        return iblockstate.func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public void mountCamera(World world, int par2, int par3, int par4, int par5, EntityPlayer player) {
        if (!world.field_72995_K && player.func_184187_bx() == null) {
            PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("tile.securityCamera.name", new Object[0]), ClientUtils.localize("messages.securityCamera.mounted", new Object[0]), TextFormatting.GREEN);
        }
        if (player.func_184187_bx() != null && player.func_184187_bx() instanceof EntitySecurityCamera) {
            EntitySecurityCamera dummyEntity = new EntitySecurityCamera(world, (double)par2, (double)par3, (double)par4, par5, (EntitySecurityCamera)player.func_184187_bx());
            WorldUtils.addScheduledTask(world, () -> world.func_72838_d((Entity)dummyEntity));
            player.func_184220_m((Entity)dummyEntity);
            return;
        }
        EntitySecurityCamera dummyEntity = new EntitySecurityCamera(world, (double)par2, (double)par3, (double)par4, par5, player);
        WorldUtils.addScheduledTask(world, () -> world.func_72838_d((Entity)dummyEntity));
        player.func_184220_m((Entity)dummyEntity);
        for (Object e : world.field_72996_f) {
            if (!(e instanceof EntityLiving) || ((EntityLiving)e).func_70638_az() != player) continue;
            ((EntityLiving)e).func_70624_b(null);
        }
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            return false;
        }
        return worldIn.isSideSolid(pos.func_177972_a(side.func_176734_d()), side);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue() && ((CustomizableSCTE)blockAccess.func_175625_s(pos)).hasModule(EnumCustomModules.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue() && ((CustomizableSCTE)blockAccess.func_175625_s(pos)).hasModule(EnumCustomModules.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!this.func_176196_c(worldIn, pos) && !this.func_176198_a(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        if (meta <= 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(EnumFacing.values()[meta] == EnumFacing.UP || EnumFacing.values()[meta] == EnumFacing.DOWN ? EnumFacing.NORTH : EnumFacing.values()[meta])).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta - 6]).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true));
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + 6;
        }
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntitySecurityCamera().nameable();
    }
}

