/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.Random;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.blocks.mines.BlockExplosive;
import net.geforcemods.securitycraft.imc.waila.ICustomWailaDisplay;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockFullMineBase
extends BlockExplosive
implements IIntersectable,
ICustomWailaDisplay {
    private final Block blockDisguisedAs;

    public BlockFullMineBase(Material par1Material, Block disguisedBlock) {
        super(par1Material);
        this.blockDisguisedAs = disguisedBlock;
        if (par1Material == Material.field_151595_p) {
            this.func_149672_a(SoundType.field_185855_h);
        } else if (par1Material == Material.field_151578_c) {
            this.func_149672_a(SoundType.field_185849_b);
        } else {
            this.func_149672_a(SoundType.field_185851_d);
        }
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return null;
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityItem) {
            return;
        }
        if (entity instanceof EntityLivingBase && !PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)entity)) {
            this.explode(world, pos);
        }
    }

    public void func_180652_a(World par1World, BlockPos pos, Explosion par5Explosion) {
        Random random;
        if (!par1World.field_72995_K && (random = new Random()).nextInt(3) == 1) {
            this.explode(par1World, pos);
        }
    }

    public void func_176206_d(World par1World, BlockPos pos, IBlockState state) {
        if (!par1World.field_72995_K) {
            this.explode(par1World, pos);
        }
    }

    @Override
    public void activateMine(World world, BlockPos pos) {
    }

    @Override
    public void defuseMine(World world, BlockPos pos) {
    }

    @Override
    public void explode(World par1World, BlockPos pos) {
        par1World.func_175655_b(pos, false);
        if (SecurityCraft.config.smallerMineExplosion) {
            par1World.func_72876_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), 2.5f, true);
        } else {
            par1World.func_72876_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), 5.0f, true);
        }
    }

    public boolean func_149659_a(Explosion par1Explosion) {
        return false;
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean explodesWhenInteractedWith() {
        return false;
    }

    @Override
    public boolean isDefusable() {
        return false;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityOwnable().intersectsEntities();
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return new ItemStack(this.blockDisguisedAs);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return false;
    }
}

