/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.BlockInventoryScanner;
import net.geforcemods.securitycraft.blocks.BlockKeycardReader;
import net.geforcemods.securitycraft.blocks.BlockKeypad;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.blocks.BlockRetinalScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockReinforcedDoor
extends BlockDoor
implements ITileEntityProvider {
    public BlockReinforcedDoor(Material materialIn) {
        super(materialIn);
        this.field_149758_A = true;
        this.func_149672_a(SoundType.field_185852_e);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            boolean isNotPowered;
            boolean bl = isNotPowered = this.hasNoActiveSCBlocksNear(worldIn, pos) && this.hasNoActiveSCBlocksNear(worldIn, pos.func_177977_b());
            if (isNotPowered) {
                this.closeDoor(worldIn, pos.func_177977_b());
                return;
            }
            BlockPos neighborPos = this.getNeighboringActiveSCBlock(worldIn, pos.func_177977_b(), neighborBlock);
            if (neighborPos != null) {
                this.onNeighborChange((IBlockAccess)worldIn, pos.func_177977_b(), neighborPos);
            } else {
                neighborPos = this.getNeighboringActiveSCBlock(worldIn, pos, neighborBlock);
                if (neighborPos != null) {
                    this.onNeighborChange((IBlockAccess)worldIn, pos, neighborPos);
                }
            }
        } else {
            boolean isNotPowered;
            boolean bl = isNotPowered = this.hasNoActiveSCBlocksNear(worldIn, pos) && this.hasNoActiveSCBlocksNear(worldIn, pos.func_177984_a());
            if (isNotPowered) {
                this.closeDoor(worldIn, pos);
                return;
            }
            BlockPos neighborPos = this.getNeighboringActiveSCBlock(worldIn, pos, neighborBlock);
            if (neighborPos != null) {
                this.onNeighborChange((IBlockAccess)worldIn, pos, neighborPos);
            } else {
                neighborPos = this.getNeighboringActiveSCBlock(worldIn, pos.func_177984_a(), neighborBlock);
                if (neighborPos != null) {
                    this.onNeighborChange((IBlockAccess)worldIn, pos.func_177984_a(), neighborPos);
                }
            }
        }
    }

    private void closeDoor(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!((Boolean)state.func_177229_b((IProperty)field_176519_b)).booleanValue()) {
            return;
        }
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            pos = pos.func_177977_b();
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176522_N, (Comparable)Boolean.valueOf(false)), 2);
        world.func_175704_b(pos, pos);
        world.func_180498_a((EntityPlayer)null, 1011, pos, 0);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        World worldIn = (World)world;
        IBlockState state = worldIn.func_180495_p(pos);
        Block neighborBlock = worldIn.func_180495_p(neighbor).func_177230_c();
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos blockpos1 = pos.func_177977_b();
            IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
            if (iblockstate1.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (neighborBlock != this) {
                this.onNeighborChange(world, blockpos1, neighbor);
            }
        } else {
            boolean flag1 = false;
            BlockPos blockpos2 = pos.func_177984_a();
            IBlockState iblockstate2 = worldIn.func_180495_p(blockpos2);
            if (iblockstate2.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                flag1 = true;
            }
            if (!worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
                worldIn.func_175698_g(pos);
                flag1 = true;
                if (iblockstate2.func_177230_c() == this) {
                    worldIn.func_175698_g(blockpos2);
                }
            }
            if (flag1) {
                if (!worldIn.field_72995_K) {
                    this.func_176226_b(worldIn, pos, state, 0);
                }
            } else {
                boolean flag;
                boolean bl = flag = this.hasActiveKeypadNextTo(worldIn, pos) || this.hasActiveKeypadNextTo(worldIn, pos.func_177984_a()) || this.hasActiveInventoryScannerNextTo(worldIn, pos) || this.hasActiveInventoryScannerNextTo(worldIn, pos.func_177984_a()) || this.hasActiveReaderNextTo(worldIn, pos) || this.hasActiveReaderNextTo(worldIn, pos.func_177984_a()) || this.hasActiveScannerNextTo(worldIn, pos) || this.hasActiveScannerNextTo(worldIn, pos.func_177984_a()) || this.hasActiveLaserNextTo(worldIn, pos) || this.hasActiveLaserNextTo(worldIn, pos.func_177984_a());
                if ((flag || neighborBlock.func_149744_f(iblockstate2)) && neighborBlock != this && flag != (Boolean)iblockstate2.func_177229_b((IProperty)field_176522_N) && flag != (Boolean)state.func_177229_b((IProperty)field_176519_b)) {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176519_b, (Comparable)Boolean.valueOf(flag)).func_177226_a((IProperty)field_176522_N, (Comparable)Boolean.valueOf(flag)), 2);
                    worldIn.func_175704_b(pos, pos);
                    worldIn.func_180498_a((EntityPlayer)null, flag ? 1005 : 1011, pos, 0);
                }
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    private boolean hasActiveLaserNextTo(World par1World, BlockPos pos) {
        if (BlockUtils.getBlock(par1World, pos.func_177974_f()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177974_f(), BlockLaserBlock.POWERED)).booleanValue()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177974_f())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(par1World, pos.func_177976_e()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177976_e(), BlockLaserBlock.POWERED)).booleanValue()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177976_e())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(par1World, pos.func_177968_d()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177968_d(), BlockLaserBlock.POWERED)).booleanValue()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177968_d())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(par1World, pos.func_177978_c()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177978_c(), BlockLaserBlock.POWERED)).booleanValue()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177978_c())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        return false;
    }

    private boolean hasActiveScannerNextTo(World par1World, BlockPos pos) {
        if (BlockUtils.getBlock(par1World, pos.func_177974_f()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177974_f(), BlockRetinalScanner.POWERED)).booleanValue()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177974_f())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(par1World, pos.func_177976_e()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177976_e(), BlockRetinalScanner.POWERED)).booleanValue()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177976_e())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(par1World, pos.func_177968_d()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177968_d(), BlockRetinalScanner.POWERED)).booleanValue()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177968_d())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(par1World, pos.func_177978_c()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177978_c(), BlockRetinalScanner.POWERED)).booleanValue()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177978_c())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        return false;
    }

    private boolean hasActiveKeypadNextTo(World par1World, BlockPos pos) {
        if (BlockUtils.getBlock(par1World, pos.func_177974_f()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177974_f(), BlockKeypad.POWERED)).booleanValue()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177974_f())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(par1World, pos.func_177976_e()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177976_e(), BlockKeypad.POWERED)).booleanValue()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177976_e())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(par1World, pos.func_177968_d()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177968_d(), BlockKeypad.POWERED)).booleanValue()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177968_d())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(par1World, pos.func_177978_c()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177978_c(), BlockKeypad.POWERED)).booleanValue()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177978_c())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        return false;
    }

    private boolean hasActiveReaderNextTo(World par1World, BlockPos pos) {
        if (BlockUtils.getBlock(par1World, pos.func_177974_f()) == SCContent.keycardReader && BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177974_f(), BlockKeycardReader.POWERED)) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177974_f())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(par1World, pos.func_177976_e()) == SCContent.keycardReader && BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177976_e(), BlockKeycardReader.POWERED)) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177976_e())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(par1World, pos.func_177968_d()) == SCContent.keycardReader && BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177968_d(), BlockKeycardReader.POWERED)) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177968_d())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(par1World, pos.func_177978_c()) == SCContent.keycardReader && BlockUtils.getBlockPropertyAsBoolean(par1World, pos.func_177978_c(), BlockKeycardReader.POWERED)) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177978_c())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        return false;
    }

    private boolean hasActiveInventoryScannerNextTo(World par1World, BlockPos pos) {
        if (BlockUtils.getBlock(par1World, pos.func_177974_f()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)par1World.func_175625_s(pos.func_177974_f())).getType().matches("redstone") && ((TileEntityInventoryScanner)par1World.func_175625_s(pos.func_177974_f())).shouldProvidePower()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177974_f())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(par1World, pos.func_177976_e()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)par1World.func_175625_s(pos.func_177976_e())).getType().matches("redstone") && ((TileEntityInventoryScanner)par1World.func_175625_s(pos.func_177976_e())).shouldProvidePower()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177976_e())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(par1World, pos.func_177968_d()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)par1World.func_175625_s(pos.func_177968_d())).getType().matches("redstone") && ((TileEntityInventoryScanner)par1World.func_175625_s(pos.func_177968_d())).shouldProvidePower()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177968_d())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        if (BlockUtils.getBlock(par1World, pos.func_177978_c()) == SCContent.inventoryScanner && ((TileEntityInventoryScanner)par1World.func_175625_s(pos.func_177978_c())).getType().matches("redstone") && ((TileEntityInventoryScanner)par1World.func_175625_s(pos.func_177978_c())).shouldProvidePower()) {
            return ((IOwnable)par1World.func_175625_s(pos.func_177978_c())).getOwner().owns((IOwnable)par1World.func_175625_s(pos));
        }
        return false;
    }

    private BlockPos getNeighboringActiveSCBlock(World world, BlockPos pos, Block neighbor) {
        if (neighbor instanceof BlockLaserBlock && this.hasActiveLaserNextTo(world, pos)) {
            if (BlockUtils.getBlock(world, pos.func_177974_f()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177974_f(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177974_f();
            }
            if (BlockUtils.getBlock(world, pos.func_177976_e()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177976_e(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177976_e();
            }
            if (BlockUtils.getBlock(world, pos.func_177968_d()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177968_d(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177968_d();
            }
            if (BlockUtils.getBlock(world, pos.func_177978_c()) == SCContent.laserBlock && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177978_c(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177978_c();
            }
        } else if (neighbor instanceof BlockRetinalScanner && this.hasActiveScannerNextTo(world, pos)) {
            if (BlockUtils.getBlock(world, pos.func_177974_f()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177974_f(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177974_f();
            }
            if (BlockUtils.getBlock(world, pos.func_177976_e()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177976_e(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177976_e();
            }
            if (BlockUtils.getBlock(world, pos.func_177968_d()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177968_d(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177968_d();
            }
            if (BlockUtils.getBlock(world, pos.func_177978_c()) == SCContent.retinalScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177978_c(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177978_c();
            }
        } else if (neighbor instanceof BlockKeypad && this.hasActiveKeypadNextTo(world, pos)) {
            if (BlockUtils.getBlock(world, pos.func_177974_f()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177974_f(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177974_f();
            }
            if (BlockUtils.getBlock(world, pos.func_177976_e()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177976_e(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177976_e();
            }
            if (BlockUtils.getBlock(world, pos.func_177968_d()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177968_d(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177968_d();
            }
            if (BlockUtils.getBlock(world, pos.func_177978_c()) == SCContent.keypad && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177978_c(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177978_c();
            }
        } else if (neighbor instanceof BlockKeycardReader && this.hasActiveReaderNextTo(world, pos)) {
            if (BlockUtils.getBlock(world, pos.func_177974_f()) == SCContent.keycardReader && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177974_f(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177974_f();
            }
            if (BlockUtils.getBlock(world, pos.func_177976_e()) == SCContent.keycardReader && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177976_e(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177976_e();
            }
            if (BlockUtils.getBlock(world, pos.func_177968_d()) == SCContent.keycardReader && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177968_d(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177968_d();
            }
            if (BlockUtils.getBlock(world, pos.func_177978_c()) == SCContent.keycardReader && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177978_c(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177978_c();
            }
        } else if (neighbor instanceof BlockInventoryScanner && this.hasActiveInventoryScannerNextTo(world, pos)) {
            if (BlockUtils.getBlock(world, pos.func_177974_f()) == SCContent.inventoryScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177974_f(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177974_f();
            }
            if (BlockUtils.getBlock(world, pos.func_177976_e()) == SCContent.inventoryScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177976_e(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177976_e();
            }
            if (BlockUtils.getBlock(world, pos.func_177968_d()) == SCContent.inventoryScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177968_d(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177968_d();
            }
            if (BlockUtils.getBlock(world, pos.func_177978_c()) == SCContent.inventoryScanner && Boolean.valueOf(BlockUtils.getBlockPropertyAsBoolean(world, pos.func_177978_c(), BlockLaserBlock.POWERED)).booleanValue()) {
                return pos.func_177978_c();
            }
        }
        return null;
    }

    private boolean hasNoActiveSCBlocksNear(World world, BlockPos pos) {
        return !this.hasActiveLaserNextTo(world, pos) && !this.hasActiveScannerNextTo(world, pos) && !this.hasActiveKeypadNextTo(world, pos) && !this.hasActiveReaderNextTo(world, pos) && !this.hasActiveInventoryScannerNextTo(world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(SCContent.reinforcedDoorItem);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? null : SCContent.reinforcedDoorItem;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityOwnable();
    }
}

