/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.imc.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.imc.waila.ICustomWailaDisplay;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WailaDataProvider
implements IWailaDataProvider {
    public static void callbackRegister(IWailaRegistrar registrar) {
        SecurityCraft.log("Adding Waila support!");
        registrar.addConfig("SecurityCraft", "securitycraft.showowner", ClientUtils.localize("waila.displayOwner", new Object[0]));
        registrar.addConfig("SecurityCraft", "securitycraft.showmodules", ClientUtils.localize("waila.showModules", new Object[0]));
        registrar.addConfig("SecurityCraft", "securitycraft.showpasswords", ClientUtils.localize("waila.showPasswords", new Object[0]));
        registrar.addConfig("SecurityCraft", "securitycraft.showcustomname", ClientUtils.localize("waila.showCustomName", new Object[0]));
        registrar.registerBodyProvider((IWailaDataProvider)new WailaDataProvider(), IOwnable.class);
        registrar.registerStackProvider((IWailaDataProvider)new WailaDataProvider(), ICustomWailaDisplay.class);
    }

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler config) {
        if (data.getBlock() instanceof ICustomWailaDisplay) {
            return ((ICustomWailaDisplay)data.getBlock()).getDisplayStack(data.getWorld(), data.getBlockState(), data.getPosition());
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> tipList, IWailaDataAccessor iDataAccessor, IWailaConfigHandler iConfigHandler) {
        return tipList;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> tipList, IWailaDataAccessor iDataAccessor, IWailaConfigHandler iConfigHandler) {
        if (iDataAccessor.getBlock() instanceof ICustomWailaDisplay && !((ICustomWailaDisplay)iDataAccessor.getBlock()).shouldShowSCInfo(iDataAccessor.getWorld(), iDataAccessor.getBlockState(), iDataAccessor.getPosition())) {
            return tipList;
        }
        if (iConfigHandler.getConfig("securitycraft.showowner") && iDataAccessor.getTileEntity() instanceof IOwnable) {
            tipList.add(ClientUtils.localize("waila.owner", new Object[0]) + " " + ((IOwnable)iDataAccessor.getTileEntity()).getOwner().getName());
        }
        if (iConfigHandler.getConfig("securitycraft.showmodules") && iDataAccessor.getTileEntity() instanceof CustomizableSCTE && ((CustomizableSCTE)iDataAccessor.getTileEntity()).getOwner().isOwner(iDataAccessor.getPlayer())) {
            if (!((CustomizableSCTE)iDataAccessor.getTileEntity()).getModules().isEmpty()) {
                tipList.add(ClientUtils.localize("waila.equipped", new Object[0]));
            }
            for (EnumCustomModules module : ((CustomizableSCTE)iDataAccessor.getTileEntity()).getModules()) {
                tipList.add("- " + module.getName());
            }
        }
        if (iConfigHandler.getConfig("securitycraft.showpasswords") && iDataAccessor.getTileEntity() instanceof IPasswordProtected && !(iDataAccessor.getTileEntity() instanceof TileEntityKeycardReader) && ((IOwnable)iDataAccessor.getTileEntity()).getOwner().isOwner(iDataAccessor.getPlayer())) {
            String password = ((IPasswordProtected)iDataAccessor.getTileEntity()).getPassword();
            tipList.add(ClientUtils.localize("waila.password", new Object[0]) + " " + (password != null && !password.isEmpty() ? password : ClientUtils.localize("waila.password.notSet", new Object[0])));
        }
        if (iConfigHandler.getConfig("securitycraft.showcustomname") && iDataAccessor.getTileEntity() instanceof INameable && ((INameable)iDataAccessor.getTileEntity()).canBeNamed()) {
            String name = ((INameable)iDataAccessor.getTileEntity()).getCustomName();
            tipList.add(ClientUtils.localize("waila.customName", new Object[0]) + " " + (((INameable)iDataAccessor.getTileEntity()).hasCustomName() ? name : ClientUtils.localize("waila.customName.notSet", new Object[0])));
        }
        return tipList;
    }

    public List<String> getWailaTail(ItemStack itemstack, List<String> tail, IWailaDataAccessor data, IWailaConfigHandler config) {
        return tail;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tileEntity, NBTTagCompound tagCompound, World world, BlockPos pos) {
        return tagCompound;
    }
}

