/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.entity.EntitySecurityCamera;
import net.geforcemods.securitycraft.misc.CameraView;
import net.geforcemods.securitycraft.network.packets.PacketCUpdateNBTTag;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCameraMonitor
extends Item {
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (BlockUtils.getBlock(worldIn, pos) == SCContent.securityCamera) {
                if (!((IOwnable)worldIn.func_175625_s(pos)).getOwner().isOwner(playerIn)) {
                    PlayerUtils.sendMessageToPlayer(playerIn, ClientUtils.localize("item.cameraMonitor.name", new Object[0]), ClientUtils.localize("messages.cameraMonitor.cannotView", new Object[0]), TextFormatting.RED);
                    return EnumActionResult.SUCCESS;
                }
                if (playerIn.field_71071_by.func_70448_g().func_77978_p() == null) {
                    playerIn.field_71071_by.func_70448_g().func_77982_d(new NBTTagCompound());
                }
                CameraView view = new CameraView(pos, playerIn.field_71093_bK);
                if (this.isCameraAdded(playerIn.field_71071_by.func_70448_g().func_77978_p(), view)) {
                    playerIn.field_71071_by.func_70448_g().func_77978_p().func_82580_o(ItemCameraMonitor.getTagNameFromPosition(playerIn.field_71071_by.func_70448_g().func_77978_p(), view));
                    PlayerUtils.sendMessageToPlayer(playerIn, ClientUtils.localize("item.cameraMonitor.name", new Object[0]), ClientUtils.localize("messages.cameraMonitor.unbound", new Object[0]).replace("#", Utils.getFormattedCoordinates(pos)), TextFormatting.RED);
                    return EnumActionResult.SUCCESS;
                }
                for (int i = 1; i <= 30; ++i) {
                    if (playerIn.field_71071_by.func_70448_g().func_77978_p().func_74764_b("Camera" + i)) continue;
                    playerIn.field_71071_by.func_70448_g().func_77978_p().func_74778_a("Camera" + i, view.toNBTString());
                    PlayerUtils.sendMessageToPlayer(playerIn, ClientUtils.localize("item.cameraMonitor.name", new Object[0]), ClientUtils.localize("messages.cameraMonitor.bound", new Object[0]).replace("#", Utils.getFormattedCoordinates(pos)), TextFormatting.GREEN);
                    break;
                }
                SecurityCraft.network.sendTo((IMessage)new PacketCUpdateNBTTag(stack), (EntityPlayerMP)playerIn);
                return EnumActionResult.SUCCESS;
            }
        } else if (worldIn.field_72995_K && BlockUtils.getBlock(worldIn, pos) != SCContent.securityCamera) {
            if (playerIn.func_184187_bx() != null && playerIn.func_184187_bx() instanceof EntitySecurityCamera) {
                return EnumActionResult.SUCCESS;
            }
            if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
                PlayerUtils.sendMessageToPlayer(playerIn, ClientUtils.localize("item.cameraMonitor.name", new Object[0]), ClientUtils.localize("messages.cameraMonitor.rightclickToView", new Object[0]), TextFormatting.RED);
                return EnumActionResult.SUCCESS;
            }
            playerIn.openGui((Object)SecurityCraft.instance, 12, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (worldIn.field_72995_K) {
            if (playerIn.func_184187_bx() != null && playerIn.func_184187_bx() instanceof EntitySecurityCamera) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
            }
            if (!itemStackIn.func_77942_o() || !this.hasCameraAdded(itemStackIn.func_77978_p())) {
                PlayerUtils.sendMessageToPlayer(playerIn, ClientUtils.localize("item.cameraMonitor.name", new Object[0]), ClientUtils.localize("messages.cameraMonitor.rightclickToView", new Object[0]), TextFormatting.RED);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
            }
            playerIn.openGui((Object)SecurityCraft.instance, 12, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List<String> par3List, boolean par4) {
        if (par1ItemStack.func_77978_p() == null) {
            return;
        }
        par3List.add(ClientUtils.localize("tooltip.cameraMonitor", new Object[0]) + " " + this.getNumberOfCamerasBound(par1ItemStack.func_77978_p()) + "/30");
    }

    public static String getTagNameFromPosition(NBTTagCompound nbt, CameraView view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!nbt.func_74764_b("Camera" + i) || !view.checkCoordinates(coords = nbt.func_74779_i("Camera" + i).split(" "))) continue;
            return "Camera" + i;
        }
        return "";
    }

    public int getSlotFromPosition(NBTTagCompound nbt, CameraView view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!nbt.func_74764_b("Camera" + i) || !view.checkCoordinates(coords = nbt.func_74779_i("Camera" + i).split(" "))) continue;
            return i;
        }
        return -1;
    }

    public boolean hasCameraAdded(NBTTagCompound nbt) {
        if (nbt == null) {
            return false;
        }
        for (int i = 1; i <= 30; ++i) {
            if (!nbt.func_74764_b("Camera" + i)) continue;
            return true;
        }
        return false;
    }

    public boolean isCameraAdded(NBTTagCompound nbt, CameraView view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!nbt.func_74764_b("Camera" + i) || !view.checkCoordinates(coords = nbt.func_74779_i("Camera" + i).split(" "))) continue;
            return true;
        }
        return false;
    }

    public ArrayList<CameraView> getCameraPositions(NBTTagCompound nbt) {
        ArrayList<CameraView> list = new ArrayList<CameraView>();
        for (int i = 1; i <= 30; ++i) {
            if (nbt != null && nbt.func_74764_b("Camera" + i)) {
                String[] coords = nbt.func_74779_i("Camera" + i).split(" ");
                list.add(new CameraView(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]), coords.length == 4 ? Integer.parseInt(coords[3]) : 0));
                continue;
            }
            list.add(null);
        }
        return list;
    }

    public int getNumberOfCamerasBound(NBTTagCompound nbt) {
        if (nbt == null) {
            return 0;
        }
        for (int i = 1; i <= 31; ++i) {
            if (nbt.func_74764_b("Camera" + i)) continue;
            return i - 1;
        }
        return 0;
    }
}

