/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.network.packets.PacketCUpdateNBTTag;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMineRemoteAccessTool
extends Item {
    public int listIndex = 0;

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (worldIn.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
        }
        playerIn.openGui((Object)SecurityCraft.instance, 2, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (BlockUtils.getBlock(worldIn, pos) instanceof IExplosive) {
                if (!this.isMineAdded(stack, worldIn, pos)) {
                    int availSlot = this.getNextAvaliableSlot(stack);
                    if (availSlot == 0) {
                        PlayerUtils.sendMessageToPlayer(playerIn, ClientUtils.localize("item.remoteAccessMine.name", new Object[0]), ClientUtils.localize("messages.mrat.noSlots", new Object[0]), TextFormatting.RED);
                        return EnumActionResult.FAIL;
                    }
                    if (worldIn.func_175625_s(pos) instanceof IOwnable && !((IOwnable)worldIn.func_175625_s(pos)).getOwner().isOwner(playerIn)) {
                        PlayerUtils.sendMessageToPlayer(playerIn, ClientUtils.localize("item.remoteAccessMine.name", new Object[0]), ClientUtils.localize("messages.mrat.cantBind", new Object[0]), TextFormatting.RED);
                        return EnumActionResult.FAIL;
                    }
                    if (stack.func_77978_p() == null) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    stack.func_77978_p().func_74783_a("mine" + availSlot, new int[]{BlockUtils.fromPos(pos)[0], BlockUtils.fromPos(pos)[1], BlockUtils.fromPos(pos)[2]});
                    SecurityCraft.network.sendTo((IMessage)new PacketCUpdateNBTTag(stack), (EntityPlayerMP)playerIn);
                    PlayerUtils.sendMessageToPlayer(playerIn, ClientUtils.localize("item.remoteAccessMine.name", new Object[0]), ClientUtils.localize("messages.mrat.bound", new Object[0]).replace("#", Utils.getFormattedCoordinates(pos)), TextFormatting.GREEN);
                } else {
                    this.removeTagFromItemAndUpdate(stack, pos, playerIn);
                    PlayerUtils.sendMessageToPlayer(playerIn, ClientUtils.localize("item.remoteAccessMine.name", new Object[0]), ClientUtils.localize("messages.mrat.unbound", new Object[0]).replace("#", Utils.getFormattedCoordinates(pos)), TextFormatting.RED);
                }
            } else {
                playerIn.openGui((Object)SecurityCraft.instance, 2, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List<String> par3List, boolean par4) {
        if (par1ItemStack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            if (par1ItemStack.func_77978_p().func_74759_k("mine" + i).length > 0) {
                int[] coords = par1ItemStack.func_77978_p().func_74759_k("mine" + i);
                if (coords[0] == 0 && coords[1] == 0 && coords[2] == 0) {
                    par3List.add("---");
                    continue;
                }
                par3List.add(ClientUtils.localize("tooltip.mine", new Object[0]) + " " + i + ": X:" + coords[0] + " Y:" + coords[1] + " Z:" + coords[2]);
                continue;
            }
            par3List.add("---");
        }
    }

    private void removeTagFromItemAndUpdate(ItemStack par1ItemStack, BlockPos pos, EntityPlayer par5EntityPlayer) {
        if (par1ItemStack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords;
            if (par1ItemStack.func_77978_p().func_74759_k("mine" + i).length <= 0 || (coords = par1ItemStack.func_77978_p().func_74759_k("mine" + i))[0] != pos.func_177958_n() || coords[1] != pos.func_177956_o() || coords[2] != pos.func_177952_p()) continue;
            par1ItemStack.func_77978_p().func_74783_a("mine" + i, new int[]{0, 0, 0});
            SecurityCraft.network.sendTo((IMessage)new PacketCUpdateNBTTag(par1ItemStack), (EntityPlayerMP)par5EntityPlayer);
            return;
        }
    }

    private boolean isMineAdded(ItemStack par1ItemStack, World par2World, BlockPos pos) {
        if (par1ItemStack.func_77978_p() == null) {
            return false;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords;
            if (par1ItemStack.func_77978_p().func_74759_k("mine" + i).length <= 0 || (coords = par1ItemStack.func_77978_p().func_74759_k("mine" + i))[0] != pos.func_177958_n() || coords[1] != pos.func_177956_o() || coords[2] != pos.func_177952_p()) continue;
            return true;
        }
        return false;
    }

    private int getNextAvaliableSlot(ItemStack par1ItemStack) {
        for (int i = 1; i <= 6; ++i) {
            if (par1ItemStack.func_77978_p() == null) {
                return 1;
            }
            if (par1ItemStack.func_77978_p().func_74759_k("mine" + i).length != 0 && (par1ItemStack.func_77978_p().func_74759_k("mine" + i)[0] != 0 || par1ItemStack.func_77978_p().func_74759_k("mine" + i)[1] != 0 || par1ItemStack.func_77978_p().func_74759_k("mine" + i)[2] != 0)) continue;
            return i;
        }
        return 0;
    }
}

