/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemModule
extends Item {
    private final EnumCustomModules module;
    private final boolean nbtCanBeModified;
    private boolean canBeCustomized;
    private int guiToOpen;
    private int numberOfItemAddons;
    private int numberOfBlockAddons;

    public ItemModule(EnumCustomModules module, boolean nbtCanBeModified) {
        this(module, nbtCanBeModified, false, -1, 0, 0);
    }

    public ItemModule(EnumCustomModules module, boolean nbtCanBeModified, boolean canBeCustomized, int guiToOpen) {
        this(module, nbtCanBeModified, canBeCustomized, guiToOpen, 0, 0);
    }

    public ItemModule(EnumCustomModules module, boolean nbtCanBeModified, boolean canBeCustomized, int guiToOpen, int itemAddons, int blockAddons) {
        this.module = module;
        this.nbtCanBeModified = nbtCanBeModified;
        this.canBeCustomized = canBeCustomized;
        this.guiToOpen = guiToOpen;
        this.numberOfItemAddons = itemAddons;
        this.numberOfBlockAddons = blockAddons;
        this.func_77625_d(1);
        this.func_77637_a(SecurityCraft.tabSCTechnical);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        try {
            if (!worldIn.field_72995_K) {
                if (!itemStackIn.func_77942_o()) {
                    itemStackIn.func_77982_d(new NBTTagCompound());
                    ClientUtils.syncItemNBT(itemStackIn);
                }
                if (this.canBeCustomized()) {
                    playerIn.openGui((Object)SecurityCraft.instance, this.guiToOpen, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
                }
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List<String> par3List, boolean par4) {
        if (this.nbtCanBeModified || this.canBeCustomized()) {
            par3List.add(ClientUtils.localize("tooltip.module.modifiable", new Object[0]));
        } else {
            par3List.add(ClientUtils.localize("tooltip.module.notModifiable", new Object[0]));
        }
        if (this.nbtCanBeModified) {
            par3List.add(ClientUtils.localize("tooltip.module.playerCustomization.usage", new Object[0]));
            par3List.add(" ");
            par3List.add(ClientUtils.localize("tooltip.module.playerCustomization.players", new Object[0]) + ":");
            if (par1ItemStack.func_77978_p() != null) {
                for (int i = 1; i <= 10; ++i) {
                    if (par1ItemStack.func_77978_p().func_74779_i("Player" + i).isEmpty()) continue;
                    par3List.add(par1ItemStack.func_77978_p().func_74779_i("Player" + i));
                }
            }
        }
        if (this.canBeCustomized()) {
            if (this.numberOfItemAddons > 0 && this.numberOfBlockAddons > 0) {
                par3List.add(ClientUtils.localize("tooltip.module.itemAddons.usage.blocksAndItems", new Object[0]).replace("#blocks", this.numberOfBlockAddons + "").replace("#items", this.numberOfItemAddons + ""));
            }
            if (this.numberOfItemAddons > 0 && this.numberOfBlockAddons == 0) {
                par3List.add(ClientUtils.localize("tooltip.module.itemAddons.usage.items", new Object[0]).replace("#", this.numberOfItemAddons + ""));
            }
            if (this.numberOfItemAddons == 0 && this.numberOfBlockAddons > 0) {
                par3List.add(ClientUtils.localize("tooltip.module.itemAddons.usage.blocks", new Object[0]).replace("#", this.numberOfBlockAddons + ""));
            }
            if (this.getNumberOfAddons() > 0) {
                par3List.add(" ");
                par3List.add(ClientUtils.localize("tooltip.module.itemAddons.added", new Object[0]) + ":");
                for (Item item : this.getItemAddons(par1ItemStack.func_77978_p())) {
                    par3List.add("- " + ClientUtils.localize(item.func_77658_a() + ".name", new Object[0]));
                }
                for (Block block : this.getBlockAddons(par1ItemStack.func_77978_p())) {
                    par3List.add("- " + ClientUtils.localize(block.func_149732_F(), new Object[0]));
                }
            }
        }
    }

    public EnumCustomModules getModule() {
        return this.module;
    }

    public boolean canNBTBeModified() {
        return this.nbtCanBeModified;
    }

    public int getNumberOfAddons() {
        return this.numberOfItemAddons + this.numberOfBlockAddons;
    }

    public int getNumberOfItemAddons() {
        return this.numberOfItemAddons;
    }

    public int getNumberOfBlockAddons() {
        return this.numberOfBlockAddons;
    }

    public ArrayList<Item> getItemAddons(NBTTagCompound tag) {
        ArrayList<Item> list = new ArrayList<Item>();
        if (tag == null) {
            return list;
        }
        NBTTagList items = tag.func_150295_c("ItemInventory", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot >= this.numberOfItemAddons || !ItemStack.func_77949_a((NBTTagCompound)item).func_77977_a().startsWith("item.")) continue;
            list.add(ItemStack.func_77949_a((NBTTagCompound)item).func_77973_b());
        }
        return list;
    }

    public ArrayList<Block> getBlockAddons(NBTTagCompound tag) {
        ArrayList<Block> list = new ArrayList<Block>();
        if (tag == null) {
            return list;
        }
        NBTTagList items = tag.func_150295_c("ItemInventory", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot >= this.numberOfBlockAddons || !ItemStack.func_77949_a((NBTTagCompound)item).func_77977_a().startsWith("tile.")) continue;
            list.add(Block.func_149634_a((Item)ItemStack.func_77949_a((NBTTagCompound)item).func_77973_b()));
        }
        return list;
    }

    public ArrayList<ItemStack> getAddons(NBTTagCompound tag) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (tag == null) {
            return list;
        }
        NBTTagList items = tag.func_150295_c("ItemInventory", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot >= this.numberOfBlockAddons) continue;
            list.add(ItemStack.func_77949_a((NBTTagCompound)item));
        }
        return list;
    }

    public boolean canBeCustomized() {
        return this.canBeCustomized;
    }
}

