/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.packets;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.network.packets.PacketHelper;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSAddModules
implements IMessage {
    private int x;
    private int y;
    private int z;
    private ItemStack[] modules;
    private int arrayLength;

    public PacketSAddModules() {
    }

    public PacketSAddModules(int x, int y, int z, ItemStack ... modules) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.modules = modules;
        this.arrayLength = modules.length;
    }

    public void toBytes(ByteBuf par1ByteBuf) {
        par1ByteBuf.writeInt(this.x);
        par1ByteBuf.writeInt(this.y);
        par1ByteBuf.writeInt(this.z);
        par1ByteBuf.writeInt(this.arrayLength);
        for (ItemStack stack : this.modules) {
            ByteBufUtils.writeItemStack((ByteBuf)par1ByteBuf, (ItemStack)stack);
        }
    }

    public void fromBytes(ByteBuf par1ByteBuf) {
        this.x = par1ByteBuf.readInt();
        this.y = par1ByteBuf.readInt();
        this.z = par1ByteBuf.readInt();
        this.arrayLength = par1ByteBuf.readInt();
        for (int i = 0; i < this.arrayLength; ++i) {
            if (this.modules == null) {
                this.modules = new ItemStack[this.arrayLength];
            }
            this.modules[i] = ByteBufUtils.readItemStack((ByteBuf)par1ByteBuf);
        }
    }

    public static class Handler
    extends PacketHelper
    implements IMessageHandler<PacketSAddModules, IMessage> {
        public IMessage onMessage(PacketSAddModules packet, MessageContext context) {
            WorldUtils.addScheduledTask(this.getWorld((EntityPlayer)context.getServerHandler().field_147369_b), () -> {
                BlockPos pos = BlockUtils.toPos(packet.x, packet.y, packet.z);
                ItemStack[] modules = packet.modules;
                EntityPlayerMP par1EntityPlayer = context.getServerHandler().field_147369_b;
                if (this.getWorld((EntityPlayer)par1EntityPlayer).func_175625_s(pos) != null && this.getWorld((EntityPlayer)par1EntityPlayer).func_175625_s(pos) instanceof CustomizableSCTE) {
                    for (ItemStack module : modules) {
                        if (((CustomizableSCTE)this.getWorld((EntityPlayer)par1EntityPlayer).func_175625_s(pos)).hasModule(EnumCustomModules.getModuleFromStack(module))) continue;
                        ((CustomizableSCTE)this.getWorld((EntityPlayer)par1EntityPlayer).func_175625_s(pos)).insertModule(module);
                    }
                }
            });
            return null;
        }
    }
}

