/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.packets;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.network.packets.PacketHelper;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSSetOwner
implements IMessage {
    private int x;
    private int y;
    private int z;
    private String uuid;
    private String name;

    public PacketSSetOwner() {
    }

    public PacketSSetOwner(int x, int y, int z, String uuid, String name) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.uuid = uuid;
        this.name = name;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.uuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uuid);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
    }

    public static class Handler
    extends PacketHelper
    implements IMessageHandler<PacketSSetOwner, IMessage> {
        public IMessage onMessage(PacketSSetOwner packet, MessageContext ctx) {
            WorldUtils.addScheduledTask(this.getWorld((EntityPlayer)ctx.getServerHandler().field_147369_b), () -> {
                BlockPos pos = BlockUtils.toPos(packet.x, packet.y, packet.z);
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (this.getWorld((EntityPlayer)player).func_175625_s(pos) != null && this.getWorld((EntityPlayer)player).func_175625_s(pos) instanceof IOwnable) {
                    ((IOwnable)this.getWorld((EntityPlayer)player).func_175625_s(pos)).getOwner().set(packet.uuid, packet.name);
                }
            });
            return null;
        }
    }
}

