/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.packets;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.network.packets.PacketHelper;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadChest;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSSetPassword
implements IMessage {
    private String password;
    private int x;
    private int y;
    private int z;

    public PacketSSetPassword() {
    }

    public PacketSSetPassword(int x, int y, int z, String code) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.password = code;
    }

    public void toBytes(ByteBuf par1ByteBuf) {
        par1ByteBuf.writeInt(this.x);
        par1ByteBuf.writeInt(this.y);
        par1ByteBuf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)par1ByteBuf, (String)this.password);
    }

    public void fromBytes(ByteBuf par1ByteBuf) {
        this.x = par1ByteBuf.readInt();
        this.y = par1ByteBuf.readInt();
        this.z = par1ByteBuf.readInt();
        this.password = ByteBufUtils.readUTF8String((ByteBuf)par1ByteBuf);
    }

    public static class Handler
    extends PacketHelper
    implements IMessageHandler<PacketSSetPassword, IMessage> {
        public IMessage onMessage(PacketSSetPassword packet, MessageContext ctx) {
            WorldUtils.addScheduledTask(this.getWorld((EntityPlayer)ctx.getServerHandler().field_147369_b), () -> {
                BlockPos pos = BlockUtils.toPos(packet.x, packet.y, packet.z);
                String password = packet.password;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (this.getWorld((EntityPlayer)player).func_175625_s(pos) != null && this.getWorld((EntityPlayer)player).func_175625_s(pos) instanceof IPasswordProtected) {
                    ((IPasswordProtected)this.getWorld((EntityPlayer)player).func_175625_s(pos)).setPassword(password);
                    this.checkForAdjecentChest(pos, password, (EntityPlayer)player);
                }
            });
            return null;
        }

        private void checkForAdjecentChest(BlockPos pos, String codeToSet, EntityPlayer player) {
            if (this.getWorld(player).func_175625_s(pos) != null && this.getWorld(player).func_175625_s(pos) instanceof TileEntityKeypadChest) {
                if (this.getWorld(player).func_175625_s(pos.func_177974_f()) != null && this.getWorld(player).func_175625_s(pos.func_177974_f()) instanceof TileEntityKeypadChest) {
                    ((IPasswordProtected)this.getWorld(player).func_175625_s(pos.func_177974_f())).setPassword(codeToSet);
                } else if (this.getWorld(player).func_175625_s(pos.func_177976_e()) != null && this.getWorld(player).func_175625_s(pos.func_177976_e()) instanceof TileEntityKeypadChest) {
                    ((IPasswordProtected)this.getWorld(player).func_175625_s(pos.func_177976_e())).setPassword(codeToSet);
                } else if (this.getWorld(player).func_175625_s(pos.func_177968_d()) != null && this.getWorld(player).func_175625_s(pos.func_177968_d()) instanceof TileEntityKeypadChest) {
                    ((IPasswordProtected)this.getWorld(player).func_175625_s(pos.func_177968_d())).setPassword(codeToSet);
                } else if (this.getWorld(player).func_175625_s(pos.func_177978_c()) != null && this.getWorld(player).func_175625_s(pos.func_177978_c()) instanceof TileEntityKeypadChest) {
                    ((IPasswordProtected)this.getWorld(player).func_175625_s(pos.func_177978_c())).setPassword(codeToSet);
                }
            }
        }
    }
}

