/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.packets;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.network.packets.PacketHelper;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSetExplosiveState
implements IMessage {
    private int x;
    private int y;
    private int z;
    private String state;

    public PacketSetExplosiveState() {
    }

    public PacketSetExplosiveState(int x, int y, int z, String state) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.state = state;
    }

    public void fromBytes(ByteBuf par1ByteBuf) {
        this.x = par1ByteBuf.readInt();
        this.y = par1ByteBuf.readInt();
        this.z = par1ByteBuf.readInt();
        this.state = ByteBufUtils.readUTF8String((ByteBuf)par1ByteBuf);
    }

    public void toBytes(ByteBuf par1ByteBuf) {
        par1ByteBuf.writeInt(this.x);
        par1ByteBuf.writeInt(this.y);
        par1ByteBuf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)par1ByteBuf, (String)this.state);
    }

    public static class Handler
    extends PacketHelper
    implements IMessageHandler<PacketSetExplosiveState, IMessage> {
        public IMessage onMessage(PacketSetExplosiveState packet, MessageContext context) {
            WorldUtils.addScheduledTask(this.getWorld((EntityPlayer)context.getServerHandler().field_147369_b), () -> {
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                if (BlockUtils.getBlock(this.getWorld((EntityPlayer)player), packet.x, packet.y, packet.z) != null && BlockUtils.getBlock(this.getWorld((EntityPlayer)player), packet.x, packet.y, packet.z) instanceof IExplosive) {
                    if (packet.state.equalsIgnoreCase("activate")) {
                        ((IExplosive)BlockUtils.getBlock(this.getWorld((EntityPlayer)player), packet.x, packet.y, packet.z)).activateMine(this.getWorld((EntityPlayer)player), BlockUtils.toPos(packet.x, packet.y, packet.z));
                    } else if (packet.state.equalsIgnoreCase("defuse")) {
                        ((IExplosive)BlockUtils.getBlock(this.getWorld((EntityPlayer)player), packet.x, packet.y, packet.z)).defuseMine(this.getWorld((EntityPlayer)player), BlockUtils.toPos(packet.x, packet.y, packet.z));
                    } else if (packet.state.equalsIgnoreCase("detonate")) {
                        ((IExplosive)BlockUtils.getBlock(this.getWorld((EntityPlayer)player), packet.x, packet.y, packet.z)).explode(this.getWorld((EntityPlayer)player), BlockUtils.toPos(packet.x, packet.y, packet.z));
                    }
                }
            });
            return null;
        }
    }
}

