/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.mines.BlockIMS;
import net.geforcemods.securitycraft.entity.EntityIMSBomb;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.network.packets.PacketCPlaySoundAtPos;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityIMS
extends CustomizableSCTE {
    private int bombsRemaining = 4;
    private EnumIMSTargetingMode targetingOption = EnumIMSTargetingMode.PLAYERS_AND_MOBS;
    private boolean updateBombCount = false;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.updateBombCount) {
            BlockUtils.setBlockProperty(this.field_145850_b, this.field_174879_c, BlockIMS.MINES, BlockUtils.getBlockPropertyAsInteger(this.field_145850_b, this.field_174879_c, BlockIMS.MINES) - 1);
            this.updateBombCount = false;
        }
        if (this.field_145850_b.func_82737_E() % 80L == 0L) {
            this.launchMine();
        }
    }

    private void launchMine() {
        boolean launchedMine = false;
        if (this.bombsRemaining > 0) {
            double d7;
            double d6;
            double d5;
            int launchHeight;
            EntityLivingBase entity;
            double d0 = SecurityCraft.config.imsRange;
            AxisAlignedBB axisalignedbb = BlockUtils.fromBounds(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 1).func_72314_b(d0, d0, d0);
            List list1 = this.field_145850_b.func_72872_a(EntityPlayer.class, axisalignedbb);
            List list2 = this.field_145850_b.func_72872_a(EntityMob.class, axisalignedbb);
            Iterator iterator1 = list1.iterator();
            Iterator iterator2 = list2.iterator();
            while (this.targetingOption == EnumIMSTargetingMode.PLAYERS_AND_MOBS && iterator2.hasNext()) {
                entity = (EntityLivingBase)iterator2.next();
                launchHeight = this.getLaunchHeight();
                if (PlayerUtils.isPlayerMountedOnCamera(entity) || WorldUtils.isPathObstructed(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + ((double)((launchHeight - 1) / 3) + 0.5), (double)this.field_174879_c.func_177952_p() + 0.5, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v) || this.hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(this.field_145850_b, this.field_174879_c, EnumCustomModules.WHITELIST).contains(entity.func_70005_c_().toLowerCase())) continue;
                d5 = entity.field_70165_t - ((double)this.field_174879_c.func_177958_n() + 0.5);
                d6 = entity.func_174813_aQ().field_72338_b + (double)(entity.field_70131_O / 2.0f) - ((double)this.field_174879_c.func_177956_o() + 1.25);
                d7 = entity.field_70161_v - ((double)this.field_174879_c.func_177952_p() + 0.5);
                this.spawnMine(entity, d5, d6, d7, launchHeight);
                if (this.field_145850_b.field_72995_K) {
                    SecurityCraft.network.sendToAll((IMessage)new PacketCPlaySoundAtPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), "random.bow", 1.0, "block"));
                }
                --this.bombsRemaining;
                if (this.bombsRemaining == 0) {
                    this.field_145850_b.func_175684_a(this.field_174879_c, BlockUtils.getBlock(this.field_145850_b, this.field_174879_c), 140);
                }
                launchedMine = true;
                this.updateBombCount = true;
                break;
            }
            while (!launchedMine && iterator1.hasNext()) {
                entity = (EntityPlayer)iterator1.next();
                launchHeight = this.getLaunchHeight();
                if (entity != null && this.getOwner().isOwner((EntityPlayer)entity) || PlayerUtils.isPlayerMountedOnCamera(entity) || WorldUtils.isPathObstructed(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + ((double)((launchHeight - 1) / 3) + 0.5), (double)this.field_174879_c.func_177952_p() + 0.5, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v) || this.hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(this.field_145850_b, this.field_174879_c, EnumCustomModules.WHITELIST).contains(entity.func_70005_c_())) continue;
                d5 = entity.field_70165_t - ((double)this.field_174879_c.func_177958_n() + 0.5);
                d6 = entity.func_174813_aQ().field_72338_b + (double)(entity.field_70131_O / 2.0f) - ((double)this.field_174879_c.func_177956_o() + 1.25);
                d7 = entity.field_70161_v - ((double)this.field_174879_c.func_177952_p() + 0.5);
                this.spawnMine((EntityPlayer)entity, d5, d6, d7, launchHeight);
                if (this.field_145850_b.field_72995_K) {
                    SecurityCraft.network.sendToAll((IMessage)new PacketCPlaySoundAtPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), "random.bow", 1.0, "block"));
                }
                --this.bombsRemaining;
                if (this.bombsRemaining == 0) {
                    this.field_145850_b.func_175684_a(this.field_174879_c, BlockUtils.getBlock(this.field_145850_b, this.field_174879_c), 140);
                }
                this.updateBombCount = true;
                break;
            }
        }
    }

    private void spawnMine(EntityPlayer target, double x, double y, double z, int launchHeight) {
        if (this.bombsRemaining == 4) {
            EntityIMSBomb entitylargefireball = new EntityIMSBomb(this.field_145850_b, target, (double)this.field_174879_c.func_177958_n() + 1.2, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 1.2, x, y, z, launchHeight);
            WorldUtils.addScheduledTask(this.field_145850_b, () -> this.field_145850_b.func_72838_d((Entity)entitylargefireball));
        } else if (this.bombsRemaining == 3) {
            EntityIMSBomb entitylargefireball = new EntityIMSBomb(this.field_145850_b, target, (double)this.field_174879_c.func_177958_n() + 1.2, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.6, x, y, z, launchHeight);
            WorldUtils.addScheduledTask(this.field_145850_b, () -> this.field_145850_b.func_72838_d((Entity)entitylargefireball));
        } else if (this.bombsRemaining == 2) {
            EntityIMSBomb entitylargefireball = new EntityIMSBomb(this.field_145850_b, target, (double)this.field_174879_c.func_177958_n() + 0.55, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 1.2, x, y, z, launchHeight);
            WorldUtils.addScheduledTask(this.field_145850_b, () -> this.field_145850_b.func_72838_d((Entity)entitylargefireball));
        } else if (this.bombsRemaining == 1) {
            EntityIMSBomb entitylargefireball = new EntityIMSBomb(this.field_145850_b, target, (double)this.field_174879_c.func_177958_n() + 0.55, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.6, x, y, z, launchHeight);
            WorldUtils.addScheduledTask(this.field_145850_b, () -> this.field_145850_b.func_72838_d((Entity)entitylargefireball));
        }
    }

    private void spawnMine(EntityLivingBase target, double x, double y, double z, int launchHeight) {
        if (this.bombsRemaining == 4) {
            EntityIMSBomb entitylargefireball = new EntityIMSBomb(this.field_145850_b, target, (double)this.field_174879_c.func_177958_n() + 1.2, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 1.2, x, y, z, launchHeight);
            WorldUtils.addScheduledTask(this.field_145850_b, () -> this.field_145850_b.func_72838_d((Entity)entitylargefireball));
        } else if (this.bombsRemaining == 3) {
            EntityIMSBomb entitylargefireball = new EntityIMSBomb(this.field_145850_b, target, (double)this.field_174879_c.func_177958_n() + 1.2, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.6, x, y, z, launchHeight);
            WorldUtils.addScheduledTask(this.field_145850_b, () -> this.field_145850_b.func_72838_d((Entity)entitylargefireball));
        } else if (this.bombsRemaining == 2) {
            EntityIMSBomb entitylargefireball = new EntityIMSBomb(this.field_145850_b, target, (double)this.field_174879_c.func_177958_n() + 0.55, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 1.2, x, y, z, launchHeight);
            WorldUtils.addScheduledTask(this.field_145850_b, () -> this.field_145850_b.func_72838_d((Entity)entitylargefireball));
        } else if (this.bombsRemaining == 1) {
            EntityIMSBomb entitylargefireball = new EntityIMSBomb(this.field_145850_b, target, (double)this.field_174879_c.func_177958_n() + 0.55, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.6, x, y, z, launchHeight);
            WorldUtils.addScheduledTask(this.field_145850_b, () -> this.field_145850_b.func_72838_d((Entity)entitylargefireball));
        }
    }

    private int getLaunchHeight() {
        int height;
        for (height = 1; height <= 9 && (BlockUtils.getBlock(this.func_145831_w(), this.func_174877_v().func_177981_b(height)) == null || BlockUtils.getBlock(this.func_145831_w(), this.func_174877_v().func_177981_b(height)) == Blocks.field_150350_a); ++height) {
        }
        return height * 3;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        super.func_189515_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("bombsRemaining", this.bombsRemaining);
        par1NBTTagCompound.func_74768_a("targetingOption", this.targetingOption.modeIndex);
        par1NBTTagCompound.func_74757_a("updateBombCount", this.updateBombCount);
        return par1NBTTagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("bombsRemaining")) {
            this.bombsRemaining = par1NBTTagCompound.func_74762_e("bombsRemaining");
        }
        if (par1NBTTagCompound.func_74764_b("targetingOption")) {
            this.targetingOption = EnumIMSTargetingMode.values()[par1NBTTagCompound.func_74762_e("targetingOption")];
        }
        if (par1NBTTagCompound.func_74764_b("updateBombCount")) {
            this.updateBombCount = par1NBTTagCompound.func_74767_n("updateBombCount");
        }
    }

    public int getBombsRemaining() {
        return this.bombsRemaining;
    }

    public void setBombsRemaining(int bombsRemaining) {
        this.bombsRemaining = bombsRemaining;
    }

    public EnumIMSTargetingMode getTargetingOption() {
        return this.targetingOption;
    }

    public void setTargetingOption(EnumIMSTargetingMode targetingOption) {
        this.targetingOption = targetingOption;
    }

    @Override
    public EnumCustomModules[] acceptedModules() {
        return new EnumCustomModules[]{EnumCustomModules.WHITELIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public static enum EnumIMSTargetingMode {
        PLAYERS(0),
        PLAYERS_AND_MOBS(1);

        public final int modeIndex;

        private EnumIMSTargetingMode(int index) {
            this.modeIndex = index;
        }
    }
}

