/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas;

import hunternif.mc.atlas.CommonProxy;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.core.AtlasDataHandler;
import hunternif.mc.atlas.core.PlayerEventHandler;
import hunternif.mc.atlas.ext.DeathWatcher;
import hunternif.mc.atlas.ext.ExtBiomeDataHandler;
import hunternif.mc.atlas.ext.NetherFortressWatcher;
import hunternif.mc.atlas.ext.StructureWatcher;
import hunternif.mc.atlas.ext.VillageWatcher;
import hunternif.mc.atlas.item.ItemAtlas;
import hunternif.mc.atlas.item.ItemEmptyAtlas;
import hunternif.mc.atlas.item.RecipeAtlasCloning;
import hunternif.mc.atlas.item.RecipeAtlasCombining;
import hunternif.mc.atlas.marker.GlobalMarkersDataHandler;
import hunternif.mc.atlas.marker.MarkersDataHandler;
import hunternif.mc.atlas.marker.NetherPortalWatcher;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.registry.MarkerRegistry;
import hunternif.mc.atlas.registry.MarkerTypes;
import hunternif.mc.atlas.util.Log;
import java.io.File;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.RecipeSorter;

@Mod(modid="antiqueatlas", name="Antique Atlas", version="4.4.6", guiFactory="hunternif.mc.atlas.client.gui.config.AAConfigGuiFactory", acceptedMinecraftVersions="[1.9.4]")
public class AntiqueAtlasMod {
    public static final String ID = "antiqueatlas";
    public static final String NAME = "Antique Atlas";
    public static final String CHANNEL = "antiqueatlas";
    public static final String VERSION = "4.4.6";
    @Mod.Instance(value="antiqueatlas")
    public static AntiqueAtlasMod instance;
    @SidedProxy(clientSide="hunternif.mc.atlas.ClientProxy", serverSide="hunternif.mc.atlas.CommonProxy")
    public static CommonProxy proxy;
    public static final SettingsConfig settings;
    public static final AtlasDataHandler atlasData;
    public static final MarkersDataHandler markersData;
    public static final ExtBiomeDataHandler extBiomeData;
    public static final GlobalMarkersDataHandler globalMarkersData;
    public static ItemAtlas itemAtlas;
    public static ItemEmptyAtlas itemEmptyAtlas;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Log.setModID("antiqueatlas");
        MarkerRegistry.INSTANCE.getClass();
        MarkerTypes.INSTANCE.getClass();
        proxy.preInit(event);
        settings.load(new File(AntiqueAtlasMod.proxy.configDir, "settings.cfg"));
        MinecraftForge.EVENT_BUS.register((Object)new SettingsConfig.Listener());
        if (AntiqueAtlasMod.settings.itemNeeded) {
            itemAtlas = (ItemAtlas)((Item)new ItemAtlas().setRegistryName("antiqueatlas", "antiqueAtlas")).func_77655_b("antiqueAtlas");
            itemEmptyAtlas = (ItemEmptyAtlas)((Item)new ItemEmptyAtlas().setRegistryName("antiqueatlas", "emptyAntiqueAtlas")).func_77655_b("emptyAntiqueAtlas").func_77637_a(CreativeTabs.field_78040_i);
            GameRegistry.register((IForgeRegistryEntry)itemAtlas);
            GameRegistry.register((IForgeRegistryEntry)itemEmptyAtlas);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PacketDispatcher.registerPackets();
        proxy.init(event);
        if (AntiqueAtlasMod.settings.itemNeeded) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)itemEmptyAtlas), (Object[])new Object[]{Items.field_151122_aG, Items.field_151111_aL});
            RecipeSorter.register((String)"antiqueatlas:atlascloning", RecipeAtlasCloning.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            GameRegistry.addRecipe((IRecipe)new RecipeAtlasCloning());
            RecipeSorter.register((String)"antiqueatlas:atlascombining", RecipeAtlasCombining.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            RecipeAtlasCombining recipeCombining = new RecipeAtlasCombining();
            GameRegistry.addRecipe((IRecipe)recipeCombining);
            MinecraftForge.EVENT_BUS.register((Object)recipeCombining);
        } else {
            MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler());
        }
        MinecraftForge.EVENT_BUS.register((Object)atlasData);
        MinecraftForge.EVENT_BUS.register((Object)markersData);
        MinecraftForge.EVENT_BUS.register((Object)extBiomeData);
        MinecraftForge.EVENT_BUS.register((Object)globalMarkersData);
        MinecraftForge.EVENT_BUS.register((Object)new DeathWatcher());
        MinecraftForge.EVENT_BUS.register((Object)new StructureWatcher("EndCity", 1, MarkerTypes.END_CITY_FAR, "gui.antiqueatlas.marker.endcity").setTileMarker(MarkerTypes.END_CITY, "gui.antiqueatlas.marker.endcity"));
        MinecraftForge.EVENT_BUS.register((Object)new VillageWatcher());
        MinecraftForge.EVENT_BUS.register((Object)new NetherFortressWatcher());
        MinecraftForge.EVENT_BUS.register((Object)new NetherPortalWatcher());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    static {
        settings = new SettingsConfig();
        atlasData = new AtlasDataHandler();
        markersData = new MarkersDataHandler();
        extBiomeData = new ExtBiomeDataHandler();
        globalMarkersData = new GlobalMarkersDataHandler();
    }
}

