/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.api.impl;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.api.MarkerAPI;
import hunternif.mc.atlas.marker.GlobalMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.bidirectional.DeleteMarkerPacket;
import hunternif.mc.atlas.network.client.MarkersPacket;
import hunternif.mc.atlas.network.server.AddMarkerPacket;
import hunternif.mc.atlas.registry.MarkerRegistry;
import hunternif.mc.atlas.registry.MarkerType;
import hunternif.mc.atlas.util.Log;
import net.minecraft.world.World;

public class MarkerApiImpl
implements MarkerAPI {
    private static final int GLOBAL = -1;

    @Override
    public void putMarker(World world, boolean visibleAhead, int atlasID, String markerType, String label, int x, int z) {
        this.doPutMarker(world, visibleAhead, atlasID, markerType, label, x, z);
    }

    @Override
    public void putGlobalMarker(World world, boolean visibleAhead, String markerType, String label, int x, int z) {
        this.doPutMarker(world, visibleAhead, -1, markerType, label, x, z);
    }

    private void doPutMarker(World world, boolean visibleAhead, int atlasID, String markerType, String label, int x, int z) {
        if (world.field_72995_K) {
            if (atlasID == -1) {
                Log.warn("Client tried to add a global marker!", new Object[0]);
            } else {
                PacketDispatcher.sendToServer(new AddMarkerPacket(atlasID, world.field_73011_w.getDimension(), markerType, label, x, z, visibleAhead));
            }
        } else if (atlasID == -1) {
            GlobalMarkersData data = AntiqueAtlasMod.globalMarkersData.getData();
            Marker marker = ((MarkersData)data).createAndSaveMarker(markerType, label, world.field_73011_w.getDimension(), x, z, visibleAhead);
            PacketDispatcher.sendToAll(new MarkersPacket(world.field_73011_w.getDimension(), marker));
        } else {
            MarkersData data = AntiqueAtlasMod.markersData.getMarkersData(atlasID, world);
            Marker marker = data.createAndSaveMarker(markerType, label, world.field_73011_w.getDimension(), x, z, visibleAhead);
            PacketDispatcher.sendToAll(new MarkersPacket(atlasID, world.field_73011_w.getDimension(), marker));
        }
    }

    @Override
    public void deleteMarker(World world, int atlasID, int markerID) {
        this.doDeleteMarker(world, atlasID, markerID);
    }

    @Override
    public void deleteGlobalMarker(World world, int markerID) {
        this.doDeleteMarker(world, -1, markerID);
    }

    private void doDeleteMarker(World world, int atlasID, int markerID) {
        DeleteMarkerPacket packet;
        DeleteMarkerPacket deleteMarkerPacket = packet = atlasID == -1 ? new DeleteMarkerPacket(markerID) : new DeleteMarkerPacket(atlasID, markerID);
        if (world.field_72995_K) {
            if (atlasID == -1) {
                Log.warn("Client tried to delete a global marker!", new Object[0]);
            } else {
                PacketDispatcher.sendToServer(packet);
            }
        } else {
            GlobalMarkersData data = atlasID == -1 ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersData(atlasID, world);
            data.removeMarker(markerID);
            PacketDispatcher.sendToAll(packet);
        }
    }

    @Override
    public void registerMarker(MarkerType markerType) {
        MarkerRegistry.register(markerType);
    }
}

