/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.core.IBiomeDetector;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.util.ByteUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeDetectorBase
implements IBiomeDetector {
    private boolean doScanPonds = true;
    private static final int waterPoolBiomeID = Biome.func_185362_a((Biome)Biomes.field_76781_i);
    private static final int priorityWaterPool = 3;
    private static final int prioritylavaPool = 6;
    private static final boolean[] waterBiomes = new boolean[256];
    private static final boolean[] beachBiomes = new boolean[256];

    public static void scanBiomeTypes() {
        for (Biome biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
            BiomeDetectorBase.waterBiomes[Biome.func_185362_a((Biome)biome)] = true;
        }
        for (Biome biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
            BiomeDetectorBase.beachBiomes[Biome.func_185362_a((Biome)biome)] = true;
        }
    }

    public void setScanPonds(boolean value) {
        this.doScanPonds = value;
    }

    int priorityForBiome(Biome biome) {
        if (waterBiomes[Biome.func_185362_a((Biome)biome)]) {
            return 4;
        }
        if (beachBiomes[Biome.func_185362_a((Biome)biome)]) {
            return 3;
        }
        return 1;
    }

    @Override
    public int getBiomeID(Chunk chunk) {
        int biomeCount = Biome.field_185377_q.func_148742_b().size();
        int[] chunkBiomes = ByteUtil.unsignedByteToIntArray(chunk.func_76605_m());
        int[] biomeOccurrences = new int[biomeCount];
        int lavaOccurences = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                int biomeID = chunkBiomes[x << 4 | z];
                if (this.doScanPonds && (y = chunk.func_76611_b(x, z)) > 0) {
                    Block topBlock = chunk.func_186032_a(x, y - 1, z).func_177230_c();
                    Block topBlock2 = chunk.func_186032_a(x, y, z).func_177230_c();
                    if (topBlock == Blocks.field_150355_j && biomeID != Biome.func_185362_a((Biome)Biomes.field_76780_h) && biomeID != Biome.func_185362_a((Biome)Biomes.field_150599_m)) {
                        int n = waterPoolBiomeID;
                        biomeOccurrences[n] = biomeOccurrences[n] + 3;
                    } else if (topBlock2 == Blocks.field_150353_l) {
                        lavaOccurences += 6;
                    }
                }
                if (biomeID < 0 || biomeID >= biomeCount || Biome.func_185357_a((int)biomeID) == null) continue;
                int n = biomeID;
                biomeOccurrences[n] = biomeOccurrences[n] + this.priorityForBiome(Biome.func_185357_a((int)biomeID));
            }
        }
        int meanBiomeId = -1;
        int meanBiomeOccurences = 0;
        for (int i = 0; i < biomeOccurrences.length; ++i) {
            if (biomeOccurrences[i] <= meanBiomeOccurences) continue;
            meanBiomeId = i;
            meanBiomeOccurences = biomeOccurrences[i];
        }
        if (meanBiomeOccurences < lavaOccurences) {
            return ExtTileIdMap.instance().getPseudoBiomeID("lava");
        }
        return meanBiomeId;
    }
}

