/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.core.AtlasData;
import hunternif.mc.atlas.core.ITileStorage;
import hunternif.mc.atlas.core.Tile;
import hunternif.mc.atlas.core.TileGroup;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.client.TileGroupsPacket;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.Rect;
import hunternif.mc.atlas.util.ShortVec2;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class DimensionData
implements ITileStorage {
    public final AtlasData parent;
    public final int dimension;
    private int browsingX;
    private int browsingY;
    private double browsingZoom = 0.5;
    private final Map<ShortVec2, TileGroup> tileGroups = new ConcurrentHashMap<ShortVec2, TileGroup>(2, 0.75f, 2);
    private final Map<Thread, ShortVec2> thread2KeyMap = new ConcurrentHashMap<Thread, ShortVec2>(2, 0.75f, 2);
    private final Rect scope = new Rect();

    public DimensionData(AtlasData parent, int dimension) {
        this.parent = parent;
        this.dimension = dimension;
    }

    public Map<ShortVec2, Tile> getSeenChunks() {
        ConcurrentHashMap<ShortVec2, Tile> chunks = new ConcurrentHashMap<ShortVec2, Tile>(2, 0.75f, 2);
        Tile t = null;
        for (Map.Entry<ShortVec2, TileGroup> entry : this.tileGroups.entrySet()) {
            int basex = entry.getValue().getScope().minX;
            int basey = entry.getValue().getScope().minY;
            for (int x = basex; x < basex + 16; ++x) {
                for (int y = basey; y < basey + 16; ++y) {
                    t = entry.getValue().getTile(x, y);
                    if (t == null) continue;
                    chunks.put(new ShortVec2(x, y), t);
                }
            }
        }
        return chunks;
    }

    public void setBrowsingPosition(int x, int y, double zoom) {
        this.browsingX = x;
        this.browsingY = y;
        this.browsingZoom = zoom;
        if (this.browsingZoom <= 0.0) {
            Log.warn("Setting map zoom to invalid value of %f", zoom);
            this.browsingZoom = AntiqueAtlasMod.settings.minScale;
        }
        this.parent.func_76185_a();
    }

    public int getBrowsingX() {
        return this.browsingX;
    }

    public int getBrowsingY() {
        return this.browsingY;
    }

    public double getBrowsingZoom() {
        return this.browsingZoom;
    }

    private ShortVec2 getKey() {
        return this.thread2KeyMap.computeIfAbsent(Thread.currentThread(), k -> new ShortVec2(0, 0));
    }

    @Override
    public void setTile(int x, int y, Tile tile) {
        ShortVec2 groupPos = this.getKey().set((int)Math.floor((float)x / 16.0f), (int)Math.floor((float)y / 16.0f));
        TileGroup tg = this.tileGroups.get(groupPos);
        if (tg == null) {
            tg = new TileGroup(groupPos.x * 16, groupPos.y * 16);
            this.tileGroups.put(groupPos, tg);
        }
        tg.setTile(x, y, tile);
        this.scope.extendTo(x, y);
        this.parent.func_76185_a();
    }

    public void putTileGroup(TileGroup t) {
        ShortVec2 key = new ShortVec2(Math.floorDiv(t.scope.minX, 16), Math.floorDiv(t.scope.minY, 16));
        this.tileGroups.put(key, t);
        this.extendToTileGroup(t);
    }

    @Override
    public Tile removeTile(int x, int y) {
        return this.getTile(x, y);
    }

    @Override
    public Tile getTile(int x, int y) {
        ShortVec2 groupPos = this.getKey().set((int)Math.floor((float)x / 16.0f), (int)Math.floor((float)y / 16.0f));
        TileGroup tg = this.tileGroups.get(groupPos);
        if (tg == null) {
            return null;
        }
        return tg.getTile(x, y);
    }

    @Override
    public boolean hasTileAt(int x, int y) {
        return this.getTile(x, y) != null;
    }

    @Override
    public Rect getScope() {
        return this.scope;
    }

    public DimensionData clone() {
        DimensionData data = new DimensionData(this.parent, this.dimension);
        data.tileGroups.putAll(this.tileGroups);
        data.scope.set(this.scope);
        return data;
    }

    public void addData(DimensionData other) {
        for (Map.Entry<ShortVec2, TileGroup> e : other.tileGroups.entrySet()) {
            TileGroup group = e.getValue();
            Rect s = group.getScope();
            for (int x = s.minX; x <= s.maxX; ++x) {
                for (int y = s.minY; y <= s.maxY; ++y) {
                    Tile tile = group.getTile(x, y);
                    if (tile == null) continue;
                    this.setTile(x, y, tile);
                }
            }
        }
    }

    public NBTTagList writeToNBT() {
        NBTTagList tileGroupList = new NBTTagList();
        for (Map.Entry<ShortVec2, TileGroup> entry : this.tileGroups.entrySet()) {
            NBTTagCompound newbie = new NBTTagCompound();
            entry.getValue().writeToNBT(newbie);
            tileGroupList.func_74742_a((NBTBase)newbie);
        }
        return tileGroupList;
    }

    private void extendToTileGroup(TileGroup tg) {
        for (int x = tg.scope.minX; x <= tg.scope.maxX; ++x) {
            for (int y = tg.scope.minY; y <= tg.scope.maxY; ++y) {
                if (!tg.hasTileAt(x, y)) continue;
                this.scope.extendTo(x, y);
            }
        }
    }

    public void readFromNBT(NBTTagList me) {
        if (me == null) {
            return;
        }
        for (int d = 0; d < me.func_74745_c(); ++d) {
            NBTTagCompound tgTag = me.func_150305_b(d);
            TileGroup tg = new TileGroup(0, 0);
            tg.readFromNBT(tgTag);
            this.putTileGroup(tg);
        }
    }

    public void syncOnPlayer(int atlasID, EntityPlayer player) {
        Log.info("Sending dimension #%d", this.dimension);
        ArrayList<TileGroup> tgs = new ArrayList<TileGroup>(100);
        int count = 0;
        int total = 0;
        for (Map.Entry<ShortVec2, TileGroup> t : this.tileGroups.entrySet()) {
            tgs.add(t.getValue());
            ++total;
            if (++count < 100) continue;
            TileGroupsPacket p = new TileGroupsPacket(tgs, atlasID, this.dimension);
            PacketDispatcher.sendTo(p, (EntityPlayerMP)player);
            tgs.clear();
            count = 0;
        }
        if (count > 0) {
            TileGroupsPacket p = new TileGroupsPacket(tgs, atlasID, this.dimension);
            PacketDispatcher.sendTo(p, (EntityPlayerMP)player);
        }
        Log.info("Sent dimension #%d (%d tiles)", this.dimension, total);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DimensionData)) {
            return false;
        }
        DimensionData other = (DimensionData)obj;
        if (other.tileGroups.size() != this.tileGroups.size()) {
            return false;
        }
        for (ShortVec2 entry : this.tileGroups.keySet()) {
            if (this.tileGroups.get(entry).equals(other.tileGroups.get(entry))) continue;
            return false;
        }
        return true;
    }
}

