/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.bidirectional;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.core.AtlasData;
import hunternif.mc.atlas.core.Tile;
import hunternif.mc.atlas.network.AbstractMessage;
import hunternif.mc.atlas.util.Log;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class PutBiomeTilePacket
extends AbstractMessage<PutBiomeTilePacket> {
    private int atlasID;
    private int dimension;
    private int x;
    private int z;
    private int biomeID;

    public PutBiomeTilePacket() {
    }

    public PutBiomeTilePacket(int atlasID, int dimension, int x, int z, int biomeID) {
        this.atlasID = atlasID;
        this.dimension = dimension;
        this.x = x;
        this.z = z;
        this.biomeID = biomeID;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.atlasID = buffer.func_150792_a();
        this.dimension = buffer.func_150792_a();
        this.x = buffer.func_150792_a();
        this.z = buffer.func_150792_a();
        this.biomeID = buffer.func_150792_a();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.func_150787_b(this.atlasID);
        buffer.func_150787_b(this.dimension);
        buffer.func_150787_b(this.x);
        buffer.func_150787_b(this.z);
        buffer.func_150787_b(this.biomeID);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        if (side.isServer()) {
            if (AntiqueAtlasMod.settings.itemNeeded && !player.field_71071_by.func_70431_c(new ItemStack((Item)AntiqueAtlasMod.itemAtlas, 1, this.atlasID))) {
                Log.warn("Player %s attempted to modify someone else's Atlas #%d", player.func_146103_bH().getName(), this.atlasID);
                return;
            }
            AtlasAPI.tiles.putBiomeTile(player.func_130014_f_(), this.atlasID, this.biomeID, this.x, this.z);
        } else {
            AtlasData data = AntiqueAtlasMod.atlasData.getAtlasData(this.atlasID, player.func_130014_f_());
            data.setTile(this.dimension, this.x, this.z, new Tile(this.biomeID));
        }
    }
}

