/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class AtlasRenderHelper {
    public static void drawTexturedRect(ResourceLocation texture, double x, double y, double u, double v, int width, int height, int imageWidth, int imageHeight, double scaleX, double scaleY) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        double minU = u / (double)imageWidth;
        double maxU = (u + (double)width) / (double)imageWidth;
        double minV = v / (double)imageHeight;
        double maxV = (v + (double)height) / (double)imageHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b((double)((int)(x + scaleX * (double)width)), (double)((int)(y + scaleY * (double)height)), 0.0).func_187315_a(maxU, maxV).func_181675_d();
        renderer.func_181662_b((double)((int)(x + scaleX * (double)width)), (double)((int)y), 0.0).func_187315_a(maxU, minV).func_181675_d();
        renderer.func_181662_b((double)((int)x), (double)((int)y), 0.0).func_187315_a(minU, minV).func_181675_d();
        renderer.func_181662_b((double)((int)x), (double)((int)(y + scaleY * (double)height)), 0.0).func_187315_a(minU, maxV).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedRect(ResourceLocation texture, double x, double y, int u, int v, int width, int height, int imageWidth, int imageHeight) {
        AtlasRenderHelper.drawTexturedRect(texture, x, y, u, v, width, height, imageWidth, imageHeight, 1.0, 1.0);
    }

    private static void drawFullTexture(ResourceLocation texture, double x, double y, int width, int height, double scaleX, double scaleY) {
        AtlasRenderHelper.drawTexturedRect(texture, x, y, 0.0, 0.0, width, height, width, height, scaleX, scaleY);
    }

    public static void drawFullTexture(ResourceLocation texture, double x, double y, int width, int height) {
        AtlasRenderHelper.drawFullTexture(texture, x, y, width, height, 1.0, 1.0);
    }

    public static void drawAutotileCorner(ResourceLocation texture, int x, int y, double u, double v, int tileHalfSize) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        double minU = u / 4.0;
        double maxU = (u + 1.0) / 4.0;
        double minV = v / 6.0;
        double maxV = (v + 1.0) / 6.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b((double)(x + tileHalfSize), (double)(y + tileHalfSize), 0.0).func_187315_a(maxU, maxV).func_181675_d();
        renderer.func_181662_b((double)(x + tileHalfSize), (double)y, 0.0).func_187315_a(maxU, minV).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(minU, minV).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + tileHalfSize), 0.0).func_187315_a(minU, maxV).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void setGLColor(int color, float alpha) {
        float r = (float)(color >> 16 & 0xFF) / 256.0f;
        float g = (float)(color >> 8 & 0xFF) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)alpha);
    }
}

