/*
 * Decompiled with CFR 0.152.
 */
package kenkron.antiqueatlasoverlay;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.SubTile;
import hunternif.mc.atlas.client.SubTileQuartet;
import hunternif.mc.atlas.client.Textures;
import hunternif.mc.atlas.client.TileRenderIterator;
import hunternif.mc.atlas.client.gui.GuiAtlas;
import hunternif.mc.atlas.core.DimensionData;
import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.registry.MarkerRegistry;
import hunternif.mc.atlas.registry.MarkerRenderInfo;
import hunternif.mc.atlas.registry.MarkerType;
import hunternif.mc.atlas.registry.MarkerTypes;
import hunternif.mc.atlas.util.AtlasRenderHelper;
import hunternif.mc.atlas.util.Rect;
import java.util.List;
import kenkron.antiqueatlasoverlay.AAOConfig;
import kenkron.antiqueatlasoverlay.SetTileRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

class AAORenderEventReceiver {
    private static final int CHUNK_SIZE = 16;
    float BORDER_X = 0.0f;
    float BORDER_Y = 0.0f;
    int TILE_SIZE = 8;
    int X = 2;
    int Y = 2;
    int WIDTH = 155;
    int HEIGHT = 109;
    boolean ALIGN_RIGHT = true;
    boolean ALIGN_BOTTOM = false;
    boolean REQUIRES_HOLD = true;
    boolean ENABLED = true;
    int MARKER_SIZE = 16;
    int PLAYER_ICON_WIDTH = 7;
    int PLAYER_ICON_HEIGHT = 8;
    private int screenScale = 1;
    private ScaledResolution res;

    AAORenderEventReceiver() {
    }

    private static Integer getPlayerAtlas(EntityPlayer player) {
        if (!AntiqueAtlasMod.settings.itemNeeded) {
            return player.func_110124_au().hashCode();
        }
        ItemStack stack = player.func_184592_cb();
        if (stack != null && stack.func_77973_b() == AntiqueAtlasMod.itemAtlas) {
            return stack.func_77952_i();
        }
        for (int i = 0; i < 9; ++i) {
            stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != AntiqueAtlasMod.itemAtlas) continue;
            return stack.func_77952_i();
        }
        return null;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void eventHandler(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!this.ENABLED) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiAtlas) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Integer atlas = null;
        if (this.REQUIRES_HOLD) {
            ItemStack stack = player.func_184614_ca();
            ItemStack stack2 = player.func_184592_cb();
            if (stack != null && stack.func_77973_b() == AntiqueAtlasMod.itemAtlas) {
                atlas = stack.func_77952_i();
            } else if (stack2 != null && stack2.func_77973_b() == AntiqueAtlasMod.itemAtlas) {
                atlas = stack2.func_77952_i();
            }
        } else {
            atlas = AAORenderEventReceiver.getPlayerAtlas((EntityPlayer)player);
        }
        if (atlas != null) {
            int gameWidth = event.getResolution().func_78326_a();
            int gameHeight = event.getResolution().func_78328_b();
            Rect bounds = new Rect().setOrigin(this.X, this.Y);
            if (this.ALIGN_RIGHT) {
                bounds.minX = gameWidth - (this.WIDTH + this.X);
            }
            if (this.ALIGN_BOTTOM) {
                bounds.minY = gameHeight - (this.HEIGHT + this.Y);
            }
            bounds.setSize(this.WIDTH, this.HEIGHT);
            this.res = event.getResolution();
            this.drawMinimap(bounds, atlas, player.func_174791_d(), player.func_70079_am(), player.field_71093_bK);
        }
    }

    private void drawMinimap(Rect shape, int atlasID, Vec3d position, float rotation, int dimension) {
        this.screenScale = new ScaledResolution(Minecraft.func_71410_x()).func_78325_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        AtlasRenderHelper.drawFullTexture(Textures.BOOK, shape.minX, shape.minY, shape.getWidth(), shape.getHeight());
        Rect innerShape = new Rect(shape.minX + Math.round(this.BORDER_X * (float)shape.getWidth()), shape.minY + Math.round(this.BORDER_Y * (float)shape.getHeight()), shape.maxX - Math.round(this.BORDER_X * (float)shape.getWidth()), shape.maxY - Math.round(this.BORDER_Y * (float)shape.getHeight()));
        this.drawTiles(innerShape, atlasID, position, dimension);
        if (this.MARKER_SIZE > 0) {
            this.drawMarkers(innerShape, atlasID, position, dimension);
            int shapeMiddleX = (shape.minX + shape.maxX) / 2;
            int shapeMiddleY = (shape.minY + shape.maxY) / 2;
            this.drawPlayer(shapeMiddleX, shapeMiddleY, rotation);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AtlasRenderHelper.drawFullTexture(Textures.BOOK_FRAME, shape.minX, shape.minY, shape.getWidth(), shape.getHeight());
        GlStateManager.func_179084_k();
    }

    private void drawTiles(Rect shape, int atlasID, Vec3d position, int dimension) {
        GL11.glEnable((int)3089);
        this.glScissorGUI(shape);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        DimensionData biomeData = AntiqueAtlasMod.atlasData.getAtlasData(atlasID, (World)Minecraft.func_71410_x().field_71441_e).getDimensionData(dimension);
        TileRenderIterator iter = new TileRenderIterator(biomeData);
        Rect iteratorScope = this.getChunkCoverage(position, shape);
        iter.setScope(iteratorScope);
        iter.setStep(1);
        Vec3d chunkPosition = new Vec3d(position.field_72450_a / 16.0, position.field_72448_b / 16.0, position.field_72449_c / 16.0);
        int shapeMiddleX = (shape.minX + shape.maxX) / 2;
        int shapeMiddleY = (shape.minY + shape.maxY) / 2;
        SetTileRenderer renderer = new SetTileRenderer(this.TILE_SIZE / 2);
        while (iter.hasNext()) {
            SubTileQuartet subtiles = iter.next();
            for (SubTile subtile : subtiles) {
                if (subtile == null || subtile.tile == null) continue;
                float relativeChunkPositionX = (float)((double)subtile.x / 2.0 + (double)iteratorScope.minX - chunkPosition.field_72450_a);
                float relativeChunkPositionY = (float)((double)subtile.y / 2.0 + (double)iteratorScope.minY - chunkPosition.field_72449_c);
                renderer.addTileCorner(BiomeTextureMap.instance().getTexture(subtile.tile), shapeMiddleX + (int)Math.floor(relativeChunkPositionX * (float)this.TILE_SIZE), shapeMiddleY + (int)Math.floor(relativeChunkPositionY * (float)this.TILE_SIZE), subtile.getTextureU(), subtile.getTextureV());
            }
        }
        renderer.draw();
        GL11.glDisable((int)3089);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawMarkers(Rect shape, int atlasID, Vec3d position, int dimension) {
        GL11.glEnable((int)3089);
        this.glScissorGUI(shape);
        DimensionData biomeData = AntiqueAtlasMod.atlasData.getAtlasData(atlasID, (World)Minecraft.func_71410_x().field_71441_e).getDimensionData(dimension);
        DimensionMarkersData globalMarkersData = AntiqueAtlasMod.globalMarkersData.getData().getMarkersDataInDimension(dimension);
        this.drawMarkersData(globalMarkersData, shape, biomeData, position);
        MarkersData markersData = AntiqueAtlasMod.markersData.getMarkersData(atlasID, (World)Minecraft.func_71410_x().field_71441_e);
        DimensionMarkersData localMarkersData = null;
        if (markersData != null) {
            localMarkersData = markersData.getMarkersDataInDimension(dimension);
        }
        this.drawMarkersData(localMarkersData, shape, biomeData, position);
        GL11.glDisable((int)3089);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawPlayer(float x, float y, float rotation) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f + rotation), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(-this.PLAYER_ICON_WIDTH / 2), (float)(-this.PLAYER_ICON_HEIGHT / 2), (float)0.0f);
        AtlasRenderHelper.drawFullTexture(Textures.PLAYER, 0.0, 0.0, this.PLAYER_ICON_WIDTH, this.PLAYER_ICON_HEIGHT);
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawMarkersData(DimensionMarkersData markersData, Rect shape, DimensionData biomeData, Vec3d position) {
        Rect markerShape = new Rect(shape.minX - this.MARKER_SIZE / 2, shape.minY - this.MARKER_SIZE / 2, shape.maxX + this.MARKER_SIZE / 2, shape.maxY + this.MARKER_SIZE / 2);
        Rect mcchunks = this.getChunkCoverage(position, markerShape);
        Rect chunks = new Rect((int)Math.floor(mcchunks.minX / 8), (int)Math.floor(mcchunks.minY / 8), (int)Math.ceil(mcchunks.maxX / 8), (int)Math.ceil(mcchunks.maxY / 8));
        int shapeMiddleX = (shape.minX + shape.maxX) / 2;
        int shapeMiddleY = (shape.minY + shape.maxY) / 2;
        for (int x = chunks.minX; x <= chunks.maxX; ++x) {
            for (int z = chunks.minY; z <= chunks.maxY; ++z) {
                List<Marker> markers = markersData.getMarkersAtChunk(Math.round(x), Math.round(z));
                if (markers == null) continue;
                for (Marker marker : markers) {
                    int relativeChunkPositionX = this.TILE_SIZE * (2 * (marker.getX() / 2) - 2 * (int)Math.floor(position.field_72450_a / 2.0)) / 16;
                    int relativeChunkPositionY = this.TILE_SIZE * (2 * (marker.getZ() / 2) - 2 * (int)Math.floor(position.field_72449_c / 2.0)) / 16;
                    int guiX = (int)Math.floor(shapeMiddleX - this.MARKER_SIZE / 2 + relativeChunkPositionX);
                    int guiY = (int)Math.floor(shapeMiddleY - this.MARKER_SIZE / 2 + relativeChunkPositionY);
                    this.renderMarker(marker, guiX, guiY, biomeData);
                }
            }
        }
    }

    private void renderMarker(Marker marker, int x, int y, DimensionData biomeData) {
        if (!marker.isVisibleAhead() && !biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ())) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MarkerType m = MarkerRegistry.find(marker.getType());
        if (m == null) {
            m = MarkerTypes.UNKNOWN;
        }
        MarkerRenderInfo info = m.getRenderInfo(1.0, this.TILE_SIZE, this.screenScale);
        AtlasRenderHelper.drawFullTexture(info.tex, x, y, this.MARKER_SIZE, this.MARKER_SIZE);
    }

    private Rect getChunkCoverage(Vec3d position, Rect windowShape) {
        int minChunkX = (int)Math.floor(position.field_72450_a / 16.0 - (double)((float)windowShape.getWidth() / (2.0f * (float)this.TILE_SIZE)));
        int minChunkY = (int)Math.floor(position.field_72449_c / 16.0 - (double)((float)windowShape.getHeight() / (2.0f * (float)this.TILE_SIZE)));
        int maxChunkX = (int)Math.ceil(position.field_72450_a / 16.0 + (double)((float)windowShape.getWidth() / (2.0f * (float)this.TILE_SIZE)));
        int maxChunkY = (int)Math.ceil(position.field_72449_c / 16.0 + (double)((float)windowShape.getHeight() / (2.0f * (float)this.TILE_SIZE)));
        return new Rect(--minChunkX, --minChunkY, ++maxChunkX, ++maxChunkY);
    }

    private void glScissorGUI(Rect shape) {
        int mcHeight = Minecraft.func_71410_x().field_71440_d;
        float scissorScaleX = (float)Minecraft.func_71410_x().field_71443_c * 1.0f / (float)this.res.func_78326_a();
        float scissorScaleY = (float)mcHeight * 1.0f / (float)this.res.func_78328_b();
        GL11.glScissor((int)((int)((float)shape.minX * scissorScaleX)), (int)((int)((float)mcHeight - (float)shape.maxY * scissorScaleY)), (int)((int)((float)shape.getWidth() * scissorScaleX)), (int)((int)((float)shape.getHeight() * scissorScaleY)));
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("antiqueatlasoverlay")) {
            AAOConfig.sync(this);
        }
    }
}

