/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.ArrayList;
import java.util.List;
import jds.bibliocraft.blocks.BiblioSimpleBlock;
import jds.bibliocraft.gui.GuiTypesetting;
import jds.bibliocraft.items.ItemChase;
import jds.bibliocraft.items.ItemPlate;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityTypeMachine;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTypesettingTable
extends BiblioSimpleBlock {
    public static final BlockTypesettingTable instance = new BlockTypesettingTable();
    public static final String name = "TypesettingTable";

    public BlockTypesettingTable() {
        super(Material.field_151575_d, SoundType.field_185848_a, name);
    }

    public static int getSlot(TileEntityTypeMachine tile, EnumFacing face, float hitX, float hitZ) {
        int output = -2;
        if (face != EnumFacing.UP) {
            return output;
        }
        float adjustedX = hitX;
        float adjustedZ = hitZ;
        switch (tile.getAngle()) {
            case WEST: {
                adjustedX = hitZ;
                adjustedZ = 1.0f - hitX;
                break;
            }
            case NORTH: {
                adjustedX = 1.0f - hitX;
                adjustedZ = 1.0f - hitZ;
                break;
            }
            case EAST: {
                adjustedX = 1.0f - hitZ;
                adjustedZ = hitX;
                break;
            }
        }
        output = -1;
        if (adjustedX <= 0.41f) {
            output = adjustedZ <= 0.5f ? 0 : 2;
        } else if ((double)adjustedX >= 0.57 && adjustedZ > 0.3f && adjustedZ < 0.7f) {
            output = 1;
        }
        return output;
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        int iCheck = (int)(hitX * 2.0f);
        int iCheck2 = (int)(hitX * 3.0f);
        int kCheck = (int)(hitZ * 3.0f);
        int kCheck2 = (int)(hitZ * 2.0f);
        TileEntity t = world.func_175625_s(pos);
        if (t != null && t instanceof TileEntityTypeMachine) {
            TileEntityTypeMachine tile = (TileEntityTypeMachine)t;
            int slot = BlockTypesettingTable.getSlot(tile, side, hitX, hitZ);
            if (!world.field_72995_K) {
                ItemStack playerhand = player.func_184586_b(EnumHand.MAIN_HAND);
                switch (slot) {
                    case 0: {
                        if (player.func_70093_af()) {
                            if (!this.plateResetorSaveBook(tile, world, player)) break;
                            tile.booklistset();
                            break;
                        }
                        if (this.addBookorPlate(tile, player, world)) break;
                        tile.removeStackFromInventoryFromWorld(slot, player, this);
                        break;
                    }
                    case 1: {
                        boolean addedStack = false;
                        if (playerhand != null && playerhand.func_77973_b() instanceof ItemChase) {
                            addedStack = tile.addStackToInventoryFromWorld(playerhand, slot, player);
                        }
                        if (addedStack) break;
                        tile.removeStackFromInventoryFromWorld(slot, player, this);
                        break;
                    }
                    case 2: {
                        tile.removeStackFromInventoryFromWorld(slot, player, this);
                    }
                }
            } else if (slot == -1) {
                this.openGUI(player, tile);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void openGUI(EntityPlayer player, TileEntityTypeMachine tile) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTypesetting(player, tile));
    }

    public boolean addBookorPlate(TileEntityTypeMachine tile, EntityPlayer player, World world) {
        boolean hasAdded;
        ItemStack playerhand = player.func_184586_b(EnumHand.MAIN_HAND);
        if (playerhand != null && (hasAdded = tile.addBookorPlate(playerhand, world))) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            return true;
        }
        return false;
    }

    public boolean plateResetorSaveBook(TileEntityTypeMachine tile, World world, EntityPlayer player) {
        boolean hasReset = tile.resetPlate();
        boolean hasSavedBook = tile.saveBook(world);
        boolean hasEnchantedBook = tile.enchantPlate(player);
        boolean hasAtlas = tile.createAtlasPlate(player);
        return hasReset || hasSavedBook || hasEnchantedBook || hasAtlas;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityTypeMachine();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return this.getBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.92f, 1.0f);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        boolean output = true;
        if (side == EnumFacing.UP) {
            output = false;
        }
        return output;
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ItemStack plate;
        ItemStack chase;
        ArrayList<String> modelParts = new ArrayList<String>();
        modelParts.add("base");
        ItemStack book = tile.func_70301_a(0);
        if (book != null) {
            if (book.func_77973_b() instanceof ItemPlate) {
                modelParts.add("plateLeft");
            } else if (tile instanceof TileEntityTypeMachine) {
                TileEntityTypeMachine type = (TileEntityTypeMachine)tile;
                if (type.bookIsSaved) {
                    modelParts.add("bookBlue");
                } else if (type.enchantedBookCheck()) {
                    modelParts.add("bookEnchant");
                } else {
                    modelParts.add("bookRed");
                }
            }
        }
        if ((chase = tile.func_70301_a(1)) != null) {
            if (chase.field_77994_a > 0) {
                modelParts.add("chase1");
            }
            if (chase.field_77994_a > 16) {
                modelParts.add("chase2");
            }
            if (chase.field_77994_a > 32) {
                modelParts.add("chase3");
            }
            if (chase.field_77994_a > 48) {
                modelParts.add("chase4");
            }
        }
        if ((plate = tile.func_70301_a(2)) != null) {
            modelParts.add("plateRight");
        }
        return modelParts;
    }
}

