/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.villagerinventory;

import net.crazysnailboy.mods.villagerinventory.client.init.ModKeyBindings;
import net.crazysnailboy.mods.villagerinventory.common.config.ModConfiguration;
import net.crazysnailboy.mods.villagerinventory.common.network.ModGuiHandler;
import net.crazysnailboy.mods.villagerinventory.common.network.message.ConfigSyncMessage;
import net.crazysnailboy.mods.villagerinventory.common.network.message.EntityFlagMessage;
import net.crazysnailboy.mods.villagerinventory.common.network.message.VillagerCareerMessage;
import net.crazysnailboy.mods.villagerinventory.util.EntityUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="villagerinventory", name="Villager Inventory Viewer", version="1.0.5", updateJSON="https://raw.githubusercontent.com/crazysnailboy/VillagerInventory/master/update.json", guiFactory="net.crazysnailboy.mods.villagerinventory.client.config.ModGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class VillagerInventoryMod {
    public static final String MODID = "villagerinventory";
    public static final String NAME = "Villager Inventory Viewer";
    public static final String VERSION = "1.0.5";
    public static final String GUIFACTORY = "net.crazysnailboy.mods.villagerinventory.client.config.ModGuiFactory";
    public static final String UPDATEJSON = "https://raw.githubusercontent.com/crazysnailboy/VillagerInventory/master/update.json";
    @Mod.Instance(value="villagerinventory")
    public static VillagerInventoryMod INSTANCE;
    public static final Logger LOGGER;
    public static final SimpleNetworkWrapper NETWORK;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModConfiguration.initializeConfiguration();
        if (event.getSide() == Side.CLIENT) {
            ModKeyBindings.registerKeyBindings();
        }
        NETWORK.registerMessage(VillagerCareerMessage.MessageHandler.class, VillagerCareerMessage.class, 0, Side.CLIENT);
        NETWORK.registerMessage(ConfigSyncMessage.MessageHandler.class, ConfigSyncMessage.class, 1, Side.CLIENT);
        NETWORK.registerMessage(ConfigSyncMessage.MessageHandler.class, ConfigSyncMessage.class, 2, Side.SERVER);
        NETWORK.registerMessage(EntityFlagMessage.MessageHandler.class, EntityFlagMessage.class, 3, Side.SERVER);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new ModGuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
    }

    @Mod.EventBusSubscriber
    public static class EventHandlers {
        @SubscribeEvent
        public static void onPlayerEntityInteract(PlayerInteractEvent.EntityInteract event) {
            if (ModConfiguration.enableInventoryGui && event.getTarget() instanceof EntityVillager && EntityUtils.getFlag((Entity)event.getEntityPlayer(), 2) && (!ModConfiguration.requireEmptyHand || ModConfiguration.requireEmptyHand && event.getEntityPlayer().field_71071_by.func_70448_g() == null)) {
                if (!event.getWorld().field_72995_K) {
                    EntityVillager villager = (EntityVillager)event.getTarget();
                    int entityId = villager.func_145782_y();
                    NBTTagCompound compound = new NBTTagCompound();
                    villager.func_70014_b(compound);
                    int professionId = compound.func_74762_e("Profession");
                    int careerId = compound.func_74762_e("Career");
                    NETWORK.sendTo((IMessage)new VillagerCareerMessage(entityId, careerId), (EntityPlayerMP)event.getEntityPlayer());
                    FMLNetworkHandler.openGui((EntityPlayer)event.getEntityPlayer(), (Object)INSTANCE, (int)0, (World)event.getWorld(), (int)entityId, (int)professionId, (int)careerId);
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onEntityDeath(LivingDeathEvent event) {
            if (ModConfiguration.enableDeathDrops && event.getEntityLiving() instanceof EntityVillager && event.getSource().func_76364_f() instanceof EntityPlayerMP) {
                InventoryBasic inventory = ((EntityVillager)event.getEntityLiving()).func_175551_co();
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (stack == null) continue;
                    event.getEntityLiving().func_70099_a(stack, 0.0f);
                }
            }
        }
    }
}

