/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.villagerinventory.client.config;

import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ModGuiConfigEntries {

    public static class BooleanEntry
    extends GuiConfigEntries.ButtonEntry {
        protected final boolean beforeValue;
        protected boolean currentValue;

        public BooleanEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.currentValue = this.beforeValue = Boolean.valueOf(configElement.get().toString()).booleanValue();
            this.btnValue.field_146124_l = this.enabled();
            this.updateValueButtonText();
        }

        public void updateValueButtonText() {
            this.btnValue.field_146126_j = I18n.func_135052_a((String)String.valueOf(this.currentValue), (Object[])new Object[0]);
            this.btnValue.packedFGColour = this.currentValue ? GuiUtils.getColorCode((char)'2', (boolean)true) : GuiUtils.getColorCode((char)'4', (boolean)true);
        }

        public void valueButtonPressed(int slotIndex) {
            if (this.enabled()) {
                this.currentValue = !this.currentValue;
            }
        }

        public boolean isDefault() {
            return this.currentValue == Boolean.valueOf(this.configElement.getDefault().toString());
        }

        public void setToDefault() {
            if (this.enabled()) {
                this.currentValue = Boolean.valueOf(this.configElement.getDefault().toString());
                this.updateValueButtonText();
            }
        }

        public boolean isChanged() {
            return this.currentValue != this.beforeValue;
        }

        public void undoChanges() {
            if (this.enabled()) {
                this.currentValue = this.beforeValue;
                this.updateValueButtonText();
            }
        }

        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set((Object)this.currentValue);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        public Boolean getCurrentValue() {
            return this.currentValue;
        }

        public Boolean[] getCurrentValues() {
            return new Boolean[]{this.getCurrentValue()};
        }
    }
}

